/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.plugin.CordovaPlugin;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PluginUninstallAction
extends Action {
    private static final String CONFIRM_DIALOG_TITLE = "Uninstall Cordova plug-in(s)";
    private CordovaPlugin plugin;

    public PluginUninstallAction() {
        super("Uninstall Cordova plug-in");
    }

    public PluginUninstallAction(CordovaPlugin cordovaPlugin) {
        this();
        this.plugin = cordovaPlugin;
    }

    public void run() {
        final ArrayList<CordovaPlugin> pluginsToRemove = new ArrayList<CordovaPlugin>();
        if (this.plugin != null) {
            pluginsToRemove.add(this.plugin);
        } else {
            IStructuredSelection selection = this.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            for (Object o : selection) {
                if (!(o instanceof CordovaPlugin)) continue;
                pluginsToRemove.add((CordovaPlugin)o);
            }
        }
        if (pluginsToRemove.isEmpty()) {
            return;
        }
        String message = null;
        message = pluginsToRemove.size() == 1 ? NLS.bind((String)"Are you sure you want to uninstall {0} plug-in?", (Object[])new String[]{((CordovaPlugin)pluginsToRemove.get(0)).getId()}) : NLS.bind((String)"Are you sure you want to uninstall the selected {0} plug-ins?", (Object[])new String[]{Integer.toString(pluginsToRemove.size())});
        if (!MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CONFIRM_DIALOG_TITLE, (String)message)) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        for (CordovaPlugin cordovaPlugin : pluginsToRemove) {
                            HybridProject project = HybridProject.getHybridProject((IProject)cordovaPlugin.getFolder().getProject());
                            monitor.subTask(NLS.bind((String)"Uninstalling {0}", (Object)cordovaPlugin.getId()));
                            project.getPluginManager().unInstallPlugin(cordovaPlugin.getId(), monitor);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getTargetException() != null) {
                t = e.getTargetException();
            }
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error removing Cordova plug-in", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Error when removing the Cordova plug-in", t));
        }
        catch (InterruptedException e) {
            HybridUI.log(4, "Error while removing a Cordova plugin ", e);
        }
    }

    private IStructuredSelection getSelection() {
        ISelection selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }
}

