/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.export;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.thym.core.platform.AbstractNativeBinaryBuildDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class NativeBinaryExportOperation
extends WorkspaceModifyOperation {
    private List<AbstractNativeBinaryBuildDelegate> delegates;
    private IOverwriteQuery overwriteQuery;
    private File destinationDir;

    public NativeBinaryExportOperation(List<AbstractNativeBinaryBuildDelegate> delegates, File destination, IOverwriteQuery query) {
        this.delegates = delegates;
        this.overwriteQuery = query;
        this.destinationDir = destination;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask("Build native binaries", this.delegates.size() * 2);
        for (AbstractNativeBinaryBuildDelegate delegate : this.delegates) {
            if (monitor.isCanceled()) break;
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            subMonitor.setTaskName("Building " + delegate.getProject().getName());
            delegate.setRelease(true);
            delegate.buildNow((IProgressMonitor)subMonitor);
            try {
                File artifact;
                File buildArtifact = delegate.getBuildArtifact();
                File destinationFile = new File(this.destinationDir, buildArtifact.getName());
                if (destinationFile.exists()) {
                    String callback = this.overwriteQuery.queryOverwrite(destinationFile.toString());
                    if ("NO".equals(callback)) continue;
                    if ("CANCEL".equals(callback)) break;
                }
                if ((artifact = delegate.getBuildArtifact()).isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)artifact, (File)this.destinationDir);
                } else {
                    FileUtils.copyFileToDirectory((File)artifact, (File)this.destinationDir);
                }
                monitor.worked(1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        monitor.done();
    }
}

