/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.export;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.thym.core.platform.AbstractProjectGeneratorDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class NativeProjectExportOperation
extends WorkspaceModifyOperation {
    private List<AbstractProjectGeneratorDelegate> generators;
    private MultiStatus status;
    private IOverwriteQuery overwriteCall;

    public NativeProjectExportOperation(List<AbstractProjectGeneratorDelegate> delegates, IOverwriteQuery overwriteCall) {
        this.generators = delegates;
        this.overwriteCall = overwriteCall;
        this.status = new MultiStatus("org.eclipse.thym.ui", 0, "", null);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            int totalWork = this.generators.size();
            monitor.beginTask("Generate Native Projects", totalWork);
            boolean overwriteAll = false;
            boolean noOverwrite = false;
            for (AbstractProjectGeneratorDelegate generator : this.generators) {
                if (monitor.isCanceled()) {
                    return;
                }
                File destination = generator.getDestination();
                if (this.overwriteCall != null && destination.exists() && !overwriteAll) {
                    if (noOverwrite) {
                        monitor.worked(1);
                        continue;
                    }
                    String callback = this.overwriteCall.queryOverwrite(destination.toString());
                    if ("NO".equals(callback)) {
                        monitor.worked(1);
                        continue;
                    }
                    if ("NOALL".equals(callback)) {
                        monitor.worked(1);
                        noOverwrite = true;
                        continue;
                    }
                    if ("ALL".equals(callback)) {
                        overwriteAll = true;
                    }
                    if ("CANCEL".equals(callback)) {
                        return;
                    }
                }
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                this.runSingle((IProgressMonitor)subMonitor, generator);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void runSingle(IProgressMonitor monitor, AbstractProjectGeneratorDelegate generator) {
        try {
            generator.generateNow(monitor);
        }
        catch (CoreException e) {
            this.addToStatus(e);
        }
    }

    private void addToStatus(CoreException e) {
        IStatus status = e.getStatus();
        String message = e.getLocalizedMessage();
        if (message == null || message.isEmpty()) {
            message = "Error during native project export operation";
            status = new Status(4, "org.eclipse.thym.ui", message, (Throwable)e);
        }
        this.status.add(status);
    }

    public MultiStatus getStatus() {
        return this.status;
    }
}

