/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.collect;

import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.common.core.Activator;

public class BufferedBlockingQueue<T>
implements Iterable<T> {
    private final BlockingDeque<Deque<T>> fInnerQueue;
    private final Lock fInputLock = new ReentrantLock();
    private final Lock fOutputLock = new ReentrantLock();
    private final int fChunkSize;
    private Deque<T> fInputBuffer;
    private Deque<T> fOutputBuffer;
    private int fInputBufferSize;
    private final AtomicInteger fSize = new AtomicInteger(0);
    private final Condition fInnerQueueNotEmpty = NonNullUtils.checkNotNull(this.fOutputLock.newCondition());

    public BufferedBlockingQueue(int queueSize, int chunkSize) {
        this.fInnerQueue = new LinkedBlockingDeque<Deque<T>>(queueSize + 1);
        this.fChunkSize = chunkSize;
        this.fInputBuffer = new ConcurrentLinkedDeque<T>();
        this.fOutputBuffer = new ConcurrentLinkedDeque<T>();
        this.fInnerQueue.add(this.fOutputBuffer);
    }

    public void put(T element) {
        this.fInputLock.lock();
        try {
            this.fInputBuffer.add(element);
            this.fSize.incrementAndGet();
            ++this.fInputBufferSize;
            if (this.fInputBufferSize >= this.fChunkSize) {
                this.flushInputBuffer();
            }
        }
        finally {
            this.fInputLock.unlock();
        }
    }

    public void flushInputBuffer() {
        boolean signal;
        block10: {
            signal = false;
            this.fInputLock.lock();
            try {
                try {
                    if (!this.fInputBuffer.isEmpty()) {
                        this.fInnerQueue.put(this.fInputBuffer);
                        this.fInputBuffer = new ConcurrentLinkedDeque<T>();
                        this.fInputBufferSize = 0;
                        signal = true;
                    }
                }
                catch (InterruptedException e) {
                    Activator.instance().logError("Buffered queue interrupted", e);
                    this.fInputLock.unlock();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.fInputLock.unlock();
                throw throwable;
            }
            this.fInputLock.unlock();
        }
        if (signal) {
            this.fOutputLock.lock();
            try {
                this.fInnerQueueNotEmpty.signalAll();
            }
            finally {
                this.fOutputLock.unlock();
            }
        }
    }

    public T take() {
        this.fOutputLock.lock();
        try {
            if (this.fOutputBuffer.isEmpty()) {
                this.fInnerQueue.remove();
                while (this.fInnerQueue.isEmpty()) {
                    this.fInnerQueueNotEmpty.await();
                }
                this.fOutputBuffer = NonNullUtils.checkNotNull(this.fInnerQueue.peek());
            }
            T element = NonNullUtils.checkNotNull(this.fOutputBuffer.remove());
            this.fSize.decrementAndGet();
            T t = element;
            return t;
        }
        catch (InterruptedException e) {
            Activator.instance().logError("Buffered queue interrupted", e);
            throw new IllegalStateException();
        }
        finally {
            this.fOutputLock.unlock();
        }
    }

    public T blockingPeek() {
        this.fOutputLock.lock();
        try {
            if (this.fOutputBuffer.isEmpty()) {
                this.fInnerQueue.remove();
                while (this.fInnerQueue.isEmpty()) {
                    this.fInnerQueueNotEmpty.await();
                }
                this.fOutputBuffer = NonNullUtils.checkNotNull(this.fInnerQueue.peek());
            }
            T t = NonNullUtils.checkNotNull(this.fOutputBuffer.peek());
            return t;
        }
        catch (InterruptedException e) {
            Activator.instance().logError("Buffered queue interrupted", e);
            throw new IllegalStateException();
        }
        finally {
            this.fOutputLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.fSize.get() == 0;
    }

    public int size() {
        return this.fSize.get();
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<T> {
        @Nullable
        private T fNext = null;
        private Iterator<T> fBufferIterator;
        private final Iterator<Deque<T>> fQueueIterator;

        Itr() {
            BufferedBlockingQueue.this.fInputLock.lock();
            try {
                this.fBufferIterator = NonNullUtils.checkNotNull(BufferedBlockingQueue.this.fInputBuffer.descendingIterator());
                this.fQueueIterator = NonNullUtils.checkNotNull(BufferedBlockingQueue.this.fInnerQueue.descendingIterator());
            }
            finally {
                BufferedBlockingQueue.this.fInputLock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.fNext != null) {
                return true;
            }
            if (this.fBufferIterator.hasNext()) {
                this.fNext = this.fBufferIterator.next();
                return true;
            }
            if (this.fQueueIterator.hasNext()) {
                this.fBufferIterator = NonNullUtils.checkNotNull(this.fQueueIterator.next().descendingIterator());
                return this.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            Object next;
            if (this.hasNext() && (next = this.fNext) != null) {
                this.fNext = null;
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

