/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.EnableKernelEventComposite;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.EnableUstEventsComposite;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableEventsDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;

public class EnableEventsDialog
extends Dialog
implements IEnableEventsDialog {
    public static final String ENABLE_EVENT_ICON_FILE = "icons/elcl16/enable_event.gif";
    private Composite fDialogComposite;
    private EnableKernelEventComposite fKernelComposite;
    private EnableUstEventsComposite fUstComposite;
    private Button fKernelButton;
    private Button fUstButton;
    private TraceProviderGroup fProviderGroup;
    private TraceDomainComponent fDomain;
    private boolean fIsKernel;

    public EnableEventsDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    @Override
    public boolean isTracepoints() {
        if (this.fIsKernel) {
            return this.fKernelComposite.isTracepoints();
        }
        return this.fUstComposite.isTracepoints();
    }

    @Override
    public boolean isAllTracePoints() {
        if (this.fIsKernel) {
            return this.fKernelComposite.isAllTracePoints();
        }
        return this.fUstComposite.isAllTracePoints();
    }

    @Override
    public boolean isSysCalls() {
        if (this.fIsKernel) {
            return this.fKernelComposite.isSysCalls();
        }
        return false;
    }

    @Override
    public boolean isAllSysCalls() {
        if (this.fIsKernel) {
            return this.fKernelComposite.isSysCalls();
        }
        return false;
    }

    @Override
    public List<String> getEventNames() {
        if (this.fIsKernel) {
            return this.fKernelComposite.getEventNames();
        }
        return this.fUstComposite.getEventNames();
    }

    @Override
    public boolean isDynamicProbe() {
        if (this.fIsKernel) {
            return this.fKernelComposite.isDynamicProbe();
        }
        return false;
    }

    @Override
    public String getProbeName() {
        if (this.fIsKernel) {
            return this.fKernelComposite.getProbeName();
        }
        return null;
    }

    @Override
    public String getProbeEventName() {
        if (this.fIsKernel) {
            return this.fKernelComposite.getProbeEventName();
        }
        return null;
    }

    @Override
    public boolean isDynamicFunctionProbe() {
        if (this.fIsKernel) {
            return this.fKernelComposite.isDynamicFunctionProbe();
        }
        return false;
    }

    @Override
    public String getFunctionEventName() {
        if (this.fIsKernel) {
            return this.fKernelComposite.getFunctionEventName();
        }
        return null;
    }

    @Override
    public String getFunction() {
        if (this.fIsKernel) {
            return this.fKernelComposite.getFunction();
        }
        return null;
    }

    @Override
    public boolean isWildcard() {
        if (!this.fIsKernel) {
            return this.fUstComposite.isWildcard();
        }
        return false;
    }

    @Override
    public String getWildcard() {
        if (!this.fIsKernel) {
            return this.fUstComposite.getWildcard();
        }
        return null;
    }

    @Override
    public boolean isLogLevel() {
        if (!this.fIsKernel) {
            return this.fUstComposite.isLogLevel();
        }
        return false;
    }

    @Override
    public LogLevelType getLogLevelType() {
        if (!this.fIsKernel) {
            return this.fUstComposite.getLogLevelType();
        }
        return null;
    }

    @Override
    public TraceLogLevel getLogLevel() {
        if (!this.fIsKernel) {
            return this.fUstComposite.getLogLevel();
        }
        return null;
    }

    @Override
    public String getLogLevelEventName() {
        if (!this.fIsKernel) {
            return this.fUstComposite.getLogLevelEventName();
        }
        return null;
    }

    @Override
    public boolean isKernel() {
        return this.fIsKernel;
    }

    @Override
    public void setTraceProviderGroup(TraceProviderGroup providerGroup) {
        this.fProviderGroup = providerGroup;
    }

    @Override
    public void setTraceDomainComponent(TraceDomainComponent domain) {
        this.fDomain = domain;
        this.fIsKernel = this.fDomain != null ? this.fDomain.isKernel() : (this.fProviderGroup != null ? this.fProviderGroup.hasKernelProvider() : true);
    }

    @Override
    public String getFilterExpression() {
        if (!this.fIsKernel) {
            return this.fUstComposite.getFilterExpression();
        }
        return null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_EnableEventsDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(ENABLE_EVENT_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        Group domainGroup = new Group(this.fDialogComposite, 32);
        domainGroup.setText(Messages.TraceControl_DomainDisplayName);
        layout = new GridLayout(2, true);
        domainGroup.setLayout((Layout)layout);
        this.fKernelButton = new Button((Composite)domainGroup, 16);
        this.fKernelButton.setText(Messages.TraceControl_KernelDomainDisplayName);
        this.fKernelButton.setSelection(this.fIsKernel);
        this.fUstButton = new Button((Composite)domainGroup, 16);
        this.fUstButton.setText(Messages.TraceControl_UstDisplayName);
        this.fUstButton.setSelection(!this.fIsKernel);
        if (this.fDomain != null || this.fProviderGroup != null && !this.fProviderGroup.hasKernelProvider()) {
            this.fKernelButton.setEnabled(false);
            this.fUstButton.setEnabled(false);
        }
        GridData data = new GridData(768);
        domainGroup.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fKernelButton.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fUstButton.setLayoutData((Object)data);
        this.fUstComposite = null;
        this.fKernelComposite = null;
        if (this.fIsKernel) {
            this.createKernelComposite();
            this.fUstComposite = null;
        } else {
            this.createUstComposite();
        }
        this.fKernelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnableEventsDialog.this.fKernelButton.getSelection()) {
                    EnableEventsDialog.this.disposeUstComposite();
                    EnableEventsDialog.this.createKernelComposite();
                    EnableEventsDialog.this.fDialogComposite.layout();
                }
            }
        });
        this.fUstButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnableEventsDialog.this.fUstButton.getSelection()) {
                    EnableEventsDialog.this.disposeKernelComposite();
                    EnableEventsDialog.this.createUstComposite();
                    EnableEventsDialog.this.fDialogComposite.layout();
                }
            }
        });
        this.getShell().setMinimumSize(new Point(500, 650));
        return this.fDialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        this.fIsKernel = this.fKernelButton.getSelection();
        if (this.fKernelComposite != null && !this.fKernelComposite.isValid()) {
            return;
        }
        if (this.fUstComposite != null && !this.fUstComposite.isValid()) {
            return;
        }
        super.okPressed();
    }

    private void createKernelComposite() {
        if (this.fKernelComposite == null) {
            this.fKernelComposite = new EnableKernelEventComposite(this.fDialogComposite, 0, this.fProviderGroup);
            GridLayout layout = new GridLayout(1, true);
            this.fKernelComposite.setLayout((Layout)layout);
            this.fKernelComposite.setLayoutData(new GridData(1808));
            this.fKernelComposite.createContent();
        }
    }

    private void disposeKernelComposite() {
        if (this.fKernelComposite != null) {
            this.fKernelComposite.dispose();
            this.fKernelComposite = null;
        }
    }

    private void createUstComposite() {
        if (this.fUstComposite == null) {
            this.fUstComposite = new EnableUstEventsComposite(this.fDialogComposite, 0, this.fProviderGroup);
            GridLayout layout = new GridLayout(1, true);
            this.fUstComposite.setLayout((Layout)layout);
            this.fUstComposite.setLayoutData(new GridData(1808));
            this.fUstComposite.createContent();
        }
    }

    private void disposeUstComposite() {
        if (this.fUstComposite != null) {
            this.fUstComposite.dispose();
            this.fUstComposite = null;
        }
    }
}

