/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IImportConfirmationDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;

public class ImportConfirmationDialog
extends Dialog
implements IImportConfirmationDialog {
    public static final String IMPORT_ICON_FILE = "icons/elcl16/import_trace.gif";
    private Button fOverwriteButton = null;
    private Button fRenameButton = null;
    private Text fNewTraceNameText = null;
    private String fTraceName = null;
    private String fNewTraceName = null;
    private boolean fIsOverride = true;

    public ImportConfirmationDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    @Override
    public void setTraceName(String name) {
        this.fTraceName = name;
    }

    @Override
    public String getNewTraceName() {
        return this.fNewTraceName;
    }

    @Override
    public boolean isOverwrite() {
        return this.fIsOverride;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_ImportDialogConfirmationTitle);
        newShell.setImage(Activator.getDefault().loadIcon(IMPORT_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        dialogComposite.setLayout((Layout)layout);
        dialogComposite.setLayoutData((Object)new GridData(1808));
        Label sessionNameLabel = new Label(dialogComposite, 131072);
        sessionNameLabel.setText(String.valueOf(Messages.TraceControl_ImportDialogTraceAlreadyExistError) + ": " + this.fTraceName);
        this.fOverwriteButton = new Button(dialogComposite, 16);
        this.fOverwriteButton.setText(Messages.TraceControl_ImportDialogConfirmationOverwriteLabel);
        this.fOverwriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportConfirmationDialog.this.fNewTraceNameText.setEnabled(false);
                ImportConfirmationDialog.this.fNewTraceNameText.setText(ImportConfirmationDialog.this.fTraceName);
            }
        });
        this.fRenameButton = new Button(dialogComposite, 16);
        this.fRenameButton.setText(Messages.TraceControl_ImportDialogConfirmationRenameLabel);
        this.fRenameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportConfirmationDialog.this.fNewTraceNameText.setEnabled(true);
            }
        });
        this.fNewTraceNameText = new Text(dialogComposite, 0);
        this.fNewTraceNameText.setToolTipText(Messages.TraceControl_ImportDialogConfirmationNewNameLabel);
        this.fNewTraceNameText.setText(this.fTraceName);
        this.fOverwriteButton.setSelection(true);
        this.fNewTraceNameText.setEnabled(false);
        GridData data = new GridData(768);
        this.fNewTraceNameText.setLayoutData((Object)data);
        this.getShell().setMinimumSize(new Point(300, 150));
        return dialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        this.fIsOverride = this.fOverwriteButton.getSelection();
        this.fNewTraceName = this.fIsOverride ? this.fTraceName : this.fNewTraceNameText.getText();
        if (!this.fNewTraceName.matches("^[a-zA-Z0-9\\-\\_]{1,}$")) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_ImportDialogConfirmationTitle, (String)(String.valueOf(Messages.TraceControl_InvalidTraceNameError) + " (" + this.fNewTraceName + ") \n"));
            return;
        }
        super.okPressed();
    }
}

