/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseAddContextHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.ChannelCommandParameter;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;

public class AddContextOnChannelHandler
extends BaseAddContextHandler {
    @Override
    public void addContexts(CommandParameter param, List<String> contextNames, IProgressMonitor monitor) throws ExecutionException {
        if (param instanceof ChannelCommandParameter) {
            TraceChannelComponent channel = ((ChannelCommandParameter)param).getChannel();
            channel.addContexts(contextNames, monitor);
        }
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TraceChannelComponent channel = null;
        TraceSessionComponent session = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceChannelComponent tmpChannel;
                if (!(element instanceof TraceChannelComponent) || (session = (tmpChannel = (TraceChannelComponent)element).getSession()).getSessionState() != TraceSessionState.INACTIVE || session.isDestroyed()) continue;
                channel = tmpChannel;
            }
        }
        boolean isEnabled = channel != null;
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new ChannelCommandParameter(session, channel);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

