/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.DomainCommandParameter;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CalibrateHandler
extends BaseControlViewHandler {
    protected DomainCommandParameter fParam = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            final DomainCommandParameter param = this.fParam.clone();
            Job addJob = new Job(Messages.TraceControl_AddCalibrateJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        param.getDomain().calibrate(monitor);
                    }
                    catch (ExecutionException e) {
                        return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_AddCalibrateFailure, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            addJob.setUser(true);
            addJob.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return Status.OK_STATUS;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TraceDomainComponent domain = null;
        TraceSessionComponent session = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceDomainComponent tmpDomain;
                if (!(element instanceof TraceDomainComponent) || (session = (TraceSessionComponent)(tmpDomain = (TraceDomainComponent)element).getParent()).isDestroyed()) continue;
                domain = tmpDomain;
            }
        }
        boolean isEnabled = domain != null;
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new DomainCommandParameter(session, domain);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

