/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.DomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TraceDomainPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class TraceDomainComponent
extends TraceControlComponent {
    public static final String TRACE_DOMAIN_ICON_FILE = "icons/obj16/domain.gif";
    private IDomainInfo fDomainInfo = null;

    public TraceDomainComponent(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(TRACE_DOMAIN_ICON_FILE);
        this.setToolTip(Messages.TraceControl_DomainDisplayName);
        this.fDomainInfo = new DomainInfo(name);
    }

    public void setDomainInfo(IDomainInfo domainInfo) {
        this.fDomainInfo = domainInfo;
        IChannelInfo[] channels = this.fDomainInfo.getChannels();
        int i = 0;
        while (i < channels.length) {
            TraceChannelComponent channel = new TraceChannelComponent(channels[i].getName(), this);
            channel.setChannelInfo(channels[i]);
            this.addChild(channel);
            ++i;
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new TraceDomainPropertySource(this);
        }
        return null;
    }

    public String getSessionName() {
        return ((TraceSessionComponent)this.getParent()).getName();
    }

    public TraceSessionComponent getSession() {
        return (TraceSessionComponent)this.getParent();
    }

    public boolean isKernel() {
        return this.fDomainInfo.isKernel();
    }

    public void setIsKernel(boolean isKernel) {
        this.fDomainInfo.setIsKernel(isKernel);
    }

    public TraceChannelComponent[] getChannels() {
        List<ITraceControlComponent> channels = this.getChildren(TraceChannelComponent.class);
        return channels.toArray(new TraceChannelComponent[channels.size()]);
    }

    public TargetNodeComponent getTargetNode() {
        return ((TraceSessionComponent)this.getParent()).getTargetNode();
    }

    public BufferType getBufferType() {
        return this.fDomainInfo.getBufferType();
    }

    public void getConfigurationFromNode(IProgressMonitor monitor) throws ExecutionException {
        TraceSessionComponent session = (TraceSessionComponent)this.getParent();
        session.getConfigurationFromNode(monitor);
    }

    public void enableChannels(List<String> channelNames, IChannelInfo info, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableChannels(this.getParent().getName(), channelNames, this.isKernel(), info, monitor);
    }

    public void disableChannels(List<String> channelNames, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().disableChannels(this.getParent().getName(), channelNames, this.isKernel(), monitor);
    }

    public void enableEvents(List<String> eventNames, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableEvents(this.getSessionName(), null, eventNames, this.isKernel(), null, monitor);
    }

    public void enableSyscalls(IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableSyscalls(this.getSessionName(), null, monitor);
    }

    public void enableProbe(String eventName, boolean isFunction, String probe, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableProbe(this.getSessionName(), null, eventName, isFunction, probe, monitor);
    }

    public void enableLogLevel(String eventName, LogLevelType logLevelType, TraceLogLevel level, String filterExpression, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableLogLevel(this.getSessionName(), null, eventName, logLevelType, level, filterExpression, monitor);
    }

    public void addContexts(List<String> contexts, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().addContexts(this.getSessionName(), null, null, this.isKernel(), contexts, monitor);
    }

    public void calibrate(IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().calibrate(this.isKernel(), monitor);
    }
}

