/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.views.timegraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.XmlViewInfo;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.readonly.TmfXmlReadOnlyModelFactory;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.views.timegraph.XmlEntry;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.views.timegraph.XmlPresentationProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider2;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.w3c.dom.Element;

public class XmlTimeGraphView
extends AbstractTimeGraphView {
    @NonNull
    public static final String ID = "org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph";
    private static final String[] DEFAULT_COLUMN_NAMES = new String[]{Messages.XmlTimeGraphView_ColumnName, Messages.XmlTimeGraphView_ColumnId, Messages.XmlTimeGraphView_ColumnParentId};
    private static final String[] DEFAULT_FILTER_COLUMN_NAMES = new String[]{Messages.XmlTimeGraphView_ColumnName, Messages.XmlTimeGraphView_ColumnId};
    private static final int[] fWeight = new int[]{1, 2};
    private static final String EMPTY_STRING = "";
    private static final String SPLIT_STRING = "/";
    @NonNull
    private final XmlViewInfo fViewInfo = new XmlViewInfo("org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph");
    private final ITmfXmlModelFactory fFactory;

    public XmlTimeGraphView() {
        super(ID, (TimeGraphPresentationProvider)new XmlPresentationProvider());
        this.setWeight(fWeight);
        this.setTreeColumns(DEFAULT_COLUMN_NAMES);
        this.setTreeLabelProvider(new XmlTreeLabelProvider());
        this.setFilterColumns(DEFAULT_FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new XmlTreeLabelProvider());
        this.setEntryComparator(new XmlEntryComparator());
        this.addPartPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object newValue;
                if (event.getProperty().equals("xmlOutputData") && (newValue = event.getNewValue()) instanceof String) {
                    String data = (String)newValue;
                    XmlTimeGraphView.this.fViewInfo.setViewData(data);
                    XmlTimeGraphView.this.loadNewXmlView();
                }
            }
        });
        this.fFactory = TmfXmlReadOnlyModelFactory.getInstance();
    }

    private void loadNewXmlView() {
        this.rebuild();
    }

    private void setViewTitle(final String title) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                XmlTimeGraphView.this.setPartName(title);
            }
        });
    }

    protected String getNextText() {
        return Messages.XmlTimeGraphView_NextText;
    }

    protected String getNextTooltip() {
        return Messages.XmlTimeGraphView_NextTooltip;
    }

    protected String getPrevText() {
        return Messages.XmlTimeGraphView_PreviousText;
    }

    protected String getPrevTooltip() {
        return Messages.XmlTimeGraphView_PreviousInterval;
    }

    protected void buildEventList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        String title;
        Element viewElement = this.fViewInfo.getViewElement("timeGraphView");
        if (viewElement == null) {
            return;
        }
        ITimeGraphPresentationProvider2 pres = this.getPresentationProvider();
        if (pres instanceof XmlPresentationProvider) {
            ((XmlPresentationProvider)pres).loadNewStates(viewElement);
        }
        if ((title = this.fViewInfo.getViewTitle(viewElement)) == null) {
            title = Messages.XmlTimeGraphView_DefaultTitle;
        }
        this.setViewTitle(title);
        Set<String> analysisIds = this.fViewInfo.getViewAnalysisIds(viewElement);
        List entries = XmlUtils.getChildElements((Element)viewElement, (String)"entry");
        TreeSet<XmlEntry> entryList = new TreeSet<XmlEntry>(this.getEntryComparator());
        for (ITmfTrace aTrace : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
            aTrace = (ITmfTrace)NonNullUtils.checkNotNull((Object)aTrace);
            if (monitor.isCanceled()) {
                return;
            }
            LinkedList<ITmfAnalysisModuleWithStateSystems> stateSystemModules = new LinkedList<ITmfAnalysisModuleWithStateSystems>();
            if (analysisIds.isEmpty()) {
                for (ITmfAnalysisModuleWithStateSystems module : TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)aTrace, ITmfAnalysisModuleWithStateSystems.class)) {
                    stateSystemModules.add(module);
                }
            } else {
                for (String moduleId : analysisIds) {
                    ITmfAnalysisModuleWithStateSystems module = (ITmfAnalysisModuleWithStateSystems)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)aTrace, ITmfAnalysisModuleWithStateSystems.class, (String)(moduleId = (String)NonNullUtils.checkNotNull((Object)moduleId)));
                    if (module == null) continue;
                    stateSystemModules.add(module);
                }
            }
            for (ITmfAnalysisModuleWithStateSystems module : stateSystemModules) {
                IStatus status = module.schedule();
                if (!status.isOK()) {
                    return;
                }
                if (module instanceof TmfStateSystemAnalysisModule) {
                    ((TmfStateSystemAnalysisModule)module).waitForInitialization();
                }
                for (ITmfStateSystem ssq : module.getStateSystems()) {
                    if (ssq == null) {
                        return;
                    }
                    ssq.waitUntilBuilt();
                    long startTime = ssq.getStartTime();
                    long endTime = ssq.getCurrentEndTime();
                    XmlEntry groupEntry = new XmlEntry(-1, aTrace, aTrace.getName(), ssq);
                    entryList.add(groupEntry);
                    this.setStartTime(Math.min(this.getStartTime(), startTime));
                    this.setEndTime(Math.max(this.getEndTime(), endTime));
                    for (Element entry : entries) {
                        this.buildEntry(entry, groupEntry, -1);
                    }
                }
            }
        }
        this.putEntryList(trace, new ArrayList(entryList));
        if (trace.equals(this.getTrace())) {
            this.refresh();
        }
        for (XmlEntry traceEntry : entryList) {
            if (monitor.isCanceled()) {
                return;
            }
            long startTime = traceEntry.getStateSystem().getStartTime();
            long endTime = traceEntry.getStateSystem().getCurrentEndTime() + 1L;
            this.buildStatusEvent(traceEntry, monitor, startTime, endTime);
        }
    }

    private void buildEntry(Element entryElement, XmlEntry parentEntry, int baseQuark) {
        String path = entryElement.getAttribute("path");
        if (path.isEmpty()) {
            path = "*";
        }
        List displayElements = XmlUtils.getChildElements((Element)entryElement, (String)"display");
        List entryElements = XmlUtils.getChildElements((Element)entryElement, (String)"entry");
        if (displayElements.isEmpty() && entryElements.isEmpty()) {
            Activator.logWarning(String.format("XML view: entry for %s should have either a display element or entry elements", path));
            return;
        }
        ITmfStateSystem ss = parentEntry.getStateSystem();
        String[] paths = path.split(SPLIT_STRING);
        int i = 0;
        List<Integer> quarks = Collections.singletonList(baseQuark);
        try {
            while (i < paths.length) {
                LinkedList<Integer> subQuarks = new LinkedList<Integer>();
                String name = paths[i].replaceAll("\\*", ".*");
                for (int relativeQuark : quarks) {
                    Iterator iterator = ss.getSubAttributes(relativeQuark, false, name).iterator();
                    while (iterator.hasNext()) {
                        int quark = (Integer)iterator.next();
                        subQuarks.add(quark);
                    }
                }
                quarks = subQuarks;
                ++i;
            }
            XmlEntry currentEntry = parentEntry;
            Element displayElement = null;
            HashMap<String, XmlEntry> entryMap = new HashMap<String, XmlEntry>();
            if (!displayElements.isEmpty()) {
                displayElement = (Element)displayElements.get(0);
            }
            for (int quark : quarks) {
                currentEntry = parentEntry;
                if (displayElement != null) {
                    currentEntry = this.processEntry(entryElement, displayElement, parentEntry, quark, ss);
                    entryMap.put(currentEntry.getId(), currentEntry);
                }
                for (Element subEntryEl : entryElements) {
                    this.buildEntry(subEntryEl, currentEntry, quark);
                }
            }
            if (!entryMap.isEmpty()) {
                XmlTimeGraphView.buildTree(entryMap, parentEntry);
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
    }

    private XmlEntry processEntry(@NonNull Element entryElement, @NonNull Element displayEl, @NonNull XmlEntry parentEntry, int quark, ITmfStateSystem ss) {
        ITmfXmlStateAttribute display = this.fFactory.createStateAttribute(displayEl, (IXmlStateSystemContainer)parentEntry);
        int displayQuark = display.getAttributeQuark(quark);
        if (displayQuark == -1) {
            return new XmlEntry(quark, parentEntry.getTrace(), String.format("Unknown display quark for %s", ss.getAttributeName(quark)), ss);
        }
        long entryStart = ss.getStartTime();
        long entryEnd = ss.getCurrentEndTime();
        try {
            long ts;
            ITmfStateInterval oneInterval = ss.querySingleState(entryStart, displayQuark);
            while (oneInterval.getStateValue().isNull()) {
                ts = oneInterval.getEndTime() + 1L;
                if (ts > ss.getCurrentEndTime()) break;
                oneInterval = ss.querySingleState(ts, displayQuark);
            }
            entryStart = oneInterval.getStartTime();
            oneInterval = ss.querySingleState(entryEnd, displayQuark);
            while (oneInterval.getStateValue().isNull()) {
                ts = oneInterval.getStartTime() - 1L;
                if (ts < ss.getStartTime()) break;
                oneInterval = ss.querySingleState(ts, displayQuark);
            }
            entryEnd = oneInterval.getEndTime();
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            // empty catch block
        }
        return new XmlEntry(quark, displayQuark, parentEntry.getTrace(), ss.getAttributeName(quark), entryStart, entryEnd, XmlEntry.EntryDisplayType.DISPLAY, ss, entryElement);
    }

    private void buildStatusEvent(XmlEntry traceEntry, @NonNull IProgressMonitor monitor, long start, long end) {
        long resolution = (end - start) / (long)this.getDisplayWidth();
        long startTime = Math.max(start, traceEntry.getStartTime());
        long endTime = Math.min(end + 1L, traceEntry.getEndTime());
        List<ITimeEvent> eventList = this.getEventList(traceEntry, startTime, endTime, resolution, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        traceEntry.setEventList(eventList);
        this.redraw();
        for (ITimeGraphEntry entry : traceEntry.getChildren()) {
            if (monitor.isCanceled()) {
                return;
            }
            XmlEntry xmlEntry = (XmlEntry)entry;
            this.buildStatusEvent(xmlEntry, monitor, start, end);
        }
    }

    private static void buildTree(Map<String, XmlEntry> entryMap, XmlEntry rootEntry) {
        for (XmlEntry entry : entryMap.values()) {
            XmlEntry parent;
            boolean root = true;
            if (!entry.getParentId().isEmpty() && (parent = entryMap.get(entry.getParentId())) != null && entry.getStartTime() <= parent.getEndTime() && entry.getEndTime() >= parent.getStartTime()) {
                parent.addChild(entry);
                root = false;
            }
            if (!root) continue;
            rootEntry.addChild(entry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<ITimeEvent> getEventList(TimeGraphEntry entry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        if (!(entry instanceof XmlEntry)) {
            return Collections.EMPTY_LIST;
        }
        XmlEntry xmlEntry = (XmlEntry)entry;
        ITmfStateSystem ssq = xmlEntry.getStateSystem();
        long realStart = Math.max(startTime, entry.getStartTime());
        long realEnd = Math.min(endTime, entry.getEndTime());
        if (realEnd <= realStart) {
            return null;
        }
        ArrayList<Object> eventList = null;
        int quark = xmlEntry.getDisplayQuark();
        try {
            if (xmlEntry.getType() != XmlEntry.EntryDisplayType.DISPLAY) return eventList;
            List statusIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ssq, (int)quark, (long)realStart, (long)(realEnd - 1L), (long)resolution, (IProgressMonitor)monitor);
            eventList = new ArrayList<Object>(statusIntervals.size());
            long lastEndTime = -1L;
            Iterator iterator = statusIntervals.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return eventList;
                }
                ITmfStateInterval statusInterval = (ITmfStateInterval)iterator.next();
                if (monitor.isCanceled()) {
                    return null;
                }
                int status = statusInterval.getStateValue().unboxInt();
                long time = statusInterval.getStartTime();
                long duration = statusInterval.getEndTime() - time + 1L;
                if (!statusInterval.getStateValue().isNull()) {
                    if (lastEndTime != time && lastEndTime != -1L) {
                        eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime));
                    }
                    eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, status));
                } else if (lastEndTime == -1L || time + duration >= endTime) {
                    eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                }
                lastEndTime = time + duration;
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | StateValueTypeException | TimeRangeException throwable) {
            // empty catch block
        }
        return eventList;
    }

    protected List<ILinkEvent> getLinkList(long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    private static class XmlEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private XmlEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            int result = 0;
            if (o1 instanceof XmlEntry && o2 instanceof XmlEntry) {
                XmlEntry entry1 = (XmlEntry)o1;
                XmlEntry entry2 = (XmlEntry)o2;
                result = entry1.getTrace().getStartTime().compareTo(entry2.getTrace().getStartTime());
                if (result == 0) {
                    result = entry1.getTrace().getName().compareTo(entry2.getTrace().getName());
                }
                if (result == 0) {
                    result = entry1.getName().compareTo(entry2.getName());
                }
            }
            if (result == 0) {
                result = o1.getStartTime() < o2.getStartTime() ? -1 : (o1.getStartTime() > o2.getStartTime() ? 1 : 0);
            }
            return result;
        }
    }

    private static class XmlTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private XmlTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            XmlEntry entry = (XmlEntry)((Object)element);
            if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnName)) {
                return entry.getName();
            }
            if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnId)) {
                return entry.getId();
            }
            if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnParentId)) {
                return entry.getParentId();
            }
            return XmlTimeGraphView.EMPTY_STRING;
        }
    }
}

