/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.trace.experiment;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;

public final class TmfExperimentContext
extends TmfContext {
    public static final int NO_TRACE = -1;
    private final List<ITmfContext> fContexts;
    private final List<ITmfEvent> fEvents;
    private int fLastTraceRead = -1;

    public TmfExperimentContext(int nbTraces) {
        this.fContexts = new ArrayList<ITmfContext>(nbTraces);
        this.fEvents = new ArrayList<ITmfEvent>(nbTraces);
        int i = 0;
        while (i < nbTraces) {
            this.fContexts.add(null);
            this.fEvents.add(null);
            ++i;
        }
    }

    @Override
    public void dispose() {
        for (ITmfContext context : this.fContexts) {
            context.dispose();
        }
        super.dispose();
    }

    public int getNbTraces() {
        return this.fContexts.size();
    }

    @Nullable
    public ITmfContext getContext(int traceIndex) {
        return this.fContexts.get(traceIndex);
    }

    public void setContext(int traceIndex, ITmfContext ctx) {
        this.fContexts.set(traceIndex, ctx);
    }

    @Nullable
    public ITmfEvent getEvent(int traceIndex) {
        return this.fEvents.get(traceIndex);
    }

    public void setEvent(int traceIndex, ITmfEvent event) {
        this.fEvents.set(traceIndex, event);
    }

    public int getLastTrace() {
        return this.fLastTraceRead;
    }

    public void setLastTrace(int newIndex) {
        this.fLastTraceRead = newIndex;
    }

    @Override
    public int hashCode() {
        int result = 17;
        int i = 0;
        while (i < this.fContexts.size()) {
            result = 37 * result + this.fContexts.get(i).hashCode();
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof TmfExperimentContext)) {
            return false;
        }
        TmfExperimentContext o = (TmfExperimentContext)other;
        boolean isEqual = true;
        int i = 0;
        while (isEqual && i < this.fContexts.size()) {
            isEqual &= this.fContexts.get(i).equals(o.fContexts.get(i));
            ++i;
        }
        return isEqual;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TmfExperimentContext [\n");
        sb.append("\tfLocation=" + this.getLocation() + ", fRank=" + this.getRank() + "\n");
        sb.append("\tfContexts=[");
        int i = 0;
        while (i < this.fContexts.size()) {
            sb.append("(" + this.fContexts.get(i).getLocation() + "," + this.fContexts.get(i).getRank() + (i < this.fContexts.size() - 1 ? ")," : ")]\n"));
            ++i;
        }
        sb.append("\tfEvents=[");
        i = 0;
        while (i < this.fEvents.size()) {
            ITmfEvent event = this.fEvents.get(i);
            sb.append((event != null ? this.fEvents.get(i).getTimestamp() : "(null)") + (i < this.fEvents.size() - 1 ? "," : "]\n"));
            ++i;
        }
        sb.append("\tfLastTraceRead=" + this.fLastTraceRead + "\n");
        sb.append("]");
        return sb.toString();
    }
}

