/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.core.analysis.ITmfNewAnalysisModuleListener;
import org.eclipse.tracecompass.tmf.core.analysis.TmfNewAnalysisOutputListener;

public class TmfAnalysisModuleOutputs {
    public static final String TMF_ANALYSIS_TYPE_ID = "org.eclipse.linuxtools.tmf.core.analysis";
    public static final String OUTPUT_ELEM = "output";
    public static final String CLASS_ATTR = "class";
    public static final String ID_ATTR = "id";
    public static final String ANALYSIS_ID_ELEM = "analysisId";
    public static final String MODULE_CLASS_ELEM = "analysisModuleClass";

    private TmfAnalysisModuleOutputs() {
    }

    public static Iterable<ITmfNewAnalysisModuleListener> getOutputListeners() {
        IConfigurationElement[] config;
        ArrayList<ITmfNewAnalysisModuleListener> newModuleListeners = new ArrayList<ITmfNewAnalysisModuleListener>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_ANALYSIS_TYPE_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            if (elementName.equals(OUTPUT_ELEM)) {
                try {
                    IAnalysisOutput output = (IAnalysisOutput)ce.createExecutableExtension(CLASS_ATTR);
                    if (output == null) {
                        Activator.logWarning("An output could not be created");
                    } else {
                        TmfNewAnalysisOutputListener listener = null;
                        IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren();
                        int n3 = iConfigurationElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement childCe = iConfigurationElementArray2[n4];
                            if (childCe.getName().equals(ANALYSIS_ID_ELEM)) {
                                listener = new TmfNewAnalysisOutputListener(output, childCe.getAttribute(ID_ATTR), null);
                            } else if (childCe.getName().equals(MODULE_CLASS_ELEM)) {
                                listener = new TmfNewAnalysisOutputListener(output, null, childCe.createExecutableExtension(CLASS_ATTR).getClass().asSubclass(IAnalysisModule.class));
                            }
                            ++n4;
                        }
                        if (listener != null) {
                            newModuleListeners.add(listener);
                        }
                    }
                }
                catch (CoreException | InvalidRegistryObjectException e) {
                    Activator.logError("Error creating module output listener", e);
                }
            }
            ++n2;
        }
        return newModuleListeners;
    }
}

