/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.signal;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;

@NonNullByDefault
public class TmfSelectionRangeUpdatedSignal
extends TmfSignal {
    private final ITmfTimestamp fBeginTime;
    private final ITmfTimestamp fEndTime;

    public TmfSelectionRangeUpdatedSignal(@Nullable Object source, ITmfTimestamp ts) {
        super(source);
        this.fBeginTime = ts;
        this.fEndTime = ts;
    }

    public TmfSelectionRangeUpdatedSignal(@Nullable Object source, ITmfTimestamp begin, ITmfTimestamp end) {
        super(source);
        this.fBeginTime = begin;
        this.fEndTime = end;
    }

    public ITmfTimestamp getBeginTime() {
        return this.fBeginTime;
    }

    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append(this.fBeginTime.toString());
        if (!this.fBeginTime.equals(this.fEndTime)) {
            sb.append('-');
            sb.append(this.fEndTime.toString());
        }
        sb.append("]");
        return (String)NonNullUtils.checkNotNull((Object)sb.toString());
    }
}

