/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public class TmfContext
implements ITmfContext {
    private ITmfLocation fLocation;
    private long fRank;

    public TmfContext() {
        this(null, -1L);
    }

    public TmfContext(ITmfLocation location) {
        this(location, -1L);
    }

    public TmfContext(ITmfLocation location, long rank) {
        this.fLocation = location;
        this.fRank = rank;
    }

    public TmfContext(TmfContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.fLocation = context.fLocation;
        this.fRank = context.fRank;
    }

    @Override
    public ITmfLocation getLocation() {
        return this.fLocation;
    }

    @Override
    public void setLocation(ITmfLocation location) {
        this.fLocation = location;
    }

    @Override
    public long getRank() {
        return this.fRank;
    }

    @Override
    public void setRank(long rank) {
        this.fRank = rank;
    }

    @Override
    public void increaseRank() {
        if (this.hasValidRank()) {
            ++this.fRank;
        }
    }

    @Override
    public boolean hasValidRank() {
        return this.fRank != -1L;
    }

    @Override
    public void dispose() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fLocation == null ? 0 : this.fLocation.hashCode());
        result = 31 * result + (int)(this.fRank ^ this.fRank >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfContext other = (TmfContext)obj;
        if (this.fLocation == null ? other.fLocation != null : !this.fLocation.equals(other.fLocation)) {
            return false;
        }
        return this.fRank == other.fRank;
    }

    public String toString() {
        return "TmfContext [fLocation=" + this.fLocation + ", fRank=" + this.fRank + "]";
    }
}

