/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.EventDefinition;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.tmf.core.event.ITmfCustomAttributes;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfModelLookup;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfSourceLookup;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventField;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventType;
import org.eclipse.tracecompass.tmf.ctf.core.event.lookup.CtfTmfCallsite;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public class CtfTmfEvent
extends TmfEvent
implements ITmfSourceLookup,
ITmfModelLookup,
ITmfCustomAttributes {
    private static final String EMPTY_CTF_EVENT_NAME = "Empty CTF event";
    private final int fSourceCPU;
    private final long fTypeId;
    private final String fEventName;
    private final IEventDeclaration fEventDeclaration;
    @NonNull
    private final EventDefinition fEvent;
    private final String fReference;
    private ITmfEventField fContent;
    private CtfTmfEventType fCtfTmfEventType;

    CtfTmfEvent(CtfTmfTrace trace, long rank, TmfNanoTimestamp timestamp, String fileName, int cpu, IEventDeclaration declaration, @NonNull EventDefinition eventDefinition) {
        super((ITmfTrace)trace, rank, (ITmfTimestamp)timestamp, null, null);
        this.fEventDeclaration = declaration;
        this.fSourceCPU = cpu;
        this.fTypeId = declaration.getId();
        this.fEventName = declaration.getName();
        this.fEvent = eventDefinition;
        this.fReference = fileName;
    }

    CtfTmfEvent(CtfTmfTrace trace) {
        super((ITmfTrace)trace, -1L, (ITmfTimestamp)new TmfNanoTimestamp(-1L), null, (ITmfEventField)new TmfEventField("", null, (ITmfEventField[])new CtfTmfEventField[0]));
        this.fSourceCPU = -1;
        this.fTypeId = -1L;
        this.fEventName = EMPTY_CTF_EVENT_NAME;
        this.fEventDeclaration = null;
        this.fEvent = EventDefinition.NULL_EVENT;
        this.fReference = null;
    }

    public CtfTmfEvent() {
        this(null);
    }

    public int getCPU() {
        return this.fSourceCPU;
    }

    public long getID() {
        return this.fTypeId;
    }

    public String getReference() {
        return this.fReference;
    }

    public CtfTmfTrace getTrace() {
        return (CtfTmfTrace)super.getTrace();
    }

    public ITmfEventType getType() {
        if (this.fCtfTmfEventType == null) {
            this.fCtfTmfEventType = new CtfTmfEventType(this.fEventName, this.getContent());
            this.getTrace().registerEventType(this.fCtfTmfEventType);
        }
        return this.fCtfTmfEventType;
    }

    public String getName() {
        return this.fEventName;
    }

    public Set<String> listCustomAttributes() {
        if (this.fEventDeclaration == null) {
            return new HashSet<String>();
        }
        return this.fEventDeclaration.getCustomAttributes();
    }

    public String getCustomAttribute(String name) {
        if (this.fEventDeclaration == null) {
            return null;
        }
        return this.fEventDeclaration.getCustomAttribute(name);
    }

    public CtfTmfCallsite getCallsite() {
        ITmfEventField ipField;
        CtfTmfCallsite callsite = null;
        CtfTmfTrace trace = this.getTrace();
        if (this.getContent() != null && (ipField = this.getContent().getField(new String[]{"context._ip"})) != null && ipField.getValue() instanceof Long) {
            long ip = (Long)ipField.getValue();
            callsite = trace.getCallsite(this.fEventName, ip);
        }
        if (callsite == null) {
            callsite = trace.getCallsite(this.fEventName);
        }
        return callsite;
    }

    public String getModelUri() {
        return this.getCustomAttribute("model.emf.uri");
    }

    public synchronized ITmfEventField getContent() {
        if (this.fContent == null) {
            this.fContent = new TmfEventField(":root:", null, (ITmfEventField[])CtfTmfEvent.parseFields(this.fEvent));
        }
        return this.fContent;
    }

    private static CtfTmfEventField[] parseFields(@NonNull EventDefinition eventDef) {
        ICompositeDefinition structContext;
        ArrayList<CtfTmfEventField> fields = new ArrayList<CtfTmfEventField>();
        ICompositeDefinition structFields = eventDef.getFields();
        if (structFields != null && structFields.getFieldNames() != null) {
            for (String curFieldName : structFields.getFieldNames()) {
                fields.add(CtfTmfEventField.parseField((IDefinition)structFields.getDefinition(curFieldName), curFieldName));
            }
        }
        if ((structContext = eventDef.getContext()) != null) {
            for (String contextName : structContext.getFieldNames()) {
                String curContextName = "context." + contextName;
                fields.add(CtfTmfEventField.parseField((IDefinition)structContext.getDefinition(contextName), curContextName));
            }
        }
        return fields.toArray(new CtfTmfEventField[fields.size()]);
    }
}

