/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.event;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.EventDefinition;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfLostEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public final class CtfTmfEventFactory {
    private static final String NO_STREAM = "No stream";
    private static CtfTmfEvent nullEvent = null;

    private CtfTmfEventFactory() {
    }

    public static CtfTmfEvent createEvent(EventDefinition eventDef, String fileName, CtfTmfTrace originTrace) {
        String reference;
        IEventDeclaration eventDecl = eventDef.getDeclaration();
        long ts = eventDef.getTimestamp();
        TmfNanoTimestamp timestamp = originTrace.createTimestamp(originTrace.timestampCyclesToNanos(ts));
        int sourceCPU = eventDef.getCPU();
        String string = reference = fileName == null ? NO_STREAM : fileName;
        if (eventDecl.getName().equals("Lost event")) {
            Definition nbLostEventsDef = eventDef.getFields().getDefinition("Lost events");
            Definition durationDef = eventDef.getFields().getDefinition("duration");
            if (!(nbLostEventsDef instanceof IntegerDefinition) || !(durationDef instanceof IntegerDefinition)) {
                return CtfTmfEventFactory.getNullEvent(originTrace);
            }
            long nbLostEvents = ((IntegerDefinition)nbLostEventsDef).getValue();
            long duration = ((IntegerDefinition)durationDef).getValue();
            TmfNanoTimestamp timestampEnd = new TmfNanoTimestamp(originTrace.timestampCyclesToNanos(ts) + duration);
            CtfTmfLostEvent lostEvent = new CtfTmfLostEvent(originTrace, -1L, reference, sourceCPU, eventDecl, new TmfTimeRange((ITmfTimestamp)timestamp, (ITmfTimestamp)timestampEnd), nbLostEvents, eventDef);
            return lostEvent;
        }
        CtfTmfEvent event = new CtfTmfEvent(originTrace, -1L, timestamp, reference, sourceCPU, eventDecl, eventDef);
        return event;
    }

    public static CtfTmfEvent getNullEvent(@NonNull CtfTmfTrace trace) {
        if (nullEvent == null) {
            nullEvent = new CtfTmfEvent(trace);
        }
        return nullEvent;
    }
}

