/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.pcap.core.event;

import org.eclipse.tracecompass.internal.pcap.core.stream.PacketStream;
import org.eclipse.tracecompass.internal.tmf.pcap.core.protocol.TmfPcapProtocol;
import org.eclipse.tracecompass.internal.tmf.pcap.core.util.ProtocolConversion;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;

public class TmfPacketStream {
    private final PacketStream fPacketStream;

    public TmfPacketStream(PacketStream stream) {
        this.fPacketStream = stream;
    }

    public String getFirstEndpoint() {
        return this.fPacketStream.getEndpointPair().getFirstEndpoint().toString();
    }

    public String getSecondEndpoint() {
        return this.fPacketStream.getEndpointPair().getSecondEndpoint().toString();
    }

    public int getID() {
        return this.fPacketStream.getID();
    }

    public TmfPcapProtocol getProtocol() {
        return ProtocolConversion.wrap(this.fPacketStream.getProtocol());
    }

    public synchronized long getNbPacketsAtoB() {
        return this.fPacketStream.getNbPacketsAtoB();
    }

    public synchronized long getNbPacketsBtoA() {
        return this.fPacketStream.getNbPacketsBtoA();
    }

    public synchronized long getNbPackets() {
        return this.fPacketStream.getNbPackets();
    }

    public synchronized long getNbBytesAtoB() {
        return this.fPacketStream.getNbBytesAtoB();
    }

    public synchronized long getNbBytesBtoA() {
        return this.fPacketStream.getNbBytesBtoA();
    }

    public synchronized long getNbBytes() {
        return this.fPacketStream.getNbBytes();
    }

    public synchronized ITmfTimestamp getStartTime() {
        return new TmfTimestamp(this.fPacketStream.getStartTime(), -9);
    }

    public synchronized ITmfTimestamp getStopTime() {
        return new TmfTimestamp(this.fPacketStream.getStopTime(), -9);
    }

    public synchronized double getDuration() {
        return this.fPacketStream.getDuration();
    }

    public synchronized double getBPSAtoB() {
        return this.fPacketStream.getBPSAtoB();
    }

    public synchronized double getBPSBtoA() {
        return this.fPacketStream.getBPSBtoA();
    }
}

