/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.pcap.core.util;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.LinkTypeHelper;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapTimestampScale;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapEvent;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapEventField;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapEventType;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapRootEventField;
import org.eclipse.tracecompass.internal.tmf.pcap.core.trace.PcapTrace;
import org.eclipse.tracecompass.internal.tmf.pcap.core.util.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class PcapEventFactory {
    private static final ITmfEventField[] EMPTY_FIELD_ARRAY = new ITmfEventField[0];
    private static final String EMPTY_STRING = "";
    private static final Map<PcapProtocol, TmfEventType> fEventTypes = new HashMap<PcapProtocol, TmfEventType>();

    private PcapEventFactory() {
    }

    @Nullable
    public static PcapEvent createEvent(PcapPacket pcapPacket, PcapFile pcap, PcapTrace trace) {
        TmfEventType eventType;
        TmfTimestamp tmfTimestamp;
        long rank = pcapPacket.getIndex();
        long timestamp = pcapPacket.getTimestamp();
        PcapTimestampScale scale = pcapPacket.getTimestampScale();
        switch (scale) {
            case MICROSECOND: {
                long us = trace.getTimestampTransform().transform(timestamp * 1000L) / 1000L;
                tmfTimestamp = new TmfTimestamp(us, -6);
                break;
            }
            case NANOSECOND: {
                long ns = trace.getTimestampTransform().transform(timestamp);
                tmfTimestamp = new TmfTimestamp(ns, -9);
                break;
            }
            default: {
                throw new IllegalArgumentException("The timestamp precision is not valid!");
            }
        }
        Path filePath = pcap.getPath().getFileName();
        String fileName = filePath == null ? EMPTY_STRING : (String)NonNullUtils.checkNotNull((Object)filePath.toString());
        String dataLink = String.valueOf(Messages.PcapEventFactory_LinkType) + ':' + LinkTypeHelper.toString((int)((int)pcapPacket.getPcapFile().getDataLinkType()));
        ITmfEventField[] fields = PcapEventFactory.generatePacketFields((Packet)pcapPacket);
        PcapRootEventField field = new PcapRootEventField(fields, (Packet)pcapPacket);
        Packet packet = pcapPacket.getMostEcapsulatedPacket();
        if (!fEventTypes.containsKey(packet.getProtocol())) {
            String typeIdString = String.valueOf(PcapEventType.DEFAULT_PCAP_TYPE_ID) + ':' + packet.getProtocol().getShortName();
            fEventTypes.put(packet.getProtocol(), new PcapEventType(typeIdString, null));
        }
        if ((eventType = fEventTypes.get(packet.getProtocol())) == null) {
            eventType = new TmfEventType();
        }
        return new PcapEvent((ITmfTrace)trace, rank, (ITmfTimestamp)tmfTimestamp, dataLink, eventType, (ITmfEventField)field, fileName, packet);
    }

    private static ITmfEventField[] generatePacketFields(Packet packet) {
        ArrayList<PcapEventField> fieldList = new ArrayList<PcapEventField>();
        ArrayList<TmfEventField> subfieldList = new ArrayList<TmfEventField>();
        Packet localPacket = packet.getPacket(PcapProtocol.PCAP);
        while (localPacket != null) {
            subfieldList.clear();
            for (Map.Entry entry : localPacket.getFields().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                subfieldList.add(new TmfEventField(key, (Object)value, null));
            }
            ITmfEventField[] subfieldArray = subfieldList.toArray(new ITmfEventField[subfieldList.size()]);
            fieldList.add(new PcapEventField(localPacket.getProtocol().getName(), EMPTY_STRING, subfieldArray, localPacket));
            localPacket = localPacket.getChildPacket();
        }
        ITmfEventField[] fieldArray = fieldList.toArray(new ITmfEventField[fieldList.size()]);
        if (fieldArray == null) {
            return EMPTY_FIELD_ARRAY;
        }
        return fieldArray;
    }
}

