/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.AbstractImportTraceWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.BatchImportTraceWizard;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.ui.IWorkbench;

public class ImportTraceWizardSelectDirectoriesPage
extends AbstractImportTraceWizardPage {
    public static String ID = "org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.ImportTraceWizardPagePopulate";
    private static final String STORE_DIRECTORY_ID = String.valueOf(ID) + ".STORE_DIRECTORY_ID";

    protected ImportTraceWizardSelectDirectoriesPage(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public ImportTraceWizardSelectDirectoriesPage(IWorkbench workbench, IStructuredSelection selection) {
        super(workbench, selection);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        control.setLayout((Layout)new GridLayout(2, false));
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Table selectedFiles = new Table(control, 768);
        selectedFiles.clearAll();
        selectedFiles.setLayoutData((Object)new GridData(4, 4, true, true));
        selectedFiles.setLinesVisible(true);
        Composite buttonArea = new Composite(control, 0);
        buttonArea.setLayout((Layout)new GridLayout());
        buttonArea.setLayoutData((Object)new GridData(16384, 128, false, false));
        Button addFile = new Button(buttonArea, 8);
        addFile.setText(Messages.ImportTraceWizardAddFile);
        addFile.setLayoutData((Object)new GridData(4, 128, true, false));
        addFile.addSelectionListener((SelectionListener)new AddFileHandler());
        addFile.setAlignment(0x1000000);
        Button addDirectory = new Button(buttonArea, 8);
        addDirectory.setText(Messages.ImportTraceWizardAddDirectory);
        addDirectory.setLayoutData((Object)new GridData(4, 128, true, false));
        addDirectory.addSelectionListener((SelectionListener)new AddDirectoryHandler());
        addDirectory.setAlignment(0x1000000);
        Button removeFile = new Button(buttonArea, 8);
        removeFile.setText(Messages.ImportTraceWizardRemove);
        removeFile.setLayoutData((Object)new GridData(4, 128, true, false));
        removeFile.addSelectionListener((SelectionListener)new RemoveFileHandler(selectedFiles));
        removeFile.setAlignment(0x1000000);
        this.setTitle(Messages.ImportTraceWizardDirectoryTitle);
    }

    private void updateButtons() {
        BatchImportTraceWizard wiz = this.getBatchWizard();
        this.updateTable();
        wiz.getContainer().updateButtons();
    }

    private void updateTable() {
        Table selectedFiles = (Table)((Composite)this.getControl()).getChildren()[0];
        selectedFiles.clearAll();
        selectedFiles.setItemCount(0);
        for (String s : ((BatchImportTraceWizard)this.getWizard()).getFileNames()) {
            TableItem ti = new TableItem(selectedFiles, 0);
            ti.setText(s);
        }
    }

    public boolean canFlipToNextPage() {
        boolean canLoad;
        Table selectedFiles = (Table)((Composite)this.getControl()).getChildren()[0];
        boolean bl = canLoad = selectedFiles.getItemCount() > 0;
        if (canLoad) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(Messages.ImportTraceWizardDirectoryHint);
        }
        return canLoad;
    }

    private String getLastSelectedDirectory() {
        File file;
        String directory;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (directory = settings.get(STORE_DIRECTORY_ID)) != null && !directory.isEmpty() && (file = new File(directory)).exists()) {
            return directory.toString();
        }
        return null;
    }

    private void saveSelectedDirectory(File directory) {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && directory != null && directory.exists()) {
            settings.put(STORE_DIRECTORY_ID, directory.toString());
        }
    }

    private final class AddDirectoryHandler
    implements SelectionListener {
        private AddDirectoryHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            File f;
            String fn;
            DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 0);
            String lastDirectory = ImportTraceWizardSelectDirectoriesPage.this.getLastSelectedDirectory();
            if (lastDirectory != null) {
                dialog.setFilterPath(lastDirectory);
            }
            if ((fn = dialog.open()) != null && (f = new File(fn)).exists()) {
                ImportTraceWizardSelectDirectoriesPage.this.getBatchWizard().addFileToScan(fn);
                ImportTraceWizardSelectDirectoriesPage.this.saveSelectedDirectory(f);
            }
            ImportTraceWizardSelectDirectoriesPage.this.updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private final class AddFileHandler
    implements SelectionListener {
        private AddFileHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            File f;
            String fn;
            FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 0);
            String lastDirectory = ImportTraceWizardSelectDirectoriesPage.this.getLastSelectedDirectory();
            if (lastDirectory != null) {
                dialog.setFilterPath(lastDirectory);
            }
            if ((fn = dialog.open()) != null && (f = new File(fn)).exists()) {
                ImportTraceWizardSelectDirectoriesPage.this.getBatchWizard().addFileToScan(fn);
                ImportTraceWizardSelectDirectoriesPage.this.saveSelectedDirectory(f.getParentFile());
            }
            ImportTraceWizardSelectDirectoriesPage.this.updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private final class RemoveFileHandler
    implements SelectionListener {
        private final Table selectedFiles;

        private RemoveFileHandler(Table selectedFiles) {
            this.selectedFiles = selectedFiles;
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] selectedToRemove;
            TableItem[] tableItemArray = selectedToRemove = this.selectedFiles.getSelection();
            int n = selectedToRemove.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem victim = tableItemArray[n2];
                String victimName = victim.getText();
                ((BatchImportTraceWizard)ImportTraceWizardSelectDirectoriesPage.this.getWizard()).removeFile(victimName);
                ++n2;
            }
            ImportTraceWizardSelectDirectoriesPage.this.updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

