/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.properties;

import java.util.Map;
import java.util.TimeZone;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.properties.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TmfTimestampFormatPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
IPropertyChangeListener {
    private static final String[][] fDateTimeFormats = new String[][]{{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss"}, {"yy-MM-dd HH:mm:ss", "yy-MM-dd HH:mm:ss"}, {"MM-dd HH:mm:ss", "MM-dd HH:mm:ss"}, {"dd HH:mm:ss", "dd HH:mm:ss"}, {"DDD HH:mm:ss", "DDD HH:mm:ss"}, {"HH:mm:ss", "HH:mm:ss"}, {"mm:ss", "mm:ss"}, {"ss", "ss"}, {"TTT (secs in epoch)", "TTT"}, {"(none)", ""}};
    private static final String[][] fSubSecondFormats = new String[][]{{"SSS (ms)", "SSS"}, {"SSS SSS (\u00b5s)", "SSS SSS"}, {"SSS SSS SSS (ns)", "SSS SSS SSS"}};
    private static final String[][] fDateTimeDelimiters = new String[][]{{"(none)", ""}, {"  (space)", " "}, {", (comma)", ","}, {"- (dash)", "-"}, {"_ (underline)", "_"}, {": (colon)", ":"}, {"; (semicolon)", ";"}, {"/ (slash)", "/"}, {"' (quote)", "''"}, {"\" (dbl-quote)", "\""}};
    private static final String[][] fSubSecondDelimiters = new String[][]{{"(none)", ""}, {"  (space)", " "}, {", (comma)", ","}, {"- (dash)", "-"}, {"_ (underline)", "_"}, {": (colon)", ":"}, {"; (semicolon)", ";"}, {"/ (slash)", "/"}, {"' (quote)", "''"}, {"\" (dbl-quote)", "\""}, {". (period)", "."}};
    private static final String[] timeZones = new String[]{Messages.TmfTimestampFormatPage_LocalTime, "GMT-12", "GMT-11", "GMT-10", "GMT-9:30", "GMT-9", "GMT-7", "GMT-6", "GMT-5", "GMT-4", "GMT-3:30", "GMT-3", "GMT-2", "GMT-1", "GMT", "GMT+1", "GMT+2", "GMT+3", "GMT+3:30", "GMT+4", "GMT+4:30", "GMT+5", "GMT+5:30", "GMT+6", "GMT+7", "GMT+8", "GMT+9", "GMT+9:30", "GMT+10", "GMT+10:30", "GMT+11", "GMT+11:30", "GMT+12", "GMT+13:00", "GMT+14:00"};
    private Composite fPage;
    private IPreferenceStore fPreferenceStore = this.getPreferenceStore();
    private Composite fExampleSection;
    private Text fPatternDisplay;
    private Text fExampleDisplay;
    private ComboFieldEditor fCombo;
    private RadioGroupFieldEditor fDateTimeFields;
    private RadioGroupFieldEditor fSSecFields;
    private RadioGroupFieldEditor fDateFieldDelim;
    private RadioGroupFieldEditor fTimeFieldDelim;
    private RadioGroupFieldEditor fSSecFieldDelim;
    private String fProperty;
    private String fChangedProperty;
    private Map<String, String> fPreferenceMap = TmfTimePreferences.getPreferenceMap();

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getCorePreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        parent.setLayout((Layout)gl);
        this.fPage = new Composite(parent, 0);
        this.fPage.setLayout((Layout)new GridLayout());
        this.fPage.setLayoutData((Object)new GridData(1808));
        this.fExampleSection = new Composite(this.fPage, 0);
        this.fExampleSection.setLayout((Layout)new GridLayout(2, false));
        this.fExampleSection.setLayoutData((Object)new GridData(1808));
        Label patternLabel = new Label(this.fExampleSection, 256);
        patternLabel.setText("Current Format: ");
        this.fPatternDisplay = new Text(this.fExampleSection, 2056);
        this.fPatternDisplay.setLayoutData((Object)new GridData(768));
        Label exampleLabel = new Label(this.fExampleSection, 0);
        exampleLabel.setText("Sample Display: ");
        this.fExampleDisplay = new Text(this.fExampleSection, 2056);
        this.fExampleDisplay.setLayoutData((Object)new GridData(768));
        Label separator = new Label(this.fPage, 290);
        separator.setLayoutData((Object)new GridData(784));
        String[][] timeZoneIntervals = new String[timeZones.length][2];
        timeZoneIntervals[0][0] = timeZones[0];
        timeZoneIntervals[0][1] = this.fPreferenceStore.getDefaultString("org.eclipse.linuxtools.tmf.core.prefs.time.format.timezone");
        int i = 1;
        while (i < timeZones.length) {
            TimeZone tz = null;
            try {
                tz = TimeZone.getTimeZone(timeZones[i]);
                timeZoneIntervals[i][0] = tz.getDisplayName();
                timeZoneIntervals[i][1] = tz.getID();
            }
            catch (NullPointerException e) {
                System.out.println("TimeZone " + timeZones[i] + " does not exist.");
            }
            ++i;
        }
        this.fCombo = new ComboFieldEditor("org.eclipse.linuxtools.tmf.core.prefs.time.format.timezone", "Time Zone", timeZoneIntervals, this.fPage);
        this.fCombo.setPreferenceStore(this.fPreferenceStore);
        this.fCombo.load();
        this.fCombo.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fDateTimeFields = new RadioGroupFieldEditor("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "Date and Time format", 3, fDateTimeFormats, this.fPage, true);
        this.fDateTimeFields.setPreferenceStore(this.fPreferenceStore);
        this.fDateTimeFields.load();
        this.fDateTimeFields.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fSSecFields = new RadioGroupFieldEditor("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", "Sub-second format", 3, fSubSecondFormats, this.fPage, true);
        this.fSSecFields.setPreferenceStore(this.fPreferenceStore);
        this.fSSecFields.load();
        this.fSSecFields.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fDateFieldDelim = new RadioGroupFieldEditor("org.eclipse.linuxtools.tmf.core.prefs.time.format.date.delimiter", "Date delimiter", 5, fDateTimeDelimiters, this.fPage, true);
        this.fDateFieldDelim.setPreferenceStore(this.fPreferenceStore);
        this.fDateFieldDelim.load();
        this.fDateFieldDelim.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fTimeFieldDelim = new RadioGroupFieldEditor("org.eclipse.linuxtools.tmf.core.prefs.time.format.time.delimiter", "Time delimiter", 5, fDateTimeDelimiters, this.fPage, true);
        this.fTimeFieldDelim.setPreferenceStore(this.fPreferenceStore);
        this.fTimeFieldDelim.load();
        this.fTimeFieldDelim.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fSSecFieldDelim = new RadioGroupFieldEditor("org.eclipse.linuxtools.tmf.core.prefs.time.format.ssec.delimiter", "Sub-Second Delimiter", 5, fSubSecondDelimiters, this.fPage, true);
        this.fSSecFieldDelim.setPreferenceStore(this.fPreferenceStore);
        this.fSSecFieldDelim.load();
        this.fSSecFieldDelim.setPropertyChangeListener((IPropertyChangeListener)this);
        this.refresh();
        return this.fPage;
    }

    protected void performDefaults() {
        this.fDateTimeFields.loadDefault();
        this.fSSecFields.loadDefault();
        this.fDateFieldDelim.loadDefault();
        this.fTimeFieldDelim.loadDefault();
        this.fSSecFieldDelim.loadDefault();
        this.fCombo.loadDefault();
        this.fPreferenceMap = TmfTimePreferences.getDefaultPreferenceMap();
        this.displayExample();
    }

    protected void performApply() {
        this.fDateTimeFields.store();
        this.fSSecFields.store();
        this.fDateFieldDelim.store();
        this.fTimeFieldDelim.store();
        this.fSSecFieldDelim.store();
        this.fCombo.store();
        TmfTimestampFormat.updateDefaultFormats();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimestampFormatUpdateSignal(null));
        this.displayExample();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        Object value = event.getNewValue();
        if (source instanceof RadioGroupFieldEditor && value instanceof String && (!value.equals(this.fChangedProperty) || !source.equals(this.fProperty))) {
            this.fProperty = ((RadioGroupFieldEditor)source).getPreferenceName();
            this.fChangedProperty = (String)value;
            this.refresh();
        }
    }

    private void refresh() {
        this.updatePatterns();
        this.displayExample();
    }

    void updatePatterns() {
        if ("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime".equals(this.fProperty) || "org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec".equals(this.fProperty) || "org.eclipse.linuxtools.tmf.core.prefs.time.format.date.delimiter".equals(this.fProperty) || "org.eclipse.linuxtools.tmf.core.prefs.time.format.time.delimiter".equals(this.fProperty) || "org.eclipse.linuxtools.tmf.core.prefs.time.format.ssec.delimiter".equals(this.fProperty)) {
            this.fPreferenceMap.put(this.fProperty, this.fChangedProperty);
        }
    }

    private void displayExample() {
        long ts = 1332170682500677380L;
        String timePattern = TmfTimePreferences.computeTimePattern(this.fPreferenceMap);
        this.fPatternDisplay.setText(timePattern);
        this.fPatternDisplay.redraw();
        this.fExampleDisplay.setText(new TmfTimestampFormat(timePattern).format(ts));
        this.fExampleDisplay.redraw();
    }
}

