/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.statistics.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;

public class TmfStatisticsTreeManager {
    private static final Map<String, TmfStatisticsTree> fTreeInstances = new HashMap<String, TmfStatisticsTree>();

    public static TmfStatisticsTreeNode getStatTreeRoot(String traceUniqueId) {
        TmfStatisticsTree tree = TmfStatisticsTreeManager.getStatTree(traceUniqueId);
        if (tree == null) {
            return null;
        }
        return tree.getRootNode();
    }

    public static TmfStatisticsTree getStatTree(String traceUniqueId) {
        if (traceUniqueId == null) {
            return null;
        }
        TmfStatisticsTree tree = fTreeInstances.get(traceUniqueId);
        return tree;
    }

    public static TmfStatisticsTreeNode addStatsTreeRoot(String traceUniqueId, TmfStatisticsTree statsData) {
        if (traceUniqueId == null || statsData == null) {
            return null;
        }
        fTreeInstances.put(traceUniqueId, statsData);
        return statsData.getRootNode();
    }

    public static boolean containsTreeRoot(String traceUniqueId) {
        return fTreeInstances.containsKey(traceUniqueId);
    }

    public static void removeStatTreeRoot(String traceUniqueId) {
        if (traceUniqueId != null && fTreeInstances.containsKey(traceUniqueId)) {
            fTreeInstances.remove(traceUniqueId);
        }
    }

    public static void removeAll() {
        fTreeInstances.clear();
    }
}

