/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.tree;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class TmfTreeColumnData {
    private final String fText;
    private int fWidth = -1;
    private int fAlignment = 16384;
    private String fTooltip = null;
    private ViewerComparator fComparator = null;
    private boolean fMovable = false;
    private ITmfColumnPercentageProvider fPercentageProvider = null;

    public TmfTreeColumnData(String text) {
        this.fText = text;
    }

    public String getText() {
        return this.fText;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public int getAlignment() {
        return this.fAlignment;
    }

    public String getTooltip() {
        return this.fTooltip;
    }

    public ViewerComparator getComparator() {
        return this.fComparator;
    }

    public ITmfColumnPercentageProvider getPercentageProvider() {
        return this.fPercentageProvider;
    }

    public boolean isMovable() {
        return this.fMovable;
    }

    public void setWidth(int width) {
        this.fWidth = width;
    }

    public void setAlignment(int alignment) {
        this.fAlignment = alignment;
    }

    public void setTooltip(String tooltip) {
        this.fTooltip = tooltip;
    }

    public void setComparator(ViewerComparator comparator) {
        this.fComparator = comparator;
    }

    public void setPercentageProvider(ITmfColumnPercentageProvider percentProvider) {
        this.fPercentageProvider = percentProvider;
    }

    public void setMovable(boolean movable) {
        this.fMovable = movable;
    }

    @NonNull
    public TreeViewerColumn createColumn(final TreeViewer treeViewer) {
        final TreeViewerColumn column = new TreeViewerColumn(treeViewer, this.getAlignment());
        final TmfTreeColumnData columnData = this;
        column.getColumn().setText(this.getText());
        if (this.getWidth() != -1) {
            column.getColumn().setWidth(this.getWidth());
        }
        if (this.getTooltip() != null) {
            column.getColumn().setToolTipText(this.getTooltip());
        }
        column.getColumn().setMoveable(this.isMovable());
        if (this.getComparator() != null) {
            column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (treeViewer.getTree().getSortDirection() == 128 || treeViewer.getTree().getSortColumn() != column.getColumn()) {
                        treeViewer.setComparator(columnData.getComparator());
                        treeViewer.getTree().setSortDirection(1024);
                    } else {
                        ViewerComparator reverseComparator = new ViewerComparator(){

                            public int compare(Viewer viewer, Object e1, Object e2) {
                                return -1 * columnData.getComparator().compare(viewer, e1, e2);
                            }
                        };
                        treeViewer.setComparator(reverseComparator);
                        treeViewer.getTree().setSortDirection(128);
                    }
                    treeViewer.getTree().setSortColumn(column.getColumn());
                }
            });
        }
        return column;
    }

    public static interface ITmfColumnPercentageProvider {
        public double getPercentage(Object var1);
    }
}

