/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.barcharts;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.swtchart.IAxis;
import org.swtchart.ISeries;

public class TmfHistogramTooltipProvider
extends TmfBaseProvider
implements MouseTrackListener,
MouseMoveListener,
PaintListener {
    private int fHighlightX;
    private int fHighlightY;
    private boolean fIsHighlight;

    public TmfHistogramTooltipProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.getChart().getPlotArea().addMouseTrackListener((MouseTrackListener)this);
        this.getChart().getPlotArea().addMouseMoveListener((MouseMoveListener)this);
        this.getChart().getPlotArea().addPaintListener((PaintListener)this);
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.getChart().getPlotArea().removeMouseTrackListener((MouseTrackListener)this);
            this.getChart().getPlotArea().removeMouseMoveListener((MouseMoveListener)this);
            this.getChart().getPlotArea().removePaintListener((PaintListener)this);
        }
    }

    @Override
    public void refresh() {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
        if (this.getChartViewer().getWindowDuration() != 0L) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            IAxis yAxis = this.getChart().getAxisSet().getYAxis(0);
            double xCoordinate = xAxis.getDataCoordinate(e.x);
            ISeries[] series = this.getChart().getSeriesSet().getSeries();
            if (xCoordinate < 0.0 || series.length == 0) {
                return;
            }
            double y = 0.0;
            double rangeStart = 0.0;
            double rangeEnd = 0.0;
            double[] xS = series[0].getXSeries();
            double[] yS = series[0].getYSeries();
            if (xS == null || yS == null) {
                return;
            }
            int i = 0;
            while (i < xS.length - 1) {
                int pixel = xAxis.getPixelCoordinate(xS[i]);
                if (pixel <= e.x) {
                    rangeStart = xS[i];
                    rangeEnd = (long)xS[i + 1];
                    y = xCoordinate >= rangeStart ? yS[i + 1] : yS[i];
                }
                ++i;
            }
            ITmfChartTimeProvider viewer = this.getChartViewer();
            StringBuffer buffer = new StringBuffer();
            buffer.append("Range=[");
            buffer.append(new TmfTimestamp((long)rangeStart + viewer.getTimeOffset(), -9).toString());
            buffer.append(',');
            buffer.append(new TmfTimestamp((long)rangeEnd + viewer.getTimeOffset(), -9).toString());
            buffer.append("]\n");
            buffer.append("y=");
            buffer.append((long)y);
            this.getChart().getPlotArea().setToolTipText(buffer.toString());
            this.fHighlightX = e.x;
            this.fHighlightY = yAxis.getPixelCoordinate(y);
            this.fIsHighlight = true;
            this.getChart().redraw();
        }
    }

    public void mouseMove(MouseEvent e) {
        this.fIsHighlight = false;
        this.getChart().redraw();
    }

    public void paintControl(PaintEvent e) {
        if (this.fIsHighlight) {
            e.gc.setBackground(Display.getDefault().getSystemColor(3));
            e.gc.setAlpha(128);
            e.gc.fillOval(this.fHighlightX - 5, this.fHighlightY - 5, 10, 10);
        }
    }
}

