/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTreeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphSelectionEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.TimeGraphLegend;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeDataProviderCyclesConverter;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphScale;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphTooltipHandler;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class TimeGraphViewer
implements ITimeDataProvider,
SelectionListener {
    public static final int ALL_LEVELS = -1;
    private static final int DEFAULT_NAME_WIDTH = 200;
    private static final int MIN_NAME_WIDTH = 6;
    private static final int MAX_NAME_WIDTH = 1000;
    private static final int DEFAULT_HEIGHT = 22;
    private static final String HIDE_ARROWS_KEY = "hide.arrows";
    private static final long DEFAULT_FREQUENCY = 1000000000L;
    private static final int H_SCROLLBAR_MAX = 0x7FFFFFFE;
    private long fMinTimeInterval;
    private ITimeGraphEntry fSelectedEntry;
    private long fBeginTime = -1L;
    private long fEndTime = -1L;
    private long fTime0 = -1L;
    private long fTime1 = -1L;
    private long fSelectionBegin = -1L;
    private long fSelectionEnd = -1L;
    private long fTime0Bound = -1L;
    private long fTime1Bound = -1L;
    private long fTime0ExtSynch = -1L;
    private long fTime1ExtSynch = -1L;
    private boolean fTimeRangeFixed;
    private int fNameWidthPref = 200;
    private int fMinNameWidth = 6;
    private int fNameWidth;
    private Composite fDataViewer;
    private TimeGraphControl fTimeGraphCtrl;
    private TimeGraphScale fTimeScaleCtrl;
    private Slider fHorizontalScrollBar;
    private Slider fVerticalScrollBar;
    private TimeGraphColorScheme fColorScheme;
    private Object fInputElement;
    private ITimeGraphContentProvider fTimeGraphContentProvider;
    private ITimeGraphPresentationProvider fTimeGraphProvider;
    private ITimeDataProvider fTimeDataProvider = this;
    private TimeGraphTooltipHandler fToolTipHandler;
    private List<ITimeGraphSelectionListener> fSelectionListeners = new ArrayList<ITimeGraphSelectionListener>();
    private List<ITimeGraphTimeListener> fTimeListeners = new ArrayList<ITimeGraphTimeListener>();
    private List<ITimeGraphRangeListener> fRangeListeners = new ArrayList<ITimeGraphRangeListener>();
    private Utils.TimeFormat fTimeFormat = Utils.TimeFormat.RELATIVE;
    private long fClockFrequency = 1000000000L;
    private int fBorderWidth = 0;
    private int fTimeScaleHeight = 22;
    private Action fResetScaleAction;
    private Action fShowLegendAction;
    private Action fNextEventAction;
    private Action fPrevEventAction;
    private Action fNextItemAction;
    private Action fPreviousItemAction;
    private Action fZoomInAction;
    private Action fZoomOutAction;
    private Action fHideArrowsAction;
    private Action fFollowArrowFwdAction;
    private Action fFollowArrowBwdAction;
    private ListenerNotifier fListenerNotifier;
    private Composite fTimeAlignedComposite;

    public TimeGraphViewer(Composite parent, int style) {
        this.createDataViewer(parent, style);
        this.fTimeGraphContentProvider = new TimeGraphContentProvider();
    }

    public void setTimeGraphContentProvider(ITimeGraphContentProvider timeGraphContentProvider) {
        this.fTimeGraphContentProvider = timeGraphContentProvider;
    }

    public ITimeGraphContentProvider getTimeGraphContentProvider() {
        return this.fTimeGraphContentProvider;
    }

    public void setTimeGraphProvider(ITimeGraphPresentationProvider timeGraphProvider) {
        this.fTimeGraphProvider = timeGraphProvider;
        this.fTimeGraphCtrl.setTimeGraphProvider(timeGraphProvider);
        this.fToolTipHandler = new TimeGraphTooltipHandler(this.fTimeGraphProvider, this.fTimeDataProvider);
        this.fToolTipHandler.activateHoverHelp((Control)this.fTimeGraphCtrl);
    }

    public void setInput(Object inputElement) {
        this.fInputElement = inputElement;
        ITimeGraphEntry[] input = this.fTimeGraphContentProvider.getElements(inputElement);
        this.fListenerNotifier = null;
        if (this.fTimeGraphCtrl != null) {
            this.setTimeRange(input);
            this.setTopIndex(0);
            this.fSelectionBegin = -1L;
            this.fSelectionEnd = -1L;
            this.fSelectedEntry = null;
            this.refreshAllData(input);
        }
    }

    public Object getInput() {
        return this.fInputElement;
    }

    public void setLinks(List<ILinkEvent> links) {
        if (this.fTimeGraphCtrl != null) {
            this.fTimeGraphCtrl.refreshArrows(links);
        }
    }

    public void refresh() {
        ITimeGraphEntry[] input = this.fTimeGraphContentProvider.getElements(this.fInputElement);
        this.setTimeRange(input);
        this.refreshAllData(input);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.resizeControls();
    }

    protected String getViewTypeStr() {
        return "viewoption.threads";
    }

    int getMarginWidth() {
        return 0;
    }

    int getMarginHeight() {
        return 0;
    }

    void loadOptions() {
        this.fMinTimeInterval = 1L;
        this.fSelectionBegin = -1L;
        this.fSelectionEnd = -1L;
        this.fNameWidth = Utils.loadIntOption(this.getPreferenceString("namewidth"), this.fNameWidthPref, this.fMinNameWidth, 1000);
    }

    void saveOptions() {
        Utils.saveIntOption(this.getPreferenceString("namewidth"), this.fNameWidth);
    }

    protected Control createDataViewer(Composite parent, int style) {
        this.loadOptions();
        this.fColorScheme = new TimeGraphColorScheme();
        this.fDataViewer = new Composite(parent, style){

            public void redraw() {
                TimeGraphViewer.this.fTimeScaleCtrl.redraw();
                TimeGraphViewer.this.fTimeGraphCtrl.redraw();
                super.redraw();
            }
        };
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = this.fBorderWidth;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.fDataViewer.setLayout((Layout)gl);
        this.fTimeAlignedComposite = new Composite(this.fDataViewer, style){

            public void redraw() {
                TimeGraphViewer.this.fDataViewer.redraw();
                super.redraw();
            }
        };
        GridLayout gl2 = new GridLayout(1, false);
        gl2.marginHeight = this.fBorderWidth;
        gl2.marginWidth = 0;
        gl2.verticalSpacing = 0;
        gl2.horizontalSpacing = 0;
        this.fTimeAlignedComposite.setLayout((Layout)gl2);
        this.fTimeAlignedComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTimeScaleCtrl = new TimeGraphScale(this.fTimeAlignedComposite, this.fColorScheme);
        this.fTimeScaleCtrl.setTimeProvider(this.fTimeDataProvider);
        this.fTimeScaleCtrl.setLayoutData(new GridData(4, -1, true, false));
        this.fTimeScaleCtrl.setHeight(this.fTimeScaleHeight);
        this.fTimeScaleCtrl.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                TimeGraphViewer.this.fTimeGraphCtrl.zoom(e.count > 0);
            }
        });
        this.fTimeGraphCtrl = this.createTimeGraphControl(this.fTimeAlignedComposite, this.fColorScheme);
        this.fTimeGraphCtrl.setTimeProvider(this);
        this.fTimeGraphCtrl.setTimeGraphScale(this.fTimeScaleCtrl);
        this.fTimeGraphCtrl.addSelectionListener(this);
        this.fTimeGraphCtrl.setLayoutData(new GridData(4, 4, true, true));
        this.fTimeGraphCtrl.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                TimeGraphViewer.this.adjustVerticalScrollBar();
            }
        });
        this.fTimeGraphCtrl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '+') {
                    TimeGraphViewer.this.zoomIn();
                } else if (e.character == '-') {
                    TimeGraphViewer.this.zoomOut();
                }
                TimeGraphViewer.this.adjustVerticalScrollBar();
            }
        });
        this.fVerticalScrollBar = new Slider(this.fDataViewer, 524800);
        this.fVerticalScrollBar.setLayoutData((Object)new GridData(-1, 4, false, true, 1, 1));
        this.fVerticalScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeGraphViewer.this.setTopIndex(TimeGraphViewer.this.fVerticalScrollBar.getSelection());
            }
        });
        this.fHorizontalScrollBar = new Slider(this.fDataViewer, 524544);
        this.fHorizontalScrollBar.setLayoutData((Object)new GridData(4, -1, true, false));
        this.fHorizontalScrollBar.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if ((event.stateMask & SWT.MODIFIER_MASK) == 262144) {
                    TimeGraphViewer.this.getTimeGraphControl().zoom(event.count > 0);
                } else {
                    TimeGraphViewer.this.getTimeGraphControl().horizontalScroll(event.count > 0);
                }
                event.doit = false;
            }
        });
        this.fHorizontalScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int start = TimeGraphViewer.this.fHorizontalScrollBar.getSelection();
                long time0 = TimeGraphViewer.this.getTime0();
                long time1 = TimeGraphViewer.this.getTime1();
                long timeMin = TimeGraphViewer.this.getMinTime();
                long timeMax = TimeGraphViewer.this.getMaxTime();
                long delta = timeMax - timeMin;
                long range = time1 - time0;
                time0 = timeMin + Math.round((double)delta * ((double)start / 2.147483646E9));
                time1 = time0 + range;
                TimeGraphViewer.this.setStartFinishTimeNotify(time0, time1);
            }
        });
        Composite filler = new Composite(this.fDataViewer, 0);
        GridData gd = new GridData(-1, -1, false, false);
        gd.heightHint = this.fHorizontalScrollBar.getSize().y;
        filler.setLayoutData((Object)gd);
        filler.setLayout((Layout)new FillLayout());
        this.fTimeGraphCtrl.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                TimeGraphViewer.this.resizeControls();
            }
        });
        this.resizeControls();
        this.fDataViewer.update();
        this.adjustHorizontalScrollBar();
        this.adjustVerticalScrollBar();
        return this.fDataViewer;
    }

    public void dispose() {
        this.saveOptions();
        this.fTimeGraphCtrl.dispose();
        this.fDataViewer.dispose();
        this.fColorScheme.dispose();
    }

    protected TimeGraphControl createTimeGraphControl(Composite parent, TimeGraphColorScheme colors) {
        return new TimeGraphControl(parent, colors);
    }

    public void resizeControls() {
        Rectangle r = this.fDataViewer.getClientArea();
        if (r.isEmpty()) {
            return;
        }
        int width = r.width;
        if (this.fNameWidth > width - this.fMinNameWidth) {
            this.fNameWidth = width - this.fMinNameWidth;
        }
        if (this.fNameWidth < this.fMinNameWidth) {
            this.fNameWidth = this.fMinNameWidth;
        }
        this.adjustHorizontalScrollBar();
        this.adjustVerticalScrollBar();
    }

    public void setTimeRange(ITimeGraphEntry[] entries) {
        this.fTime0Bound = this.fBeginTime != -1L ? this.fBeginTime : this.fEndTime;
        long l = this.fTime1Bound = this.fEndTime != -1L ? this.fEndTime : this.fBeginTime;
        if (this.fBeginTime != -1L && this.fEndTime != -1L) {
            return;
        }
        if (entries == null || entries.length == 0) {
            return;
        }
        if (this.fTime0Bound == -1L) {
            this.fTime0Bound = Long.MAX_VALUE;
        }
        if (this.fTime1Bound == -1L) {
            this.fTime1Bound = Long.MIN_VALUE;
        }
        ITimeGraphEntry[] iTimeGraphEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ITimeGraphEntry entry = iTimeGraphEntryArray[n2];
            this.setTimeRange(entry);
            ++n2;
        }
    }

    private void setTimeRange(ITimeGraphEntry entry) {
        if (this.fBeginTime == -1L && entry.hasTimeEvents() && entry.getStartTime() != -1L) {
            this.fTime0Bound = Math.min(entry.getStartTime(), this.fTime0Bound);
        }
        if (this.fEndTime == -1L && entry.hasTimeEvents() && entry.getEndTime() != -1L) {
            this.fTime1Bound = Math.max(entry.getEndTime(), this.fTime1Bound);
        }
        if (entry.hasChildren()) {
            for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
                this.setTimeRange(iTimeGraphEntry);
            }
        }
    }

    public void setTimeBounds(long beginTime, long endTime) {
        this.fBeginTime = beginTime;
        this.fEndTime = endTime;
        this.fTime0Bound = this.fBeginTime != -1L ? this.fBeginTime : this.fEndTime;
        long l = this.fTime1Bound = this.fEndTime != -1L ? this.fEndTime : this.fBeginTime;
        if (this.fTime0Bound > this.fTime1Bound) {
            this.fBeginTime = endTime;
            this.fEndTime = beginTime;
            this.fTime0Bound = this.fBeginTime;
            this.fTime1Bound = this.fEndTime;
        }
        this.adjustHorizontalScrollBar();
    }

    public void setTimeBounds() {
        if (!this.fTimeRangeFixed) {
            this.fTime0 = this.fTime0Bound;
            this.fTime1 = this.fTime1Bound;
        }
        this.fTime0 = Math.max(this.fTime0Bound, Math.min(this.fTime0, this.fTime1Bound));
        this.fTime1 = Math.max(this.fTime0Bound, Math.min(this.fTime1, this.fTime1Bound));
        if (this.fTime1 - this.fTime0 < this.fMinTimeInterval) {
            this.fTime1 = Math.min(this.fTime1Bound, this.fTime0 + this.fMinTimeInterval);
        }
    }

    private void refreshAllData(ITimeGraphEntry[] traces) {
        this.setTimeBounds();
        if (this.fSelectionBegin < this.fBeginTime) {
            this.fSelectionBegin = this.fBeginTime;
        } else if (this.fSelectionBegin > this.fEndTime) {
            this.fSelectionBegin = this.fEndTime;
        }
        if (this.fSelectionEnd < this.fBeginTime) {
            this.fSelectionEnd = this.fBeginTime;
        } else if (this.fSelectionEnd > this.fEndTime) {
            this.fSelectionEnd = this.fEndTime;
        }
        this.fTimeGraphCtrl.refreshData(traces);
        this.fTimeScaleCtrl.redraw();
        this.adjustVerticalScrollBar();
    }

    public void setFocus() {
        if (this.fTimeGraphCtrl != null) {
            this.fTimeGraphCtrl.setFocus();
        }
    }

    public boolean isInFocus() {
        return this.fTimeGraphCtrl.isInFocus();
    }

    public ITimeGraphEntry getSelection() {
        return this.fTimeGraphCtrl.getSelectedTrace();
    }

    public int getSelectionIndex() {
        return this.fTimeGraphCtrl.getSelectedIndex();
    }

    @Override
    public long getTime0() {
        return this.fTime0;
    }

    @Override
    public long getTime1() {
        return this.fTime1;
    }

    @Override
    public long getMinTimeInterval() {
        return this.fMinTimeInterval;
    }

    @Override
    public int getNameSpace() {
        return this.fNameWidth;
    }

    @Override
    public void setNameSpace(int width) {
        this.fNameWidth = width;
        int w = this.fTimeGraphCtrl.getClientArea().width;
        if (this.fNameWidth > w - 6) {
            this.fNameWidth = w - 6;
        }
        if (this.fNameWidth < 6) {
            this.fNameWidth = 6;
        }
        this.fTimeGraphCtrl.redraw();
        this.fTimeScaleCtrl.redraw();
    }

    @Override
    public int getTimeSpace() {
        int w = this.fTimeGraphCtrl.getClientArea().width;
        return w - this.fNameWidth;
    }

    @Override
    public long getBeginTime() {
        return this.fBeginTime;
    }

    @Override
    public long getEndTime() {
        return this.fEndTime;
    }

    @Override
    public long getMaxTime() {
        return this.fTime1Bound;
    }

    @Override
    public long getMinTime() {
        return this.fTime0Bound;
    }

    @Override
    public long getSelectionBegin() {
        return this.fSelectionBegin;
    }

    @Override
    public long getSelectionEnd() {
        return this.fSelectionEnd;
    }

    @Override
    public void setStartFinishTimeNotify(long time0, long time1) {
        this.setStartFinishTimeInt(time0, time1);
        this.notifyRangeListeners();
    }

    @Override
    public void notifyStartFinishTime() {
        this.notifyRangeListeners();
    }

    @Override
    public void setStartFinishTime(long time0, long time1) {
        if (this.fListenerNotifier != null && this.fListenerNotifier.hasTimeRangeUpdated()) {
            return;
        }
        this.setStartFinishTimeInt(time0, time1);
        this.updateExtSynchValues();
    }

    private void setStartFinishTimeInt(long time0, long time1) {
        this.fTime0 = time0;
        if (this.fTime0 < this.fTime0Bound) {
            this.fTime0 = this.fTime0Bound;
        }
        if (this.fTime0 > this.fTime1Bound) {
            this.fTime0 = this.fTime1Bound;
        }
        this.fTime1 = time1;
        if (this.fTime1 < this.fTime0Bound) {
            this.fTime1 = this.fTime0Bound;
        }
        if (this.fTime1 > this.fTime1Bound) {
            this.fTime1 = this.fTime1Bound;
        }
        if (this.fTime1 - this.fTime0 < this.fMinTimeInterval) {
            this.fTime1 = Math.min(this.fTime1Bound, this.fTime0 + this.fMinTimeInterval);
        }
        this.fTimeRangeFixed = true;
        this.adjustHorizontalScrollBar();
        this.fTimeGraphCtrl.redraw();
        this.fTimeScaleCtrl.redraw();
    }

    @Override
    public void resetStartFinishTime() {
        this.setStartFinishTimeNotify(this.fTime0Bound, this.fTime1Bound);
        this.fTimeRangeFixed = false;
    }

    @Override
    public void setSelectedTimeNotify(long time, boolean ensureVisible) {
        this.setSelectedTimeInt(time, ensureVisible, true);
    }

    @Override
    public void setSelectedTime(long time, boolean ensureVisible) {
        if (this.fListenerNotifier != null && this.fListenerNotifier.hasTimeSelected()) {
            return;
        }
        this.setSelectedTimeInt(time, ensureVisible, false);
    }

    @Override
    public void setSelectionRangeNotify(long beginTime, long endTime) {
        long time0 = this.fTime0;
        long time1 = this.fTime1;
        boolean changed = beginTime != this.fSelectionBegin || endTime != this.fSelectionEnd;
        this.fSelectionBegin = Math.max(this.fTime0Bound, Math.min(this.fTime1Bound, beginTime));
        this.fSelectionEnd = Math.max(this.fTime0Bound, Math.min(this.fTime1Bound, endTime));
        this.ensureVisible(this.fSelectionEnd);
        this.fTimeGraphCtrl.redraw();
        this.fTimeScaleCtrl.redraw();
        if (time0 != this.fTime0 || time1 != this.fTime1) {
            this.notifyRangeListeners();
        }
        if (changed) {
            this.notifyTimeListeners();
        }
    }

    @Override
    public void setSelectionRange(long beginTime, long endTime) {
        if (this.fListenerNotifier != null && this.fListenerNotifier.hasTimeSelected()) {
            return;
        }
        this.fSelectionBegin = Math.max(this.fTime0Bound, Math.min(this.fTime1Bound, beginTime));
        this.fSelectionEnd = Math.max(this.fTime0Bound, Math.min(this.fTime1Bound, endTime));
        this.fTimeGraphCtrl.redraw();
        this.fTimeScaleCtrl.redraw();
    }

    private void setSelectedTimeInt(long time, boolean ensureVisible, boolean doNotify) {
        long time0 = this.fTime0;
        long time1 = this.fTime1;
        if (ensureVisible) {
            this.ensureVisible(time);
        }
        this.fTimeGraphCtrl.redraw();
        this.fTimeScaleCtrl.redraw();
        boolean notifySelectedTime = time != this.fSelectionBegin || time != this.fSelectionEnd;
        this.fSelectionBegin = time;
        this.fSelectionEnd = time;
        if (time0 != this.fTime0 || time1 != this.fTime1) {
            this.notifyRangeListeners();
        }
        if (doNotify && notifySelectedTime) {
            this.notifyTimeListeners();
        }
    }

    private void ensureVisible(long time) {
        long timeMid = (this.fTime1 - this.fTime0) / 2L;
        if (time < this.fTime0) {
            long dt = this.fTime0 - time + timeMid;
            this.fTime0 -= dt;
            this.fTime1 -= dt;
        } else if (time > this.fTime1) {
            long dt = time - this.fTime1 + timeMid;
            this.fTime0 += dt;
            this.fTime1 += dt;
        }
        if (this.fTime0 < this.fTime0Bound) {
            this.fTime1 = Math.min(this.fTime1Bound, this.fTime1 + (this.fTime0Bound - this.fTime0));
            this.fTime0 = this.fTime0Bound;
        } else if (this.fTime1 > this.fTime1Bound) {
            this.fTime0 = Math.max(this.fTime0Bound, this.fTime0 - (this.fTime1 - this.fTime1Bound));
            this.fTime1 = this.fTime1Bound;
        }
        if (this.fTime1 - this.fTime0 < this.fMinTimeInterval) {
            this.fTime1 = Math.min(this.fTime1Bound, this.fTime0 + this.fMinTimeInterval);
        }
        this.adjustHorizontalScrollBar();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.fSelectedEntry != this.getSelection()) {
            this.fSelectedEntry = this.getSelection();
            this.notifySelectionListeners();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.fSelectedEntry != this.getSelection()) {
            this.fSelectedEntry = this.getSelection();
            this.notifySelectionListeners();
        }
    }

    public void selectNextEvent(boolean extend) {
        this.fTimeGraphCtrl.selectNextEvent(extend);
        this.adjustVerticalScrollBar();
    }

    public void selectPrevEvent(boolean extend) {
        this.fTimeGraphCtrl.selectPrevEvent(extend);
        this.adjustVerticalScrollBar();
    }

    public void selectNextItem() {
        this.fTimeGraphCtrl.selectNextTrace();
        this.adjustVerticalScrollBar();
    }

    public void selectPrevItem() {
        this.fTimeGraphCtrl.selectPrevTrace();
        this.adjustVerticalScrollBar();
    }

    public void showLegend() {
        if (this.fDataViewer == null || this.fDataViewer.isDisposed()) {
            return;
        }
        TimeGraphLegend.open(this.fDataViewer.getShell(), this.fTimeGraphProvider);
    }

    public void zoomIn() {
        this.fTimeGraphCtrl.zoomIn();
    }

    public void zoomOut() {
        this.fTimeGraphCtrl.zoomOut();
    }

    private String getPreferenceString(String string) {
        return String.valueOf(this.getViewTypeStr()) + "." + string;
    }

    public void addSelectionListener(ITimeGraphSelectionListener listener) {
        this.fSelectionListeners.add(listener);
    }

    public void removeSelectionListener(ITimeGraphSelectionListener listener) {
        this.fSelectionListeners.remove(listener);
    }

    private void notifySelectionListeners() {
        if (this.fListenerNotifier == null) {
            this.fListenerNotifier = new ListenerNotifier();
            this.fListenerNotifier.start();
        }
        this.fListenerNotifier.selectionChanged();
    }

    private void fireSelectionChanged(ITimeGraphEntry selection) {
        TimeGraphSelectionEvent event = new TimeGraphSelectionEvent(this, selection);
        for (ITimeGraphSelectionListener listener : this.fSelectionListeners) {
            listener.selectionChanged(event);
        }
    }

    public void addTimeListener(ITimeGraphTimeListener listener) {
        this.fTimeListeners.add(listener);
    }

    public void removeTimeListener(ITimeGraphTimeListener listener) {
        this.fTimeListeners.remove(listener);
    }

    private void notifyTimeListeners() {
        if (this.fListenerNotifier == null) {
            this.fListenerNotifier = new ListenerNotifier();
            this.fListenerNotifier.start();
        }
        this.fListenerNotifier.timeSelected();
    }

    private void fireTimeSelected(long startTime, long endTime) {
        TimeGraphTimeEvent event = new TimeGraphTimeEvent(this, startTime, endTime);
        for (ITimeGraphTimeListener listener : this.fTimeListeners) {
            listener.timeSelected(event);
        }
    }

    public void addRangeListener(ITimeGraphRangeListener listener) {
        this.fRangeListeners.add(listener);
    }

    public void removeRangeListener(ITimeGraphRangeListener listener) {
        this.fRangeListeners.remove(listener);
    }

    private void notifyRangeListeners() {
        if (this.fListenerNotifier == null) {
            this.fListenerNotifier = new ListenerNotifier();
            this.fListenerNotifier.start();
        }
        this.fListenerNotifier.timeRangeUpdated();
    }

    private void fireTimeRangeUpdated(long startTime, long endTime) {
        if (startTime != this.fTime0ExtSynch || endTime != this.fTime1ExtSynch) {
            TimeGraphRangeUpdateEvent event = new TimeGraphRangeUpdateEvent(this, startTime, endTime);
            for (ITimeGraphRangeListener listener : this.fRangeListeners) {
                listener.timeRangeUpdated(event);
            }
            this.updateExtSynchValues();
        }
    }

    public void setSelectedEvent(ITimeEvent event, Object source) {
        if (event == null || source == this) {
            return;
        }
        this.fSelectedEntry = event.getEntry();
        this.fTimeGraphCtrl.selectItem(this.fSelectedEntry, false);
        this.setSelectedTimeInt(event.getTime(), true, true);
        this.adjustVerticalScrollBar();
    }

    public void setSelectedTraceTime(ITimeGraphEntry trace, long time, Object source) {
        if (trace == null || source == this) {
            return;
        }
        this.fSelectedEntry = trace;
        this.fTimeGraphCtrl.selectItem(trace, false);
        this.setSelectedTimeInt(time, true, true);
    }

    public void setSelection(ITimeGraphEntry trace) {
        if (this.fListenerNotifier != null && this.fListenerNotifier.hasSelectionChanged()) {
            return;
        }
        this.fSelectedEntry = trace;
        this.fTimeGraphCtrl.selectItem(trace, false);
        this.adjustVerticalScrollBar();
    }

    public void setSelectVisTimeWindow(long time0, long time1, Object source) {
        if (source == this) {
            return;
        }
        this.setStartFinishTimeInt(time0, time1);
        this.updateExtSynchValues();
    }

    private void updateExtSynchValues() {
        this.fTime0ExtSynch = this.fTime0;
        this.fTime1ExtSynch = this.fTime1;
    }

    @Override
    public Utils.TimeFormat getTimeFormat() {
        return this.fTimeFormat;
    }

    public void setTimeFormat(Utils.TimeFormat tf) {
        this.fTimeFormat = tf;
        this.fTimeDataProvider = tf == Utils.TimeFormat.CYCLES ? new TimeDataProviderCyclesConverter(this, this.fClockFrequency) : this;
        this.fTimeScaleCtrl.setTimeProvider(this.fTimeDataProvider);
        if (this.fToolTipHandler != null) {
            this.fToolTipHandler.setTimeProvider(this.fTimeDataProvider);
        }
    }

    public void setClockFrequency(long clockFrequency) {
        this.fClockFrequency = clockFrequency;
        if (this.fTimeFormat == Utils.TimeFormat.CYCLES) {
            this.fTimeDataProvider = new TimeDataProviderCyclesConverter(this, this.fClockFrequency);
            this.fTimeScaleCtrl.setTimeProvider(this.fTimeDataProvider);
            if (this.fToolTipHandler != null) {
                this.fToolTipHandler.setTimeProvider(this.fTimeDataProvider);
            }
        }
    }

    public int getBorderWidth() {
        return this.fBorderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        if (borderWidth > -1) {
            this.fBorderWidth = borderWidth;
            GridLayout gl = (GridLayout)this.fDataViewer.getLayout();
            gl.marginHeight = borderWidth;
        }
    }

    public int getHeaderHeight() {
        return this.fTimeScaleHeight;
    }

    public void setHeaderHeight(int headerHeight) {
        if (headerHeight > -1) {
            this.fTimeScaleHeight = headerHeight;
            this.fTimeScaleCtrl.setHeight(headerHeight);
        }
    }

    public int getItemHeight() {
        if (this.fTimeGraphCtrl != null) {
            return this.fTimeGraphCtrl.getItemHeight();
        }
        return 0;
    }

    public void setItemHeight(int rowHeight) {
        if (this.fTimeGraphCtrl != null) {
            this.fTimeGraphCtrl.setItemHeight(rowHeight);
        }
    }

    public void setMinimumItemWidth(int width) {
        if (this.fTimeGraphCtrl != null) {
            this.fTimeGraphCtrl.setMinimumItemWidth(width);
        }
    }

    public void setNameWidthPref(int width) {
        this.fNameWidthPref = width;
        if (width == 0) {
            this.fMinNameWidth = 0;
            this.fNameWidth = 0;
        }
    }

    public int getNameWidthPref(int width) {
        return this.fNameWidthPref;
    }

    public Control getControl() {
        return this.fDataViewer;
    }

    public TimeGraphControl getTimeGraphControl() {
        return this.fTimeGraphCtrl;
    }

    public TimeGraphScale getTimeGraphScale() {
        return this.fTimeScaleCtrl;
    }

    public Composite getTimeAlignedComposite() {
        return this.fTimeAlignedComposite;
    }

    public int getXForTime(long time) {
        return this.fTimeGraphCtrl.getXForTime(time);
    }

    public long getTimeAtX(int x) {
        return this.fTimeGraphCtrl.getTimeAtX(x);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fTimeGraphCtrl;
    }

    public void waitCursor(boolean waitInd) {
        this.fTimeGraphCtrl.waitCursor(waitInd);
    }

    public Slider getHorizontalBar() {
        return this.fHorizontalScrollBar;
    }

    public Slider getVerticalBar() {
        return this.fVerticalScrollBar;
    }

    public void setTopIndex(int index) {
        this.fTimeGraphCtrl.setTopIndex(index);
        this.adjustVerticalScrollBar();
    }

    public int getTopIndex() {
        return this.fTimeGraphCtrl.getTopIndex();
    }

    public void setAutoExpandLevel(int level) {
        this.fTimeGraphCtrl.setAutoExpandLevel(level);
    }

    public int getAutoExpandLevel() {
        return this.fTimeGraphCtrl.getAutoExpandLevel();
    }

    public boolean getExpandedState(ITimeGraphEntry entry) {
        return this.fTimeGraphCtrl.getExpandedState(entry);
    }

    public void setExpandedState(ITimeGraphEntry entry, boolean expanded) {
        this.fTimeGraphCtrl.setExpandedState(entry, expanded);
        this.adjustVerticalScrollBar();
    }

    public void collapseAll() {
        this.fTimeGraphCtrl.collapseAll();
        this.adjustVerticalScrollBar();
    }

    public void expandAll() {
        this.fTimeGraphCtrl.expandAll();
        this.adjustVerticalScrollBar();
    }

    public int getExpandedElementCount() {
        return this.fTimeGraphCtrl.getExpandedElementCount();
    }

    public ITimeGraphEntry[] getExpandedElements() {
        return this.fTimeGraphCtrl.getExpandedElements();
    }

    public void addTreeListener(ITimeGraphTreeListener listener) {
        this.fTimeGraphCtrl.addTreeListener(listener);
    }

    public void removeTreeListener(ITimeGraphTreeListener listener) {
        this.fTimeGraphCtrl.removeTreeListener(listener);
    }

    public Action getResetScaleAction() {
        if (this.fResetScaleAction == null) {
            this.fResetScaleAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.resetStartFinishTime();
                }
            };
            this.fResetScaleAction.setText(Messages.TmfTimeGraphViewer_ResetScaleActionNameText);
            this.fResetScaleAction.setToolTipText(Messages.TmfTimeGraphViewer_ResetScaleActionToolTipText);
            this.fResetScaleAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/home_nav.gif"));
        }
        return this.fResetScaleAction;
    }

    public Action getShowLegendAction() {
        if (this.fShowLegendAction == null) {
            this.fShowLegendAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.showLegend();
                }
            };
            this.fShowLegendAction.setText(Messages.TmfTimeGraphViewer_LegendActionNameText);
            this.fShowLegendAction.setToolTipText(Messages.TmfTimeGraphViewer_LegendActionToolTipText);
            this.fShowLegendAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/show_legend.gif"));
        }
        return this.fShowLegendAction;
    }

    public Action getNextEventAction() {
        if (this.fNextEventAction == null) {
            this.fNextEventAction = new Action(){

                public void runWithEvent(Event event) {
                    boolean extend = (event.stateMask & 0x20000) != 0;
                    TimeGraphViewer.this.selectNextEvent(extend);
                }
            };
            this.fNextEventAction.setText(Messages.TmfTimeGraphViewer_NextEventActionNameText);
            this.fNextEventAction.setToolTipText(Messages.TmfTimeGraphViewer_NextEventActionToolTipText);
            this.fNextEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/next_event.gif"));
        }
        return this.fNextEventAction;
    }

    public Action getPreviousEventAction() {
        if (this.fPrevEventAction == null) {
            this.fPrevEventAction = new Action(){

                public void runWithEvent(Event event) {
                    boolean extend = (event.stateMask & 0x20000) != 0;
                    TimeGraphViewer.this.selectPrevEvent(extend);
                }
            };
            this.fPrevEventAction.setText(Messages.TmfTimeGraphViewer_PreviousEventActionNameText);
            this.fPrevEventAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousEventActionToolTipText);
            this.fPrevEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/prev_event.gif"));
        }
        return this.fPrevEventAction;
    }

    public Action getNextItemAction() {
        if (this.fNextItemAction == null) {
            this.fNextItemAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.selectNextItem();
                }
            };
            this.fNextItemAction.setText(Messages.TmfTimeGraphViewer_NextItemActionNameText);
            this.fNextItemAction.setToolTipText(Messages.TmfTimeGraphViewer_NextItemActionToolTipText);
            this.fNextItemAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/next_menu.gif"));
        }
        return this.fNextItemAction;
    }

    public Action getPreviousItemAction() {
        if (this.fPreviousItemAction == null) {
            this.fPreviousItemAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.selectPrevItem();
                }
            };
            this.fPreviousItemAction.setText(Messages.TmfTimeGraphViewer_PreviousItemActionNameText);
            this.fPreviousItemAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousItemActionToolTipText);
            this.fPreviousItemAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/prev_menu.gif"));
        }
        return this.fPreviousItemAction;
    }

    public Action getZoomInAction() {
        if (this.fZoomInAction == null) {
            this.fZoomInAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.zoomIn();
                }
            };
            this.fZoomInAction.setText(Messages.TmfTimeGraphViewer_ZoomInActionNameText);
            this.fZoomInAction.setToolTipText(Messages.TmfTimeGraphViewer_ZoomInActionToolTipText);
            this.fZoomInAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/zoomin_nav.gif"));
        }
        return this.fZoomInAction;
    }

    public Action getZoomOutAction() {
        if (this.fZoomOutAction == null) {
            this.fZoomOutAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.zoomOut();
                }
            };
            this.fZoomOutAction.setText(Messages.TmfTimeGraphViewer_ZoomOutActionNameText);
            this.fZoomOutAction.setToolTipText(Messages.TmfTimeGraphViewer_ZoomOutActionToolTipText);
            this.fZoomOutAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/zoomout_nav.gif"));
        }
        return this.fZoomOutAction;
    }

    public Action getHideArrowsAction(final IDialogSettings dialogSettings) {
        if (this.fHideArrowsAction == null) {
            this.fHideArrowsAction = new Action(Messages.TmfTimeGraphViewer_HideArrowsActionNameText, 2){

                public void run() {
                    boolean hideArrows = TimeGraphViewer.this.fHideArrowsAction.isChecked();
                    TimeGraphViewer.this.fTimeGraphCtrl.hideArrows(hideArrows);
                    TimeGraphViewer.this.refresh();
                    if (dialogSettings != null) {
                        dialogSettings.put(TimeGraphViewer.HIDE_ARROWS_KEY, hideArrows);
                    }
                    if (TimeGraphViewer.this.fFollowArrowFwdAction != null) {
                        TimeGraphViewer.this.fFollowArrowFwdAction.setEnabled(!hideArrows);
                    }
                    if (TimeGraphViewer.this.fFollowArrowBwdAction != null) {
                        TimeGraphViewer.this.fFollowArrowBwdAction.setEnabled(!hideArrows);
                    }
                }
            };
            this.fHideArrowsAction.setToolTipText(Messages.TmfTimeGraphViewer_HideArrowsActionToolTipText);
            this.fHideArrowsAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/hide_arrows.gif"));
            if (dialogSettings != null) {
                boolean hideArrows = dialogSettings.getBoolean(HIDE_ARROWS_KEY);
                this.fTimeGraphCtrl.hideArrows(hideArrows);
                this.fHideArrowsAction.setChecked(hideArrows);
                if (this.fFollowArrowFwdAction != null) {
                    this.fFollowArrowFwdAction.setEnabled(!hideArrows);
                }
                if (this.fFollowArrowBwdAction != null) {
                    this.fFollowArrowBwdAction.setEnabled(!hideArrows);
                }
            }
        }
        return this.fHideArrowsAction;
    }

    public Action getFollowArrowFwdAction() {
        if (this.fFollowArrowFwdAction == null) {
            this.fFollowArrowFwdAction = new Action(){

                public void runWithEvent(Event event) {
                    boolean extend = (event.stateMask & 0x20000) != 0;
                    TimeGraphViewer.this.fTimeGraphCtrl.followArrowFwd(extend);
                    TimeGraphViewer.this.adjustVerticalScrollBar();
                }
            };
            this.fFollowArrowFwdAction.setText(Messages.TmfTimeGraphViewer_FollowArrowForwardActionNameText);
            this.fFollowArrowFwdAction.setToolTipText(Messages.TmfTimeGraphViewer_FollowArrowForwardActionToolTipText);
            this.fFollowArrowFwdAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/follow_arrow_fwd.gif"));
            if (this.fHideArrowsAction != null) {
                this.fFollowArrowFwdAction.setEnabled(!this.fHideArrowsAction.isChecked());
            }
        }
        return this.fFollowArrowFwdAction;
    }

    public Action getFollowArrowBwdAction() {
        if (this.fFollowArrowBwdAction == null) {
            this.fFollowArrowBwdAction = new Action(){

                public void runWithEvent(Event event) {
                    boolean extend = (event.stateMask & 0x20000) != 0;
                    TimeGraphViewer.this.fTimeGraphCtrl.followArrowBwd(extend);
                    TimeGraphViewer.this.adjustVerticalScrollBar();
                }
            };
            this.fFollowArrowBwdAction.setText(Messages.TmfTimeGraphViewer_FollowArrowBackwardActionNameText);
            this.fFollowArrowBwdAction.setToolTipText(Messages.TmfTimeGraphViewer_FollowArrowBackwardActionToolTipText);
            this.fFollowArrowBwdAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/follow_arrow_bwd.gif"));
            if (this.fHideArrowsAction != null) {
                this.fFollowArrowBwdAction.setEnabled(!this.fHideArrowsAction.isChecked());
            }
        }
        return this.fFollowArrowBwdAction;
    }

    private void adjustHorizontalScrollBar() {
        long time0 = this.getTime0();
        long time1 = this.getTime1();
        long timeMin = this.getMinTime();
        long timeMax = this.getMaxTime();
        long delta = timeMax - timeMin;
        int timePos = 0;
        int thumb = 0x7FFFFFFE;
        if (delta != 0L) {
            thumb = Math.max(1, (int)(2.147483646E9 * ((double)(time1 - time0) / (double)delta)));
            timePos = (int)(2.147483646E9 * ((double)(time0 - timeMin) / (double)delta));
        }
        this.fHorizontalScrollBar.setValues(timePos, 0, 0x7FFFFFFE, thumb, Math.max(1, thumb / 2), Math.max(2, thumb));
    }

    private void adjustVerticalScrollBar() {
        int expandedElementCount;
        int countPerPage;
        int topIndex = this.fTimeGraphCtrl.getTopIndex();
        if (topIndex + (countPerPage = this.fTimeGraphCtrl.countPerPage()) > (expandedElementCount = this.fTimeGraphCtrl.getExpandedElementCount())) {
            this.fTimeGraphCtrl.setTopIndex(Math.max(0, expandedElementCount - countPerPage));
        }
        int selection = this.fTimeGraphCtrl.getTopIndex();
        int min = 0;
        int max = Math.max(1, expandedElementCount - 1);
        int thumb = Math.min(max, Math.max(1, countPerPage - 1));
        int increment = 1;
        int pageIncrement = Math.max(1, countPerPage);
        this.fVerticalScrollBar.setValues(selection, min, max, thumb, increment, pageIncrement);
    }

    public void addTimeGraphEntryMenuListener(MenuDetectListener listener) {
        this.fTimeGraphCtrl.addTimeGraphEntryMenuListener(listener);
    }

    public void removeTimeGraphEntryMenuListener(MenuDetectListener listener) {
        this.fTimeGraphCtrl.removeTimeGraphEntryMenuListener(listener);
    }

    public void addTimeEventMenuListener(MenuDetectListener listener) {
        this.fTimeGraphCtrl.addTimeEventMenuListener(listener);
    }

    public void removeTimeEventMenuListener(MenuDetectListener listener) {
        this.fTimeGraphCtrl.removeTimeEventMenuListener(listener);
    }

    public void addFilter(ViewerFilter filter) {
        this.fTimeGraphCtrl.addFilter(filter);
        this.refresh();
    }

    public void removeFilter(ViewerFilter filter) {
        this.fTimeGraphCtrl.removeFilter(filter);
        this.refresh();
    }

    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        return this.fTimeGraphCtrl.getTimeViewAlignmentInfo();
    }

    public int getAvailableWidth(int requestedOffset) {
        int totalWidth = this.fTimeAlignedComposite.getSize().x;
        return Math.min(totalWidth, Math.max(0, totalWidth - requestedOffset));
    }

    public void performAlign(int offset, int width) {
        this.fTimeGraphCtrl.performAlign(offset);
        int alignmentWidth = width;
        int size = this.fTimeAlignedComposite.getSize().x;
        GridLayout layout = (GridLayout)this.fTimeAlignedComposite.getLayout();
        int marginSize = size - alignmentWidth - offset;
        layout.marginRight = Math.max(0, marginSize);
        this.fTimeAlignedComposite.layout();
    }

    private class ListenerNotifier
    extends Thread {
        private static final long DELAY = 400L;
        private static final long POLLING_INTERVAL = 10L;
        private long fLastUpdateTime = Long.MAX_VALUE;
        private boolean fSelectionChanged = false;
        private boolean fTimeRangeUpdated = false;
        private boolean fTimeSelected = false;

        private ListenerNotifier() {
        }

        @Override
        public void run() {
            while (System.currentTimeMillis() - this.fLastUpdateTime < 400L) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    return;
                }
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TimeGraphViewer.this.fListenerNotifier != ListenerNotifier.this) {
                        return;
                    }
                    TimeGraphViewer.this.fListenerNotifier = null;
                    if (ListenerNotifier.this.isInterrupted() || TimeGraphViewer.this.fDataViewer.isDisposed()) {
                        return;
                    }
                    if (ListenerNotifier.this.fSelectionChanged) {
                        TimeGraphViewer.this.fireSelectionChanged(TimeGraphViewer.this.fSelectedEntry);
                    }
                    if (ListenerNotifier.this.fTimeRangeUpdated) {
                        TimeGraphViewer.this.fireTimeRangeUpdated(TimeGraphViewer.this.fTime0, TimeGraphViewer.this.fTime1);
                    }
                    if (ListenerNotifier.this.fTimeSelected) {
                        TimeGraphViewer.this.fireTimeSelected(TimeGraphViewer.this.fSelectionBegin, TimeGraphViewer.this.fSelectionEnd);
                    }
                }
            });
        }

        public void selectionChanged() {
            this.fSelectionChanged = true;
            this.fLastUpdateTime = System.currentTimeMillis();
        }

        public void timeRangeUpdated() {
            this.fTimeRangeUpdated = true;
            this.fLastUpdateTime = System.currentTimeMillis();
        }

        public void timeSelected() {
            this.fTimeSelected = true;
            this.fLastUpdateTime = System.currentTimeMillis();
        }

        public boolean hasSelectionChanged() {
            return this.fSelectionChanged;
        }

        public boolean hasTimeRangeUpdated() {
            return this.fTimeRangeUpdated;
        }

        public boolean hasTimeSelected() {
            return this.fTimeSelected;
        }
    }
}

