/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredCheckboxTree
extends FilteredTree
implements ICheckable {
    private Set<Object> fObjects = new HashSet<Object>();
    private CheckboxTreeViewer fCheckboxTreeViewer;

    public FilteredCheckboxTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
        super(parent, treeStyle, filter, useNewLook);
    }

    protected TreeViewer doCreateTreeViewer(Composite parentComposite, int style) {
        this.fCheckboxTreeViewer = new CheckboxTreeViewer(parentComposite, style);
        this.fCheckboxTreeViewer.setUseHashlookup(true);
        this.fCheckboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    FilteredCheckboxTree.this.fObjects.add(event.getElement());
                } else {
                    FilteredCheckboxTree.this.fObjects.remove(event.getElement());
                }
            }
        });
        return this.fCheckboxTreeViewer;
    }

    protected WorkbenchJob doCreateRefreshJob() {
        WorkbenchJob job = super.doCreateRefreshJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                FilteredCheckboxTree.this.fCheckboxTreeViewer.expandAll();
                FilteredCheckboxTree.this.fCheckboxTreeViewer.setCheckedElements(FilteredCheckboxTree.this.getCheckedElements());
            }
        });
        return job;
    }

    public boolean getChecked(Object element) {
        return this.fObjects.contains(element);
    }

    public boolean setChecked(Object element, boolean state) {
        boolean checkable = this.fCheckboxTreeViewer.setChecked(element, state);
        if (!state) {
            this.fObjects.remove(element);
        } else if (checkable) {
            this.fObjects.add(element);
        }
        return checkable;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.fCheckboxTreeViewer.addCheckStateListener(listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.fCheckboxTreeViewer.addCheckStateListener(listener);
    }

    public Object[] getCheckedElements() {
        return this.fObjects.toArray();
    }

    public void setCheckedElements(Object[] elements) {
        this.fObjects = new HashSet<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.fObjects.add(element);
            ++n2;
        }
        this.fCheckboxTreeViewer.setCheckedElements(elements);
    }

    public boolean setSubtreeChecked(Object element, boolean state) {
        this.checkSubtree(element, state);
        return this.fCheckboxTreeViewer.setSubtreeChecked(element, state);
    }

    private void checkSubtree(Object element, boolean state) {
        if (!state || this.fCheckboxTreeViewer.testFindItem(element) != null) {
            if (state) {
                this.fObjects.add(element);
            } else {
                this.fObjects.remove(element);
            }
            Object[] objectArray = ((ITreeContentProvider)this.fCheckboxTreeViewer.getContentProvider()).getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.checkSubtree(o, state);
                ++n2;
            }
        }
    }
}

