/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.beans;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.ISynchronizeProcessor;
import org.eclipse.wb.internal.core.databinding.model.ObserveTypeContainer;
import org.eclipse.wb.internal.core.databinding.model.SynchronizeManager;
import org.eclipse.wb.internal.core.databinding.parser.AbstractParser;
import org.eclipse.wb.internal.core.databinding.parser.IModelResolver;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.beans.FieldBeanObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.LocalVariableObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.VirtualObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.components.JavaInfoReferenceProvider;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.BeanPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.ElPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.ObjectPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeansObserveTypeContainer
extends ObserveTypeContainer {
    private static final String OBJECT_PROPERTY_CREATE = "org.jdesktop.beansbinding.ObjectProperty.create()";
    private static final String BEAN_PROPERTY_CREATE_1 = "org.jdesktop.beansbinding.BeanProperty.create(java.lang.String)";
    private static final String BEAN_PROPERTY_CREATE_2 = "org.jdesktop.beansbinding.BeanProperty.create(org.jdesktop.beansbinding.Property,java.lang.String)";
    private static final String EL_PROPERTY_CREATE_1 = "org.jdesktop.beansbinding.ELProperty.create(java.lang.String)";
    private static final String EL_PROPERTY_CREATE_2 = "org.jdesktop.beansbinding.ELProperty.create(org.jdesktop.beansbinding.Property,java.lang.String)";
    private List<IObserveInfo> m_observes = Collections.emptyList();
    private JavaInfo m_javaInfoRoot;

    public BeansObserveTypeContainer() {
        super(ObserveType.BEANS, false, true);
    }

    public List<IObserveInfo> getObservables() {
        return this.m_observes;
    }

    public void synchronizeObserves(JavaInfo root, final AstEditor editor, TypeDeclaration rootNode) throws Exception {
        int observableSize;
        final BeanSupport beanSupport = new BeanSupport();
        IObserveInfo virtualObserve = this.m_observes.remove(0);
        SynchronizeManager.synchronizeObjects(this.m_observes, (List)CoreUtils.getFieldFragments((TypeDeclaration)rootNode), (ISynchronizeProcessor)new ISynchronizeProcessor<VariableDeclarationFragment, IObserveInfo>(){

            public boolean handleObject(IObserveInfo object) {
                return object instanceof FieldBeanObserveInfo;
            }

            public VariableDeclarationFragment getKeyObject(IObserveInfo observe) {
                FieldBeanObserveInfo beanObserve = (FieldBeanObserveInfo)observe;
                return beanObserve.getFragment();
            }

            public boolean equals(VariableDeclarationFragment key0, VariableDeclarationFragment key1) {
                return key0 == key1;
            }

            public IObserveInfo findObject(Map<VariableDeclarationFragment, IObserveInfo> keyObjectToObject, VariableDeclarationFragment key) throws Exception {
                return null;
            }

            public IObserveInfo createObject(VariableDeclarationFragment fragment) throws Exception {
                ITypeBinding binding;
                Type type = (Type)CoreUtils.getType((VariableDeclarationFragment)fragment, (boolean)true);
                if (CoreUtils.isIncludeType((Type)type) && (binding = AstNodeUtils.getTypeBinding((Type)type)) != null) {
                    try {
                        IGenericType beanObjectType = GenericUtils.getObjectType(editor, binding);
                        JavaInfo component = BeansObserveTypeContainer.this.getJavaInfoRepresentedBy(fragment.getName().getIdentifier());
                        return new FieldBeanObserveInfo(beanSupport, fragment, beanObjectType, component);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        AbstractParser.addError((AstEditor)BeansObserveTypeContainer.this.m_javaInfoRoot.getEditor(), (String)("ClassNotFoundException: " + fragment), (Throwable)new Throwable());
                    }
                }
                return null;
            }

            public void update(IObserveInfo object) throws Exception {
            }
        });
        int localVariableIndex = observableSize = this.m_observes.size();
        int i = 0;
        while (i < observableSize) {
            if (this.m_observes.get(i) instanceof LocalVariableObserveInfo) {
                localVariableIndex = i;
                break;
            }
            ++i;
        }
        SynchronizeManager.synchronizeObjects(this.m_observes.subList(localVariableIndex, observableSize), (List)CoreUtils.getLocalFragments((TypeDeclaration)rootNode, (String)"initDataBindings"), (ISynchronizeProcessor)new ISynchronizeProcessor<VariableDeclarationFragment, IObserveInfo>(){

            public boolean handleObject(IObserveInfo object) {
                return true;
            }

            public VariableDeclarationFragment getKeyObject(IObserveInfo observe) {
                LocalVariableObserveInfo beanObserve = (LocalVariableObserveInfo)observe;
                return beanObserve.getFragment();
            }

            public boolean equals(VariableDeclarationFragment fragment0, VariableDeclarationFragment fragment1) {
                return fragment0.getName().getIdentifier().equals(fragment1.getName().getIdentifier());
            }

            public IObserveInfo findObject(Map<VariableDeclarationFragment, IObserveInfo> keyObjectToObject, VariableDeclarationFragment key) throws Exception {
                return null;
            }

            public IObserveInfo createObject(VariableDeclarationFragment fragment) throws Exception {
                try {
                    ITypeBinding binding = (ITypeBinding)CoreUtils.getType((VariableDeclarationFragment)fragment, (boolean)true);
                    IGenericType beanObjectType = GenericUtils.getObjectType(editor, binding);
                    return new LocalVariableObserveInfo(beanSupport, fragment, beanObjectType);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    AbstractParser.addError((AstEditor)BeansObserveTypeContainer.this.m_javaInfoRoot.getEditor(), (String)("ClassNotFoundException: " + fragment), (Throwable)new Throwable());
                    return null;
                }
            }

            public void update(IObserveInfo object) throws Exception {
            }
        });
        this.m_observes.add(0, virtualObserve);
    }

    public void createObservables(JavaInfo root, IModelResolver resolver, AstEditor editor, TypeDeclaration rootNode) throws Exception {
        this.m_javaInfoRoot = root;
        this.m_observes = Lists.newArrayList();
        this.m_observes.add(new VirtualObserveInfo());
        BeanSupport beanSupport = new BeanSupport();
        for (VariableDeclarationFragment fragment : CoreUtils.getFieldFragments((TypeDeclaration)rootNode)) {
            try {
                ITypeBinding binding;
                Type type = (Type)CoreUtils.getType((VariableDeclarationFragment)fragment, (boolean)true);
                if (!CoreUtils.isIncludeType((Type)type) || (binding = AstNodeUtils.getTypeBinding((Type)type)) == null) continue;
                IGenericType beanObjectType = GenericUtils.getObjectType(editor, binding);
                JavaInfo component = this.getJavaInfoRepresentedBy(fragment.getName().getIdentifier());
                this.m_observes.add(new FieldBeanObserveInfo(beanSupport, fragment, beanObjectType, component));
            }
            catch (ClassNotFoundException classNotFoundException) {
                AbstractParser.addError((AstEditor)editor, (String)("ClassNotFoundException: " + fragment), (Throwable)new Throwable());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                AbstractParser.addError((AstEditor)editor, (String)("NoClassDefFoundError: " + fragment), (Throwable)new Throwable());
            }
            catch (Throwable e) {
                throw ReflectionUtils.propagate((Throwable)e);
            }
        }
        for (VariableDeclarationFragment fragment : CoreUtils.getLocalFragments((TypeDeclaration)rootNode, (String)"initDataBindings")) {
            try {
                ITypeBinding binding = (ITypeBinding)CoreUtils.getType((VariableDeclarationFragment)fragment, (boolean)true);
                IGenericType beanObjectType = GenericUtils.getObjectType(editor, binding);
                this.m_observes.add(new LocalVariableObserveInfo(beanSupport, fragment, beanObjectType));
            }
            catch (ClassNotFoundException classNotFoundException) {
                AbstractParser.addError((AstEditor)editor, (String)("ClassNotFoundException: " + fragment), (Throwable)new Throwable());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                AbstractParser.addError((AstEditor)editor, (String)("NoClassDefFoundError: " + fragment), (Throwable)new Throwable());
            }
            catch (Throwable e) {
                throw ReflectionUtils.propagate((Throwable)e);
            }
        }
    }

    public AstObjectInfo parseExpression(AstEditor editor, String signature, ClassInstanceCreation creation, Expression[] arguments, IModelResolver resolver, IDatabindingsProvider provider) throws Exception {
        return null;
    }

    public AstObjectInfo parseExpression(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver) throws Exception {
        if (OBJECT_PROPERTY_CREATE.equals(signature)) {
            IGenericType[] types = GenericUtils.getReturnTypeArguments(editor, invocation, 1);
            return new ObjectPropertyInfo(types[0]);
        }
        if (BEAN_PROPERTY_CREATE_1.equals(signature)) {
            IGenericType[] types = GenericUtils.getReturnTypeArguments(editor, invocation, 2);
            String path = (String)CoreUtils.evaluate(String.class, (AstEditor)editor, (Expression)arguments[0]);
            return new BeanPropertyInfo(types[0], types[1], null, path);
        }
        if (BEAN_PROPERTY_CREATE_2.equals(signature)) {
            IGenericType[] types = GenericUtils.getReturnTypeArguments(editor, invocation, 2);
            PropertyInfo baseProperty = (PropertyInfo)resolver.getModel(arguments[0]);
            if (baseProperty == null) {
                AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.BeansObserveTypeContainer_errArgumentNotFound, arguments[0]), (Throwable)new Throwable());
                return null;
            }
            GenericUtils.assertEquals(baseProperty.getSourceObjectType(), types[0]);
            String path = (String)CoreUtils.evaluate(String.class, (AstEditor)editor, (Expression)arguments[1]);
            return new BeanPropertyInfo(types[0], types[1], baseProperty, path);
        }
        if (EL_PROPERTY_CREATE_1.equals(signature)) {
            IGenericType[] types = GenericUtils.getReturnTypeArguments(editor, invocation, 2);
            String path = (String)CoreUtils.evaluate(String.class, (AstEditor)editor, (Expression)arguments[0]);
            return new ElPropertyInfo(types[0], types[1], null, path);
        }
        if (EL_PROPERTY_CREATE_2.equals(signature)) {
            IGenericType[] types = GenericUtils.getReturnTypeArguments(editor, invocation, 2);
            PropertyInfo baseProperty = (PropertyInfo)resolver.getModel(arguments[0]);
            if (baseProperty == null) {
                AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.BeansObserveTypeContainer_errArgumentNotFound, arguments[0]), (Throwable)new Throwable());
                return null;
            }
            GenericUtils.assertEquals(baseProperty.getSourceObjectType(), types[0]);
            String path = (String)CoreUtils.evaluate(String.class, (AstEditor)editor, (Expression)arguments[1]);
            return new ElPropertyInfo(types[0], types[1], baseProperty, path);
        }
        return null;
    }

    public ObserveInfo resolve(Expression expression) throws Exception {
        String reference = CoreUtils.getNodeReference((ASTNode)expression);
        for (ObserveInfo observe : CoreUtils.cast(this.m_observes)) {
            if (!reference.equals(observe.getReference())) continue;
            return observe;
        }
        return null;
    }

    public ObserveInfo resolve(JavaInfo javaInfo) throws Exception {
        String reference = JavaInfoReferenceProvider.getReference(javaInfo);
        Assert.isNotNull((Object)reference);
        for (ObserveInfo observe : CoreUtils.cast(this.m_observes)) {
            if (!reference.equals(observe.getReference())) continue;
            return observe;
        }
        return null;
    }

    private JavaInfo getJavaInfoRepresentedBy(final String variable) {
        final JavaInfo[] result = new JavaInfo[1];
        this.m_javaInfoRoot.accept(new ObjectInfoVisitor(){

            public boolean visit(ObjectInfo objectInfo) throws Exception {
                JavaInfo javaInfo;
                if (result[0] == null && objectInfo instanceof JavaInfo && variable.equals(JavaInfoReferenceProvider.getReference(javaInfo = (JavaInfo)objectInfo))) {
                    result[0] = javaInfo;
                }
                return result[0] == null;
            }
        });
        return result[0];
    }
}

