/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.eval.IEvaluationContext;
import org.eclipse.wst.jsdt.internal.compiler.util.ObjectVector;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaProjectElementInfo;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SetClasspathOperation;
import org.eclipse.wst.jsdt.internal.core.SourceMapper;
import org.eclipse.wst.jsdt.internal.core.XMLWriter;
import org.eclipse.wst.jsdt.internal.core.util.HandleFactory;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaProject
extends Openable
implements IJavaScriptProject,
IProjectNature,
SuffixConstants {
    public static final IIncludePathEntry[] INVALID_CLASSPATH = new IIncludePathEntry[0];
    protected static final boolean IS_CASE_SENSITIVE = !new File("Temp").equals(new File("temp"));
    protected static final String[] NO_PREREQUISITES = CharOperation.NO_STRINGS;
    private static final String PREF_FILENAME = ".jprefs";
    public static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    public static final String JAVA_CORE_PREFS_FILE = "org.eclipse.wst.jsdt.core.prefs";
    private static final IIncludePathEntry[] RESOLUTION_IN_PROGRESS = new IIncludePathEntry[0];
    public static final String SHARED_PROPERTIES_DIRECTORY = ".settings";
    public static final String CLASSPATH_FILENAME = ".jsdtscope";
    protected IProject project;

    public JavaProject() {
        super(null);
    }

    @Override
    public IFile getJSDTScopeFile() {
        return this.getJSDTScopeFile(false);
    }

    @Override
    public IFile getJSDTScopeFile(boolean forceCreate) {
        IFolder rscPath = this.project.getFolder(".settings");
        if (!rscPath.exists() && forceCreate) {
            try {
                rscPath.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        return rscPath.getFile(CLASSPATH_FILENAME);
    }

    public JavaProject(IProject project, JavaElement parent) {
        super(parent);
        this.project = project;
    }

    public static boolean areClasspathsEqual(IIncludePathEntry[] firstClasspath, IIncludePathEntry[] secondClasspath, IPath firstOutputLocation, IPath secondOutputLocation) {
        int length = firstClasspath.length;
        if (length != secondClasspath.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!firstClasspath[i].equals(secondClasspath[i])) {
                return false;
            }
            ++i;
        }
        if (firstOutputLocation == null) {
            return secondOutputLocation == null;
        }
        return firstOutputLocation.equals((Object)secondOutputLocation);
    }

    private static boolean areClasspathsEqual(IIncludePathEntry[] newClasspath, IPath newOutputLocation, IIncludePathEntry[] otherClasspathWithOutput) {
        if (otherClasspathWithOutput == null || otherClasspathWithOutput.length == 0) {
            return false;
        }
        int length = otherClasspathWithOutput.length;
        if (length != newClasspath.length + 1) {
            return false;
        }
        int i = 0;
        while (i < length - 1) {
            if (!otherClasspathWithOutput[i].equals(newClasspath[i])) {
                return false;
            }
            ++i;
        }
        IIncludePathEntry output = otherClasspathWithOutput[length - 1];
        return output.getContentKind() == 10 && output.getPath().equals((Object)newOutputLocation);
    }

    public static IPath canonicalizedPath(IPath externalPath) {
        Path result;
        if (externalPath == null) {
            return null;
        }
        if (IS_CASE_SENSITIVE) {
            return new Path(new File(externalPath.toOSString()).getPath());
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return externalPath;
        }
        if (workspace.getRoot().findMember(externalPath) != null) {
            return externalPath;
        }
        Path canonicalPath = null;
        try {
            canonicalPath = new Path(new File(externalPath.toOSString()).getCanonicalPath());
        }
        catch (IOException iOException) {
            return externalPath;
        }
        int canonicalLength = canonicalPath.segmentCount();
        if (canonicalLength == 0) {
            return externalPath;
        }
        if (externalPath.isAbsolute()) {
            result = canonicalPath;
        } else {
            int externalLength = externalPath.segmentCount();
            if (canonicalLength >= externalLength) {
                result = canonicalPath.removeFirstSegments(canonicalLength - externalLength);
            } else {
                return externalPath;
            }
        }
        if (externalPath.getDevice() == null) {
            result = result.setDevice(null);
        }
        return result;
    }

    public static boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.wst.jsdt.core.jsNature");
        }
        catch (CoreException coreException) {
            return " ".equals(project.getName());
        }
    }

    public static boolean hasJSDTScope(IProject project) {
        IFile file = project.getFile(CLASSPATH_FILENAME);
        if (file != null && file.exists()) {
            return true;
        }
        IFolder rscPath = project.getFolder(".settings");
        return rscPath.exists() && (file = rscPath.getFile(CLASSPATH_FILENAME)) != null && file.exists();
    }

    /*
     * Unable to fully structure code
     */
    public static void validateCycles(Map preferredClasspaths) throws JavaScriptModelException {
        workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        rscProjects = workspaceRoot.getProjects();
        length = rscProjects.length;
        projects = new JavaProject[length];
        cycleParticipants = new HashSet<E>();
        traversed = new HashSet<E>();
        prereqChain = new ArrayList<E>();
        i = 0;
        while (i < length) {
            if (JavaProject.hasJavaNature(rscProjects[i]) && !traversed.contains((project = (projects[i] = (JavaProject)JavaScriptCore.create(rscProjects[i]))).getPath())) {
                prereqChain.clear();
                project.updateCycleParticipants(prereqChain, cycleParticipants, workspaceRoot, traversed, preferredClasspaths);
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            project = projects[i];
            if (project != null) {
                if (cycleParticipants.contains(project.getPath())) {
                    cycleMarker = project.getCycleMarker();
                    circularCPOption = project.getOption("org.eclipse.wst.jsdt.core.circularClasspath", true);
                    v0 = circularCPSeverity = "error".equals(circularCPOption) != false ? 2 : 1;
                    if (cycleMarker != null) {
                        try {
                            existingSeverity = (Integer)cycleMarker.getAttribute("severity");
                            if (existingSeverity == circularCPSeverity) ** GOTO lbl34
                            cycleMarker.setAttribute("severity", circularCPSeverity);
                        }
                        catch (CoreException e) {
                            throw new JavaScriptModelException(e);
                        }
                    } else {
                        project.createClasspathProblemMarker(new JavaModelStatus(1001, project));
                    }
                } else {
                    project.flushClasspathProblemMarkers(true, false);
                }
            }
lbl34:
            // 6 sources

            ++i;
        }
    }

    public void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        int javaCommandIndex = this.getJavaCommandIndex(description.getBuildSpec(), builderID);
        if (javaCommandIndex == -1) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            this.setJavaCommand(description, command);
        }
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaScriptModelException {
        block2: {
            IIncludePathEntry[] resolvedClasspath = null;
            JavaProject.hasJavaNature((IProject)underlyingResource);
            resolvedClasspath = this.getResolvedClasspath();
            info.setChildren(this.computePackageFragmentRoots(resolvedClasspath, false, null));
            try {
                this.getPerProjectInfo().rememberExternalLibTimestamps();
            }
            catch (JavaScriptModelException e) {
                if (e.getStatus().getCode() == 969) break block2;
                throw e;
            }
        }
        return true;
    }

    private IIncludePathEntry[] getDefaultClasspath() {
        IIncludePathEntry[] defaultClasspath = new IIncludePathEntry[]{JavaScriptCore.newContainerEntry((IPath)new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER")), JavaScriptCore.newContainerEntry((IPath)new Path("org.eclipse.wst.jsdt.launching.baseBrowserLibrary")), JavaScriptCore.newSourceEntry(this.getProject().getFullPath())};
        return defaultClasspath;
    }

    public void computeChildren(JavaProjectElementInfo info) throws JavaScriptModelException {
        IIncludePathEntry[] classpath;
        block3: {
            IPackageFragmentRoot[] newRoots;
            IPackageFragmentRoot[] oldRoots;
            classpath = this.getResolvedClasspath();
            JavaProjectElementInfo.LookupCache projectCache = info.projectCache;
            if (projectCache != null && (oldRoots = projectCache.allPkgFragmentRootsCache).length == (newRoots = this.computePackageFragmentRoots(classpath, true, null)).length) {
                int i = 0;
                int length = oldRoots.length;
                while (i < length) {
                    if (oldRoots[i].equals(newRoots[i])) {
                        ++i;
                        continue;
                    }
                    break block3;
                }
                return;
            }
        }
        info.setNonJavaResources(null);
        info.setChildren(this.computePackageFragmentRoots(classpath, false, null));
    }

    private void computeExpandedClasspath(ClasspathEntry referringEntry, HashSet rootIDs, ObjectVector accumulatedEntries) throws JavaScriptModelException {
        String projectRootId = this.rootID();
        if (rootIDs.contains(projectRootId)) {
            return;
        }
        rootIDs.add(projectRootId);
        IIncludePathEntry[] resolvedClasspath = this.getResolvedClasspath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        boolean isInitialProject = referringEntry == null;
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            String rootID;
            ClasspathEntry entry = (ClasspathEntry)resolvedClasspath[i];
            if ((isInitialProject || entry.isExported()) && !rootIDs.contains(rootID = entry.rootID())) {
                ClasspathEntry combinedEntry = entry.combineWith(referringEntry);
                accumulatedEntries.add(combinedEntry);
                if (entry.getEntryKind() == 2) {
                    IProject projRsc;
                    IResource member = workspaceRoot.findMember(entry.getPath());
                    if (member != null && member.getType() == 4 && JavaProject.hasJavaNature(projRsc = (IProject)member)) {
                        JavaProject javaProject = (JavaProject)JavaScriptCore.create(projRsc);
                        javaProject.computeExpandedClasspath(combinedEntry, rootIDs, accumulatedEntries);
                    }
                } else {
                    rootIDs.add(rootID);
                }
            }
            ++i;
        }
    }

    public IPackageFragmentRoot[] computePackageFragmentRoots(IIncludePathEntry resolvedEntry) {
        try {
            return this.computePackageFragmentRoots(new IIncludePathEntry[]{resolvedEntry}, false, null);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return new IPackageFragmentRoot[0];
        }
    }

    public void computePackageFragmentRoots(IIncludePathEntry resolvedEntry, ObjectVector accumulatedRoots, HashSet rootIDs, IIncludePathEntry referringEntry, boolean checkExistency, boolean retrieveExportedRoots, Map rootToResolvedEntries) throws JavaScriptModelException {
        String rootID = ((ClasspathEntry)resolvedEntry).rootID();
        if (rootIDs.contains(rootID)) {
            return;
        }
        IPath projectPath = this.project.getFullPath();
        IPath entryPath = resolvedEntry.getPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPackageFragmentRoot root = null;
        switch (resolvedEntry.getEntryKind()) {
            case 3: {
                if (!projectPath.isPrefixOf(entryPath)) break;
                if (checkExistency) {
                    Object target = JavaModel.getTarget((IContainer)workspaceRoot, entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (!(target instanceof IFolder) && !(target instanceof IProject)) break;
                    root = this.getPackageFragmentRoot((IResource)target);
                    break;
                }
                root = this.getFolderPackageFragmentRoot(entryPath);
                break;
            }
            case 1: {
                if (referringEntry != null && !resolvedEntry.isExported()) {
                    return;
                }
                if (checkExistency) {
                    Object target = JavaModel.getTarget((IContainer)workspaceRoot, entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (target instanceof IResource) {
                        if (((IResource)target).getType() == 1 && org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(entryPath.lastSegment())) {
                            root = new JarPackageFragmentRoot((IResource)target, this);
                            break;
                        }
                        root = this.getPackageFragmentRoot((IResource)target);
                        break;
                    }
                    if (JavaModel.isFile(target)) {
                        if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(entryPath.lastSegment())) {
                            root = new JarPackageFragmentRoot(entryPath, this);
                            break;
                        }
                        if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isJavaFileName(entryPath.lastSegment())) break;
                        root = new LibraryFragmentRoot(entryPath, this);
                        break;
                    }
                    root = new LibraryFragmentRoot(entryPath, this);
                    break;
                }
                root = this.getPackageFragmentRoot(entryPath);
                break;
            }
            case 2: {
                IProject requiredProjectRsc;
                if (!retrieveExportedRoots) {
                    return;
                }
                if (referringEntry != null && !resolvedEntry.isExported()) {
                    return;
                }
                IResource member = workspaceRoot.findMember(entryPath);
                if (member == null || member.getType() != 4 || !JavaProject.hasJavaNature(requiredProjectRsc = (IProject)member)) break;
                rootIDs.add(rootID);
                JavaProject requiredProject = (JavaProject)JavaScriptCore.create(requiredProjectRsc);
                requiredProject.computePackageFragmentRoots(requiredProject.getResolvedClasspath(), accumulatedRoots, rootIDs, rootToResolvedEntries == null ? resolvedEntry : ((ClasspathEntry)resolvedEntry).combineWith((ClasspathEntry)referringEntry), checkExistency, retrieveExportedRoots, rootToResolvedEntries);
            }
        }
        if (root != null) {
            accumulatedRoots.add(root);
            rootIDs.add(rootID);
            if (rootToResolvedEntries != null) {
                rootToResolvedEntries.put(root, ((ClasspathEntry)resolvedEntry).combineWith((ClasspathEntry)referringEntry));
            }
        }
    }

    public IPackageFragmentRoot[] computePackageFragmentRoots(IIncludePathEntry[] resolvedClasspath, boolean retrieveExportedRoots, Map rootToResolvedEntries) throws JavaScriptModelException {
        ObjectVector accumulatedRoots = new ObjectVector();
        this.computePackageFragmentRoots(resolvedClasspath, accumulatedRoots, new HashSet(5), null, true, retrieveExportedRoots, rootToResolvedEntries);
        Object[] rootArray = new IPackageFragmentRoot[accumulatedRoots.size()];
        accumulatedRoots.copyInto(rootArray);
        return rootArray;
    }

    public void computePackageFragmentRoots(IIncludePathEntry[] resolvedClasspath, ObjectVector accumulatedRoots, HashSet rootIDs, IIncludePathEntry referringEntry, boolean checkExistency, boolean retrieveExportedRoots, Map rootToResolvedEntries) throws JavaScriptModelException {
        if (referringEntry == null) {
            rootIDs.add(this.rootID());
        }
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            this.computePackageFragmentRoots(resolvedClasspath[i], accumulatedRoots, rootIDs, referringEntry, checkExistency, retrieveExportedRoots, rootToResolvedEntries);
            ++i;
        }
    }

    public String computeSharedPropertyFileName(QualifiedName qName) {
        return String.valueOf('.') + qName.getLocalName();
    }

    public void configure() throws CoreException {
        this.addToBuildSpec("org.eclipse.wst.jsdt.core.javascriptValidator");
    }

    public boolean contains(IResource resource) {
        IPath output;
        IIncludePathEntry[] classpath;
        try {
            classpath = this.getResolvedClasspath();
            output = this.getOutputLocation();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
        IPath fullPath = resource.getFullPath();
        IPath innerMostOutput = output.isPrefixOf(fullPath) ? output : null;
        IIncludePathEntry innerMostEntry = null;
        int j = 0;
        int cpLength = classpath.length;
        while (j < cpLength) {
            IIncludePathEntry entry = classpath[j];
            IPath entryPath = entry.getPath();
            if ((innerMostEntry == null || innerMostEntry.getPath().isPrefixOf(entryPath)) && entryPath.isPrefixOf(fullPath)) {
                innerMostEntry = entry;
            }
            ++j;
        }
        if (innerMostEntry != null) {
            if (innerMostOutput != null && innerMostOutput.segmentCount() > 1 && innerMostEntry.getPath().segmentCount() == 1) {
                return false;
            }
            if (resource instanceof IFolder) {
                return true;
            }
            return true;
        }
        return innerMostOutput == null;
    }

    public void createClasspathProblemMarker(IJavaScriptModelStatus status) {
        block8: {
            int severity;
            IMarker marker = null;
            String[] arguments = CharOperation.NO_STRINGS;
            boolean isCycleProblem = false;
            boolean isClasspathFileFormatProblem = false;
            switch (status.getCode()) {
                case 1001: {
                    isCycleProblem = true;
                    if ("error".equals(this.getOption("org.eclipse.wst.jsdt.core.circularClasspath", true))) {
                        severity = 2;
                        break;
                    }
                    severity = 1;
                    break;
                }
                case 1000: {
                    isClasspathFileFormatProblem = true;
                    severity = 2;
                    break;
                }
                default: {
                    IPath path = status.getPath();
                    if (path != null) {
                        arguments = new String[]{path.toString()};
                    }
                    severity = "error".equals(this.getOption("org.eclipse.wst.jsdt.core.incompleteClasspath", true)) && status.getSeverity() != 2 ? 2 : 1;
                }
            }
            try {
                marker = this.project.createMarker("org.eclipse.wst.jsdt.core.buildpath_problem");
                marker.setAttributes(new String[]{"message", "severity", "location", "cycleDetected", "classpathFileFormat", "id", "arguments", "categoryId", "sourceId"}, new Object[]{status.getMessage(), severity, Messages.classpath_buildPath, isCycleProblem ? "true" : "false", isClasspathFileFormatProblem ? "true" : "false", status.getCode(), Util.getProblemArgumentsForMarker(arguments), 10, "JSDT"});
            }
            catch (CoreException e) {
                if (!JavaModelManager.VERBOSE) break block8;
                e.printStackTrace();
            }
        }
    }

    @Override
    protected Object createElementInfo() {
        return new JavaProjectElementInfo();
    }

    public IIncludePathEntry[] decodeClasspath(String xmlClasspath, Map unknownElements) throws IOException, AssertionFailedException {
        Element cpElement;
        ArrayList<IIncludePathEntry> paths = new ArrayList<IIncludePathEntry>();
        IIncludePathEntry defaultOutput = null;
        StringReader reader = new StringReader(xmlClasspath);
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new IOException(Messages.file_badFormat);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IOException(Messages.file_badFormat);
            }
        }
        finally {
            reader.close();
        }
        if (!cpElement.getNodeName().equalsIgnoreCase("classpath")) {
            throw new IOException(Messages.file_badFormat);
        }
        NodeList list = cpElement.getElementsByTagName("classpathentry");
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            IIncludePathEntry entry;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (entry = ClasspathEntry.elementDecode((Element)node, this, unknownElements)) != null) {
                if (entry.getContentKind() == 10) {
                    defaultOutput = entry;
                } else {
                    paths.add(entry);
                }
            }
            ++i;
        }
        int pathSize = paths.size();
        IIncludePathEntry[] entries = new IIncludePathEntry[pathSize + (defaultOutput == null ? 0 : 1)];
        paths.toArray(entries);
        if (defaultOutput != null) {
            entries[pathSize] = defaultOutput;
        }
        return entries;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public IIncludePathEntry decodeIncludepathEntry(String encodedEntry) {
        try {
            Element node;
            if (encodedEntry == null) {
                return null;
            }
            StringReader reader = new StringReader(encodedEntry);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    node = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (SAXException sAXException) {
                    reader.close();
                    return null;
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    reader.close();
                    return null;
                }
            }
            finally {
                reader.close();
            }
            if (!node.getNodeName().equalsIgnoreCase("classpathentry") || node.getNodeType() != 1) {
                return null;
            }
            return ClasspathEntry.elementDecode(node, this, null);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("org.eclipse.wst.jsdt.core.javascriptValidator");
    }

    protected IIncludePathEntry[] defaultClasspath() {
        return this.getDefaultClasspath();
    }

    protected IPath defaultOutputLocation() {
        return this.project.getFullPath();
    }

    protected String encodeClasspath(IIncludePathEntry[] classpath, IPath outputLocation, boolean indent, Map unknownElements) throws JavaScriptModelException {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, this, true);
            xmlWriter.startTag("classpath", indent);
            int i = 0;
            while (i < classpath.length) {
                ((ClasspathEntry)classpath[i]).elementEncode(xmlWriter, this.project.getFullPath(), indent, true, unknownElements);
                ++i;
            }
            if (outputLocation != null) {
                outputLocation = outputLocation.removeFirstSegments(1);
                outputLocation = outputLocation.makeRelative();
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("kind", ClasspathEntry.kindToString(10));
                parameters.put("path", String.valueOf(outputLocation));
                xmlWriter.printTag("classpathentry", parameters, indent, true, true);
            }
            xmlWriter.endTag("classpath", indent, true);
            writer.flush();
            writer.close();
            return s.toString("UTF8");
        }
        catch (IOException e) {
            throw new JavaScriptModelException(e, 985);
        }
    }

    @Override
    public String encodeIncludepathEntry(IIncludePathEntry classpathEntry) {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, this, false);
            ((ClasspathEntry)classpathEntry).elementEncode(xmlWriter, this.project.getFullPath(), true, true, null);
            writer.flush();
            writer.close();
            return s.toString("UTF8");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaProject)) {
            return false;
        }
        JavaProject other = (JavaProject)o;
        return this.project.equals((Object)other.getProject());
    }

    @Override
    public boolean exists() {
        try {
            return this.project.hasNature("org.eclipse.wst.jsdt.core.jsNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public IJavaScriptElement findElement(IPath path) throws JavaScriptModelException {
        return this.findElement(path, DefaultWorkingCopyOwner.PRIMARY);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public IJavaScriptElement findElement(IPath path, WorkingCopyOwner owner) throws JavaScriptModelException {
        if (path == null || path.isAbsolute()) {
            throw new JavaScriptModelException(new JavaModelStatus(979, path));
        }
        try {
            String extension = path.getFileExtension();
            if (extension == null) {
                String packageName = path.toString().replace('/', '.');
                NameLookup lookup = this.newNameLookup((WorkingCopyOwner)null);
                IPackageFragment[] pkgFragments = lookup.findPackageFragments(packageName, false);
                if (pkgFragments == null) {
                    return null;
                }
                int i = 0;
                int length = pkgFragments.length;
                while (i < length) {
                    IPackageFragment pkgFragment = pkgFragments[i];
                    if (this.equals(pkgFragment.getParent().getParent())) {
                        return pkgFragment;
                    }
                    ++i;
                }
                return pkgFragments[0];
            }
            if (Util.isJavaLikeFileName(path.lastSegment())) {
                IPath packagePath = path.removeLastSegments(1);
                String packageName = packagePath.toString().replace('/', '.');
                String typeName = path.lastSegment();
                typeName = typeName.substring(0, typeName.length() - extension.length() - 1);
                String qualifiedName = null;
                qualifiedName = packageName.length() > 0 ? String.valueOf(packageName) + "." + typeName : typeName;
                NameLookup lookup = this.newNameLookup(owner);
                ITypeRoot cu = lookup.findCompilationUnit(qualifiedName);
                if (cu != null) {
                    return cu;
                }
                NameLookup.Answer answer = lookup.findType(qualifiedName, false, 30, true, false, false, null);
                if (answer != null) {
                    return answer.type.getParent();
                }
                return null;
            }
            return null;
        }
        catch (JavaScriptModelException e) {
            if (e.getStatus().getCode() == 969) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public IPackageFragment findPackageFragment(IPath path) throws JavaScriptModelException {
        return this.findPackageFragment0(JavaProject.canonicalizedPath(path));
    }

    private IPackageFragment findPackageFragment0(IPath path) throws JavaScriptModelException {
        NameLookup lookup = this.newNameLookup((WorkingCopyOwner)null);
        return lookup.findPackageFragment(path);
    }

    @Override
    public IPackageFragmentRoot findPackageFragmentRoot(IPath path) throws JavaScriptModelException {
        return this.findPackageFragmentRoot0(JavaProject.canonicalizedPath(path));
    }

    public IPackageFragmentRoot findPackageFragmentRoot0(IPath path) throws JavaScriptModelException {
        IPackageFragmentRoot[] allRoots = this.getAllPackageFragmentRoots();
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Messages.path_mustBeAbsolute);
        }
        int i = 0;
        while (i < allRoots.length) {
            IPackageFragmentRoot classpathRoot = allRoots[i];
            if (classpathRoot.getPath().equals((Object)path)) {
                return classpathRoot;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IPackageFragmentRoot[] findPackageFragmentRoots(IIncludePathEntry entry) {
        try {
            IIncludePathEntry[] classpath = this.getRawIncludepath();
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                if (classpath[i].equals(entry)) {
                    return this.computePackageFragmentRoots(this.resolveClasspath(new IIncludePathEntry[]{entry}), false, null);
                }
                ++i;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return new IPackageFragmentRoot[0];
    }

    @Override
    public IType findType(String fullyQualifiedName) throws JavaScriptModelException {
        return this.findType(fullyQualifiedName, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IType[] findTypes(String fullyQualifiedName) throws JavaScriptModelException {
        return this.findTypes(fullyQualifiedName, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IType findType(String fullyQualifiedName, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        return this.findType(fullyQualifiedName, DefaultWorkingCopyOwner.PRIMARY, progressMonitor);
    }

    IType findType(String fullyQualifiedName, NameLookup lookup, boolean considerSecondaryTypes, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        Object[] elements;
        NameLookup.Answer answer = lookup.findType(fullyQualifiedName, false, 30, considerSecondaryTypes, true, false, progressMonitor);
        if (answer == null) {
            int lastDot = fullyQualifiedName.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            IType type = this.findType(fullyQualifiedName.substring(0, lastDot), lookup, considerSecondaryTypes, progressMonitor);
            if (type != null && !(type = type.getType(fullyQualifiedName.substring(lastDot + 1))).exists()) {
                return null;
            }
            return type;
        }
        if (answer.type == null && answer.element instanceof ITypeRoot) {
            answer.type = ((ITypeRoot)answer.element).getType(fullyQualifiedName);
        } else if (answer.type == null && answer.element != null && answer.element.getClass().isArray() && (elements = (Object[])answer.element)[0] instanceof ITypeRoot) {
            answer.type = ((ITypeRoot)elements[0]).getType(fullyQualifiedName);
        }
        return answer.type;
    }

    IType[] findTypes(String fullyQualifiedName, NameLookup lookup, boolean considerSecondaryTypes, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        NameLookup.Answer answer = lookup.findType(fullyQualifiedName, false, 30, considerSecondaryTypes, true, false, progressMonitor);
        if (answer == null) {
            int lastDot = fullyQualifiedName.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            IType type = this.findType(fullyQualifiedName.substring(0, lastDot), lookup, considerSecondaryTypes, progressMonitor);
            if (type != null && (type = type.getType(fullyQualifiedName.substring(lastDot + 1))) != null && type.exists()) {
                return new IType[]{type};
            }
            return new IType[0];
        }
        if (answer.type == null && answer.element instanceof ITypeRoot) {
            answer.type = ((ITypeRoot)answer.element).getType(fullyQualifiedName);
        } else if (answer.type == null && answer.element != null && answer.element.getClass().isArray()) {
            Object[] elements = (Object[])answer.element;
            ArrayList<IType> iTypes = new ArrayList<IType>(elements.length);
            int i = 0;
            while (i < elements.length) {
                IType rootType;
                if (elements[i] instanceof ITypeRoot && (rootType = ((ITypeRoot)elements[i]).getType(fullyQualifiedName)) != null && rootType.exists()) {
                    iTypes.add(rootType);
                }
                ++i;
            }
            return iTypes.toArray(new IType[iTypes.size()]);
        }
        if (answer.type != null && answer.type.exists()) {
            return new IType[]{answer.type};
        }
        return new IType[0];
    }

    @Override
    public IType findType(String packageName, String typeQualifiedName) throws JavaScriptModelException {
        return this.findType(packageName, typeQualifiedName, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IType findType(String packageName, String typeQualifiedName, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        return this.findType(packageName, typeQualifiedName, DefaultWorkingCopyOwner.PRIMARY, progressMonitor);
    }

    IType findType(String packageName, String typeQualifiedName, NameLookup lookup, boolean considerSecondaryTypes, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        NameLookup.Answer answer = lookup.findType(typeQualifiedName, packageName, false, 30, considerSecondaryTypes, true, false, progressMonitor);
        return answer == null ? null : answer.type;
    }

    @Override
    public IType findType(String packageName, String typeQualifiedName, WorkingCopyOwner owner) throws JavaScriptModelException {
        NameLookup lookup = this.newNameLookup(owner);
        return this.findType(packageName, typeQualifiedName, lookup, false, null);
    }

    @Override
    public IType findType(String packageName, String typeQualifiedName, WorkingCopyOwner owner, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        NameLookup lookup = this.newNameLookup(owner);
        return this.findType(packageName, typeQualifiedName, lookup, true, progressMonitor);
    }

    @Override
    public IType findType(String fullyQualifiedName, WorkingCopyOwner owner) throws JavaScriptModelException {
        NameLookup lookup = this.newNameLookup(owner);
        return this.findType(fullyQualifiedName, lookup, false, null);
    }

    @Override
    public IType[] findTypes(String fullyQualifiedName, WorkingCopyOwner owner) throws JavaScriptModelException {
        NameLookup lookup = this.newNameLookup(owner);
        return this.findTypes(fullyQualifiedName, lookup, false, null);
    }

    @Override
    public IType findType(String fullyQualifiedName, WorkingCopyOwner owner, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        NameLookup lookup = this.newNameLookup(owner);
        return this.findType(fullyQualifiedName, lookup, true, progressMonitor);
    }

    protected void flushClasspathProblemMarkers(boolean flushCycleMarkers, boolean flushClasspathFormatMarkers) {
        block7: {
            try {
                if (this.project.isAccessible()) {
                    IMarker[] markers = this.project.findMarkers("org.eclipse.wst.jsdt.core.buildpath_problem", false, 0);
                    int i = 0;
                    int length = markers.length;
                    while (i < length) {
                        IMarker marker = markers[i];
                        if (flushCycleMarkers && flushClasspathFormatMarkers) {
                            marker.delete();
                        } else {
                            String cycleAttr = (String)marker.getAttribute("cycleDetected");
                            String classpathFileFormatAttr = (String)marker.getAttribute("classpathFileFormat");
                            if (flushCycleMarkers == (cycleAttr != null && cycleAttr.equals("true")) && flushClasspathFormatMarkers == (classpathFileFormatAttr != null && classpathFileFormatAttr.equals("true"))) {
                                marker.delete();
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                if (!JavaModelManager.VERBOSE) break block7;
                e.printStackTrace();
            }
        }
    }

    public IPath[] getAccessRestrictions(String optionName) {
        String sequence = this.getOption(optionName, true);
        if (sequence == null || sequence.length() == 0) {
            return null;
        }
        IPath[] rules = null;
        char[][] patterns = CharOperation.splitOn('|', sequence.toCharArray());
        int patternCount = patterns.length;
        if (patternCount > 0) {
            rules = new IPath[patternCount];
            int j = 0;
            while (j < patterns.length) {
                rules[j] = new Path(new String(patterns[j]));
                ++j;
            }
        }
        return rules;
    }

    @Override
    public IPackageFragmentRoot[] getAllPackageFragmentRoots() throws JavaScriptModelException {
        return this.getAllPackageFragmentRoots(null);
    }

    public IPackageFragmentRoot[] getAllPackageFragmentRoots(Map rootToResolvedEntries) throws JavaScriptModelException {
        return this.computePackageFragmentRoots(this.getResolvedClasspath(), true, rootToResolvedEntries);
    }

    public IIncludePathEntry getClasspathEntryFor(IPath path) throws JavaScriptModelException {
        this.getResolvedClasspath();
        JavaModelManager.PerProjectInfo perProjectInfo = this.getPerProjectInfo();
        if (perProjectInfo == null) {
            return null;
        }
        Map rootPathToResolvedEntries = perProjectInfo.rootPathToResolvedEntries;
        if (rootPathToResolvedEntries == null) {
            return null;
        }
        return (IIncludePathEntry)rootPathToResolvedEntries.get(path);
    }

    public IMarker getCycleMarker() {
        try {
            if (this.project.isAccessible()) {
                IMarker[] markers = this.project.findMarkers("org.eclipse.wst.jsdt.core.buildpath_problem", false, 0);
                int i = 0;
                int length = markers.length;
                while (i < length) {
                    IMarker marker = markers[i];
                    String cycleAttr = (String)marker.getAttribute("cycleDetected");
                    if (cycleAttr != null && cycleAttr.equals("true")) {
                        return marker;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public IEclipsePreferences getEclipsePreferences() {
        if (!JavaProject.hasJavaNature(this.project)) {
            return null;
        }
        JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfo(this.project, true);
        if (perProjectInfo.preferences != null) {
            return perProjectInfo.preferences;
        }
        ProjectScope context = new ProjectScope(this.getProject());
        final IEclipsePreferences eclipsePreferences = context.getNode("org.eclipse.wst.jsdt.core");
        this.updatePreferences(eclipsePreferences);
        perProjectInfo.preferences = eclipsePreferences;
        IEclipsePreferences.INodeChangeListener nodeListener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == eclipsePreferences) {
                    JavaModelManager.getJavaModelManager().resetProjectPreferences(JavaProject.this);
                }
            }
        };
        ((IEclipsePreferences)eclipsePreferences.parent()).addNodeChangeListener(nodeListener);
        IEclipsePreferences.IPreferenceChangeListener preferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                String propertyName = event.getKey();
                JavaModelManager manager = JavaModelManager.getJavaModelManager();
                if (propertyName.startsWith("org.eclipse.wst.jsdt.core")) {
                    if (propertyName.equals("org.eclipse.wst.jsdt.core.builder.cleanOutputFolder") || propertyName.equals("org.eclipse.wst.jsdt.core.builder.resourceCopyExclusionFilter") || propertyName.equals("org.eclipse.wst.jsdt.core.builder.duplicateResourceTask") || propertyName.equals("org.eclipse.wst.jsdt.core.builder.recreateModifiedClassFileInOutputFolder") || propertyName.equals("org.eclipse.wst.jsdt.core.builder.invalidClasspath") || propertyName.equals("org.eclipse.wst.jsdt.core.classpath.exclusionPatterns") || propertyName.equals("org.eclipse.wst.jsdt.core.classpath.multipleOutputLocations") || propertyName.equals("org.eclipse.wst.jsdt.core.incompleteClasspath") || propertyName.equals("org.eclipse.wst.jsdt.core.circularClasspath") || propertyName.equals("org.eclipse.wst.jsdt.core.incompatibleJDKLevel")) {
                        manager.deltaState.addClasspathValidation(JavaProject.this);
                    }
                    manager.resetProjectOptions(JavaProject.this);
                }
            }
        };
        eclipsePreferences.addPreferenceChangeListener(preferenceListener);
        return eclipsePreferences;
    }

    @Override
    public String getElementName() {
        return this.project.getName();
    }

    @Override
    public int getElementType() {
        return 2;
    }

    public IIncludePathEntry[] getExpandedClasspath() throws JavaScriptModelException {
        ObjectVector accumulatedEntries = new ObjectVector();
        this.computeExpandedClasspath(null, new HashSet(5), accumulatedEntries);
        Object[] expandedPath = new IIncludePathEntry[accumulatedEntries.size()];
        accumulatedEntries.copyInto(expandedPath);
        return expandedPath;
    }

    public IPackageFragmentRoot getFolderPackageFragmentRoot(IPath path) {
        if (path.segmentCount() == 1) {
            return this.getPackageFragmentRoot((IResource)this.project);
        }
        return this.getPackageFragmentRoot((IResource)this.project.getWorkspace().getRoot().getFolder(path));
    }

    @Override
    public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '/': {
                StringBuilder rootPath = new StringBuilder("");
                token = null;
                while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    char firstChar = token.charAt(0);
                    if (firstChar == '<' || firstChar == '!') break;
                    rootPath.append(token);
                }
                JavaElement root = (JavaElement)((Object)this.getPackageFragmentRoot((IPath)new Path(rootPath.toString())));
                if (token != null && token.charAt(0) == '<') {
                    return root.getHandleFromMemento(token, memento, owner);
                }
                return root.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '=';
    }

    private int getJavaCommandIndex(ICommand[] buildSpec, String builder_ID) {
        int i = 0;
        while (i < buildSpec.length) {
            if (buildSpec[i].getBuilderName().equals(builder_ID)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected JavaProjectElementInfo getJavaProjectElementInfo() throws JavaScriptModelException {
        return (JavaProjectElementInfo)this.getElementInfo();
    }

    @Override
    public Object[] getNonJavaScriptResources() throws JavaScriptModelException {
        return ((JavaProjectElementInfo)this.getElementInfo()).getNonJavaResources(this);
    }

    @Override
    public String getOption(String optionName, boolean inheritJavaCoreOptions) {
        String propertyName = optionName;
        if (JavaModelManager.getJavaModelManager().optionNames.contains(propertyName)) {
            String javaCoreDefault;
            IEclipsePreferences projectPreferences = this.getEclipsePreferences();
            String string = javaCoreDefault = inheritJavaCoreOptions ? JavaScriptCore.getOption(propertyName) : null;
            if (projectPreferences == null) {
                return javaCoreDefault;
            }
            String value = projectPreferences.get(propertyName, javaCoreDefault);
            return value == null ? null : value.trim();
        }
        return null;
    }

    @Override
    public Map getOptions(boolean inheritJavaCoreOptions) {
        Hashtable options = inheritJavaCoreOptions ? JavaScriptCore.getOptions() : new Hashtable(5);
        JavaModelManager.PerProjectInfo perProjectInfo = null;
        Hashtable<String, String> projectOptions = null;
        HashSet optionNames = JavaModelManager.getJavaModelManager().optionNames;
        try {
            perProjectInfo = this.getPerProjectInfo();
            projectOptions = perProjectInfo.options;
            if (projectOptions == null) {
                IEclipsePreferences projectPreferences = this.getEclipsePreferences();
                if (projectPreferences == null) {
                    return options;
                }
                String[] propertyNames = projectPreferences.keys();
                projectOptions = new Hashtable(propertyNames.length);
                int i = 0;
                while (i < propertyNames.length) {
                    String propertyName = propertyNames[i];
                    String value = projectPreferences.get(propertyName, null);
                    if (value != null && optionNames.contains(propertyName)) {
                        projectOptions.put(propertyName, value.trim());
                    }
                    ++i;
                }
                perProjectInfo.options = projectOptions;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            projectOptions = new Hashtable<String, String>();
        }
        catch (BackingStoreException backingStoreException) {
            projectOptions = new Hashtable();
        }
        if (inheritJavaCoreOptions) {
            for (Map.Entry entry : projectOptions.entrySet()) {
                String propertyName = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if (propertyValue == null || !optionNames.contains(propertyName)) continue;
                options.put(propertyName, propertyValue.trim());
            }
            return options;
        }
        return projectOptions;
    }

    public IPath getOutputLocation() throws JavaScriptModelException {
        JavaModelManager.PerProjectInfo perProjectInfo = this.getPerProjectInfo();
        IPath outputLocation = perProjectInfo.outputLocation;
        if (outputLocation != null) {
            return outputLocation;
        }
        this.getRawIncludepath();
        outputLocation = perProjectInfo.outputLocation;
        if (outputLocation == null) {
            return this.defaultOutputLocation();
        }
        return outputLocation;
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IPath path) {
        if (!path.isAbsolute()) {
            path = this.getPath().append(path);
        }
        int segmentCount = path.segmentCount();
        String lastSegment = path.lastSegment();
        switch (segmentCount) {
            case 0: {
                return null;
            }
            case 1: {
                if (!path.equals((Object)this.getPath())) break;
                return this.getPackageFragmentRoot((IResource)this.project);
            }
        }
        if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(lastSegment) || org.eclipse.wst.jsdt.internal.compiler.util.Util.isJavaFileName(lastSegment)) {
            IResource resource = this.project.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.getType() == 2) {
                return this.getPackageFragmentRoot(resource);
            }
            return this.getPackageFragmentRoot0(path);
        }
        if (segmentCount == 1) {
            return this.getPackageFragmentRoot((IResource)this.project.getWorkspace().getRoot().getProject(lastSegment));
        }
        IFolder folder = this.project.getWorkspace().getRoot().getFolder(path);
        if (folder != null && folder.exists()) {
            return this.getPackageFragmentRoot((IResource)folder);
        }
        return this.getPackageFragmentRoot0(path);
    }

    @Override
    public IPackageFragmentRoot getPackageFragmentRoot(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(resource.getName())) {
                    return new JarPackageFragmentRoot(resource, this);
                }
                return null;
            }
            case 2: {
                return new PackageFragmentRoot(resource, this);
            }
            case 4: {
                return new PackageFragmentRoot(resource, this);
            }
        }
        return null;
    }

    @Override
    public IPackageFragmentRoot getPackageFragmentRoot(String jarPath) {
        return this.getPackageFragmentRoot0(JavaProject.canonicalizedPath((IPath)new Path(jarPath)));
    }

    public IPackageFragmentRoot getPackageFragmentRoot0(IPath jarPath) {
        if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(jarPath.lastSegment())) {
            return new JarPackageFragmentRoot(jarPath, this);
        }
        return new LibraryFragmentRoot(jarPath, this);
    }

    @Override
    public IPackageFragmentRoot[] getPackageFragmentRoots() throws JavaScriptModelException {
        IJavaScriptElement[] children = this.getChildren();
        int length = children.length;
        IPackageFragmentRoot[] roots = new IPackageFragmentRoot[length];
        System.arraycopy(children, 0, roots, 0, length);
        return roots;
    }

    @Override
    public IPackageFragment[] getPackageFragments() throws JavaScriptModelException {
        IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
        return this.getPackageFragmentsInRoots(roots);
    }

    public IPackageFragment[] getPackageFragmentsInRoots(IPackageFragmentRoot[] roots) {
        ArrayList<IJavaScriptElement> frags = new ArrayList<IJavaScriptElement>();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            try {
                IJavaScriptElement[] rootFragments = root.getChildren();
                int j = 0;
                while (j < rootFragments.length) {
                    frags.add(rootFragments[j]);
                    ++j;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            ++i;
        }
        IPackageFragment[] fragments = new IPackageFragment[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    @Override
    public IPath getPath() {
        return this.project.getFullPath();
    }

    public JavaModelManager.PerProjectInfo getPerProjectInfo() throws JavaScriptModelException {
        return JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.project);
    }

    private IPath getPluginWorkingLocation() {
        return this.project.getWorkingLocation("org.eclipse.wst.jsdt.core");
    }

    public Preferences getPreferences() {
        return new Preferences();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public JavaProjectElementInfo.LookupCache getProjectCache() throws JavaScriptModelException {
        return ((JavaProjectElementInfo)this.getElementInfo()).getProjectCache(this);
    }

    @Override
    public IIncludePathEntry[] getRawIncludepath() throws JavaScriptModelException {
        JavaModelManager.PerProjectInfo perProjectInfo = this.getPerProjectInfo();
        IIncludePathEntry[] classpath = perProjectInfo.rawClasspath;
        if (classpath != null) {
            return classpath;
        }
        classpath = perProjectInfo.readAndCacheClasspath(this);
        if (classpath == INVALID_CLASSPATH) {
            return this.defaultClasspath();
        }
        return classpath;
    }

    @Override
    public String[] getRequiredProjectNames() throws JavaScriptModelException {
        return this.projectPrerequisites(this.getResolvedClasspath());
    }

    public IIncludePathEntry[] getResolvedClasspath() throws JavaScriptModelException {
        try {
            JavaModelManager.PerProjectInfo perProjectInfo = this.getPerProjectInfo();
            if (perProjectInfo.resolvedClasspath == null) {
                this.resolveClasspath(perProjectInfo);
            }
            return perProjectInfo.resolvedClasspath;
        }
        catch (JavaScriptModelException e) {
            if (e.getStatus().getCode() == 969) {
                IIncludePathEntry[] defaultClasspath = this.defaultClasspath();
                return this.resolveClasspath(defaultClasspath);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIncludePathEntry[] getResolvedIncludepath(boolean ignoreUnresolvedEntry) throws JavaScriptModelException {
        IJavaScriptModelStatus unresolvedEntryStatus;
        IIncludePathEntry[] resolvedClasspath;
        JavaModelManager.PerProjectInfo perProjectInfo;
        if (JavaModelManager.getJavaModelManager().isClasspathBeingResolved(this)) {
            if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED) {
                this.verbose_reentering_classpath_resolution();
            }
            return RESOLUTION_IN_PROGRESS;
        }
        JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo = this.getPerProjectInfo();
        synchronized (perProjectInfo2) {
            resolvedClasspath = perProjectInfo.resolvedClasspath;
            unresolvedEntryStatus = perProjectInfo.unresolvedEntryStatus;
        }
        if (resolvedClasspath == null || unresolvedEntryStatus != null && !unresolvedEntryStatus.isOK()) {
            this.resolveClasspath(perProjectInfo);
            perProjectInfo2 = perProjectInfo;
            synchronized (perProjectInfo2) {
                resolvedClasspath = perProjectInfo.resolvedClasspath;
                unresolvedEntryStatus = perProjectInfo.unresolvedEntryStatus;
            }
        }
        if (!ignoreUnresolvedEntry && unresolvedEntryStatus != null && !unresolvedEntryStatus.isOK()) {
            throw new JavaScriptModelException(unresolvedEntryStatus);
        }
        return resolvedClasspath;
    }

    private void verbose_reentering_classpath_resolution() {
        Util.verbose("CPResolution: reentering raw classpath resolution, will use empty classpath instead\tproject: " + this.getElementName() + '\n' + "\tinvocation stack trace:");
        new Exception("<Fake exception>").printStackTrace(System.out);
    }

    @Override
    public IResource getResource() {
        return this.project;
    }

    public String getSharedProperty(String key) throws CoreException {
        IFile rscFile = this.project.getFile(key);
        String property = null;
        if (rscFile.exists()) {
            byte[] bytes = Util.getResourceContentsAsByteArray(rscFile);
            try {
                property = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Util.log(e, "Could not read .jsdtscope with UTF-8 encoding");
                property = new String(bytes);
            }
        } else {
            File file;
            URI location = rscFile.getLocationURI();
            if (location != null && (file = Util.toLocalFile(location, null)) != null && file.exists()) {
                byte[] bytes;
                try {
                    bytes = org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileByteContent(file);
                }
                catch (IOException iOException) {
                    return null;
                }
                try {
                    property = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Util.log(e, "Could not read .jsdtscope with UTF-8 encoding");
                    property = new String(bytes);
                }
            }
        }
        return property;
    }

    @Override
    public SourceMapper getSourceMapper() {
        return null;
    }

    @Override
    public IResource getUnderlyingResource() throws JavaScriptModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.project;
    }

    @Override
    public boolean hasBuildState() {
        return JavaModelManager.getJavaModelManager().getLastBuiltState(this.project, null) != null;
    }

    @Override
    public boolean hasIncludepathCycle(IIncludePathEntry[] preferredClasspath) {
        HashSet cycleParticipants = new HashSet();
        HashMap<JavaProject, IIncludePathEntry[]> preferredClasspaths = new HashMap<JavaProject, IIncludePathEntry[]>(1);
        preferredClasspaths.put(this, preferredClasspath);
        this.updateCycleParticipants(new ArrayList(2), cycleParticipants, ResourcesPlugin.getWorkspace().getRoot(), new HashSet(2), preferredClasspaths);
        return !cycleParticipants.isEmpty();
    }

    public boolean hasCycleMarker() {
        return this.getCycleMarker() != null;
    }

    @Override
    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean hasSource() {
        IIncludePathEntry[] entries;
        try {
            entries = this.getRawIncludepath();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return true;
        }
        int i = 0;
        int max = entries.length;
        while (i < max) {
            if (entries[i].getEntryKind() == 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isOnIncludepath(IJavaScriptElement element) {
        IIncludePathEntry[] rawClasspath;
        try {
            rawClasspath = this.getRawIncludepath();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
        int elementType = element.getElementType();
        boolean isPackageFragmentRoot = false;
        boolean isFolderPath = false;
        boolean isSource = false;
        switch (elementType) {
            case 1: {
                return false;
            }
            case 2: {
                break;
            }
            case 3: {
                isPackageFragmentRoot = true;
                break;
            }
            case 4: {
                isFolderPath = !((IPackageFragmentRoot)element.getParent()).isArchive();
                break;
            }
            case 5: {
                isSource = true;
                break;
            }
            default: {
                isSource = element.getAncestor(5) != null;
            }
        }
        IPath elementPath = element.getPath();
        int length = rawClasspath.length;
        int i = 0;
        while (i < length) {
            IIncludePathEntry entry = rawClasspath[i];
            switch (entry.getEntryKind()) {
                case 1: 
                case 2: 
                case 3: {
                    if (!this.isOnClasspathEntry(elementPath, isFolderPath, isPackageFragmentRoot, entry)) break;
                    return true;
                }
            }
            ++i;
        }
        if (isSource) {
            return false;
        }
        i = 0;
        while (i < length) {
            IIncludePathEntry rawEntry = rawClasspath[i];
            switch (rawEntry.getEntryKind()) {
                case 5: {
                    IIncludePathEntry[] containerEntries;
                    IJsGlobalScopeContainer container;
                    try {
                        container = JavaScriptCore.getJsGlobalScopeContainer(rawEntry.getPath(), this);
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        break;
                    }
                    if (container == null || (containerEntries = container.getIncludepathEntries()) == null) break;
                    int j = 0;
                    int containerLength = containerEntries.length;
                    while (j < containerLength) {
                        IIncludePathEntry resolvedEntry = containerEntries[j];
                        if (resolvedEntry == null) {
                            if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                                JavaModelManager.getJavaModelManager().verbose_missbehaving_container(this, rawEntry.getPath(), containerEntries);
                            }
                            return false;
                        }
                        if (this.isOnClasspathEntry(elementPath, isFolderPath, isPackageFragmentRoot, resolvedEntry)) {
                            return true;
                        }
                        ++j;
                    }
                    break;
                }
                case 4: {
                    IIncludePathEntry resolvedEntry = JavaScriptCore.getResolvedIncludepathEntry(rawEntry);
                    if (resolvedEntry == null || !this.isOnClasspathEntry(elementPath, isFolderPath, isPackageFragmentRoot, resolvedEntry)) break;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isOnIncludepath(IResource resource) {
        IIncludePathEntry[] classpath;
        IPath exactPath = resource.getLocation();
        IPath path = resource.getFullPath();
        int resourceType = resource.getType();
        boolean isFolderPath = resourceType == 2 || resourceType == 4;
        try {
            classpath = this.getResolvedClasspath();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            IIncludePathEntry entry = classpath[i];
            IPath entryPath = entry.getPath();
            if (entryPath.equals((Object)exactPath) || entryPath.equals((Object)exactPath)) {
                return true;
            }
            if (entryPath.isPrefixOf(path) && !Util.isExcluded(path, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), isFolderPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isOnClasspathEntry(IPath elementPath, boolean isFolderPath, boolean isPackageFragmentRoot, IIncludePathEntry entry) {
        IPath entryPath = entry.getPath();
        return isPackageFragmentRoot ? entryPath.equals((Object)elementPath) : entryPath.isPrefixOf(elementPath) && !Util.isExcluded(elementPath, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), isFolderPath);
    }

    public Preferences loadPreferences() {
        File prefFile;
        Preferences preferences = new Preferences();
        IPath projectMetaLocation = this.getPluginWorkingLocation();
        if (projectMetaLocation != null && (prefFile = projectMetaLocation.append(PREF_FILENAME).toFile()).exists()) {
            block15: {
                InputStream in = null;
                try {
                    try {
                        in = new BufferedInputStream(new FileInputStream(prefFile));
                        preferences.load(in);
                    }
                    catch (IOException iOException) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            prefFile.delete();
            return preferences;
        }
        return null;
    }

    @Override
    public IEvaluationContext newEvaluationContext() {
        return null;
    }

    @Override
    public NameLookup newNameLookup(IJavaScriptUnit[] workingCopies) throws JavaScriptModelException {
        return this.getJavaProjectElementInfo().newNameLookup(this, workingCopies);
    }

    @Override
    public NameLookup newNameLookup(WorkingCopyOwner owner) throws JavaScriptModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        IJavaScriptUnit[] workingCopies = owner == null ? null : manager.getWorkingCopies(owner, true);
        return this.newNameLookup(workingCopies);
    }

    @Override
    public SearchableEnvironment newSearchableNameEnvironment(IJavaScriptUnit[] workingCopies) throws JavaScriptModelException {
        return new SearchableEnvironment(this, workingCopies);
    }

    @Override
    public SearchableEnvironment newSearchableNameEnvironment(WorkingCopyOwner owner) throws JavaScriptModelException {
        return new SearchableEnvironment(this, owner);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IRegion region, IProgressMonitor monitor) throws JavaScriptModelException {
        return this.newTypeHierarchy(region, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IRegion region, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        if (region == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullRegion);
        }
        IJavaScriptUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation(region, workingCopies, null, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IType type, IRegion region, IProgressMonitor monitor) throws JavaScriptModelException {
        return this.newTypeHierarchy(type, region, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IType type, IRegion region, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        if (type == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullFocusType);
        }
        if (region == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullRegion);
        }
        IJavaScriptUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation(region, workingCopies, type, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public String[] projectPrerequisites(IIncludePathEntry[] entries) throws JavaScriptModelException {
        ArrayList<String> prerequisites = new ArrayList<String>();
        entries = this.resolveClasspath(entries);
        int i = 0;
        int length = entries.length;
        while (i < length) {
            IIncludePathEntry entry = entries[i];
            if (entry.getEntryKind() == 2) {
                prerequisites.add(entry.getPath().lastSegment());
            }
            ++i;
        }
        int size = prerequisites.size();
        if (size == 0) {
            return NO_PREREQUISITES;
        }
        String[] result = new String[size];
        prerequisites.toArray(result);
        return result;
    }

    public IIncludePathEntry[] readFileEntriesWithException(Map unknownElements) throws CoreException, IOException, AssertionFailedException {
        String xmlClasspath;
        IFile rscFile = this.getJSDTScopeFile();
        if (rscFile.exists()) {
            byte[] bytes = Util.getResourceContentsAsByteArray(rscFile);
            try {
                xmlClasspath = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Util.log(e, "Could not read .jsdtscope with UTF-8 encoding");
                xmlClasspath = new String(bytes);
            }
        } else {
            byte[] bytes;
            URI location = rscFile.getLocationURI();
            if (location == null) {
                throw new IOException("Cannot obtain a location URI for " + rscFile);
            }
            File file = Util.toLocalFile(location, null);
            if (file == null) {
                throw new IOException("Unable to fetch file from " + location);
            }
            try {
                bytes = org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileByteContent(file);
            }
            catch (IOException e) {
                if (!file.exists()) {
                    return this.defaultClasspath();
                }
                throw e;
            }
            try {
                xmlClasspath = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Util.log(e, "Could not read .jsdtscope with UTF-8 encoding");
                xmlClasspath = new String(bytes);
            }
        }
        return this.decodeClasspath(xmlClasspath, unknownElements);
    }

    private IIncludePathEntry[] readFileEntries(Map unkwownElements) {
        try {
            return this.readFileEntriesWithException(unkwownElements);
        }
        catch (CoreException e) {
            Util.log(e, "Exception while reading " + this.getPath().append(CLASSPATH_FILENAME));
            return INVALID_CLASSPATH;
        }
        catch (IOException e) {
            Util.log(e, "Exception while reading " + this.getPath().append(CLASSPATH_FILENAME));
            return INVALID_CLASSPATH;
        }
        catch (AssertionFailedException e) {
            Util.log(e, "Exception while reading " + this.getPath().append(CLASSPATH_FILENAME));
            return INVALID_CLASSPATH;
        }
    }

    public IPath readOutputLocation() {
        IIncludePathEntry entry;
        IIncludePathEntry[] classpath = this.readFileEntries(null);
        if (classpath == INVALID_CLASSPATH) {
            return this.defaultOutputLocation();
        }
        IPath outputLocation = null;
        if (classpath.length > 0 && (entry = classpath[classpath.length - 1]).getContentKind() == 10) {
            outputLocation = entry.getPath();
        }
        return outputLocation;
    }

    @Override
    public IIncludePathEntry[] readRawIncludepath() {
        IIncludePathEntry entry;
        IIncludePathEntry[] classpath = this.readFileEntries(null);
        if (classpath == INVALID_CLASSPATH) {
            return this.defaultClasspath();
        }
        if (classpath.length > 0 && (entry = classpath[classpath.length - 1]).getContentKind() == 10) {
            IIncludePathEntry[] copy = new IIncludePathEntry[classpath.length - 1];
            System.arraycopy(classpath, 0, copy, 0, copy.length);
            classpath = copy;
        }
        return classpath;
    }

    public void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public void resetCaches() {
        JavaProjectElementInfo info = (JavaProjectElementInfo)JavaModelManager.getJavaModelManager().peekAtInfo(this);
        if (info != null) {
            info.resetCaches();
        }
    }

    public IIncludePathEntry[] resolveClasspath(IIncludePathEntry[] rawClasspath) throws JavaScriptModelException {
        ArrayList<IIncludePathEntry> resolvedEntries = new ArrayList<IIncludePathEntry>();
        int i = 0;
        int length = rawClasspath.length;
        while (i < length) {
            IIncludePathEntry rawEntry = rawClasspath[i];
            block1 : switch (rawEntry.getEntryKind()) {
                case 4: {
                    IIncludePathEntry resolvedEntry = null;
                    try {
                        resolvedEntry = JavaScriptCore.getResolvedIncludepathEntry(rawEntry);
                    }
                    catch (AssertionFailedException assertionFailedException) {
                        break;
                    }
                    if (resolvedEntry == null) break;
                    resolvedEntries.add(resolvedEntry);
                    break;
                }
                case 5: {
                    IIncludePathEntry[] containerEntries;
                    IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer(rawEntry.getPath(), this);
                    if (container == null || (containerEntries = container.getIncludepathEntries()) == null) break;
                    int j = 0;
                    int containerLength = containerEntries.length;
                    while (j < containerLength) {
                        ClasspathEntry cEntry = (ClasspathEntry)containerEntries[j];
                        if (cEntry == null) {
                            if (!JavaModelManager.CP_RESOLVE_VERBOSE) break block1;
                            JavaModelManager.getJavaModelManager().verbose_missbehaving_container(this, rawEntry.getPath(), containerEntries);
                            break block1;
                        }
                        cEntry = cEntry.combineWith((ClasspathEntry)rawEntry);
                        resolvedEntries.add(cEntry);
                        ++j;
                    }
                    break;
                }
                default: {
                    resolvedEntries.add(rawEntry);
                }
            }
            ++i;
        }
        IIncludePathEntry[] result = new IIncludePathEntry[resolvedEntries.size()];
        resolvedEntries.toArray(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveClasspath(JavaModelManager.PerProjectInfo perProjectInfo) throws JavaScriptModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            IJavaScriptModelStatus rawClasspathStatus;
            IPath outputLocation;
            IIncludePathEntry[] rawClasspath;
            manager.setClasspathBeingResolved(this, true);
            JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo;
            synchronized (perProjectInfo2) {
                rawClasspath = perProjectInfo.rawClasspath;
                if (rawClasspath == null) {
                    rawClasspath = perProjectInfo.readAndCacheClasspath(this);
                }
                outputLocation = perProjectInfo.outputLocation;
                rawClasspathStatus = perProjectInfo.rawClasspathStatus;
            }
            IJavaScriptModelStatus unresolvedEntryStatus = JavaModelStatus.VERIFIED_OK;
            HashMap<IPath, IIncludePathEntry> rawReverseMap = new HashMap<IPath, IIncludePathEntry>();
            HashMap<IPath, IIncludePathEntry> rootPathToResolvedEntries = new HashMap<IPath, IIncludePathEntry>();
            ArrayList<IIncludePathEntry> resolvedEntries = new ArrayList<IIncludePathEntry>();
            int length = rawClasspath.length;
            int i = 0;
            while (i < length) {
                IIncludePathEntry rawEntry = rawClasspath[i];
                block4 : switch (rawEntry.getEntryKind()) {
                    case 4: {
                        IIncludePathEntry resolvedEntry = null;
                        try {
                            resolvedEntry = JavaScriptCore.getResolvedIncludepathEntry(rawEntry);
                        }
                        catch (AssertionFailedException e) {
                            unresolvedEntryStatus = new JavaModelStatus(979, e.getMessage());
                            break;
                        }
                        if (resolvedEntry == null) {
                            unresolvedEntryStatus = new JavaModelStatus(965, (IJavaScriptElement)this, rawEntry.getPath());
                            break;
                        }
                        IPath resolvedPath = resolvedEntry.getPath();
                        if (rawReverseMap.get(resolvedPath) == null) {
                            rawReverseMap.put(resolvedPath, rawEntry);
                            rootPathToResolvedEntries.put(resolvedPath, resolvedEntry);
                        }
                        resolvedEntries.add(resolvedEntry);
                        break;
                    }
                    case 5: {
                        IPath resolvedPath;
                        IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer(rawEntry.getPath(), this);
                        if (container == null) {
                            unresolvedEntryStatus = new JavaModelStatus(963, (IJavaScriptElement)this, rawEntry.getPath());
                            break;
                        }
                        IIncludePathEntry[] containerEntries = container.getIncludepathEntries();
                        if (containerEntries == null) break;
                        int j = 0;
                        int containerLength = containerEntries.length;
                        while (j < containerLength) {
                            ClasspathEntry cEntry = (ClasspathEntry)containerEntries[j];
                            if (cEntry == null) {
                                if (!JavaModelManager.CP_RESOLVE_VERBOSE) break block4;
                                JavaModelManager.getJavaModelManager().verbose_missbehaving_container(this, rawEntry.getPath(), containerEntries);
                                break block4;
                            }
                            resolvedPath = (cEntry = cEntry.combineWith((ClasspathEntry)rawEntry)).getPath();
                            if (rawReverseMap.get(resolvedPath) == null) {
                                rawReverseMap.put(resolvedPath, rawEntry);
                                rootPathToResolvedEntries.put(resolvedPath, cEntry);
                            }
                            resolvedEntries.add(cEntry);
                            ++j;
                        }
                        break;
                    }
                    default: {
                        IPath resolvedPath = rawEntry.getPath();
                        if (rawReverseMap.get(resolvedPath) == null) {
                            rawReverseMap.put(resolvedPath, rawEntry);
                            rootPathToResolvedEntries.put(resolvedPath, rawEntry);
                        }
                        resolvedEntries.add(rawEntry);
                    }
                }
                ++i;
            }
            IIncludePathEntry[] resolvedClasspath = new IIncludePathEntry[resolvedEntries.size()];
            resolvedEntries.toArray(resolvedClasspath);
            perProjectInfo.setClasspath(rawClasspath, outputLocation, rawClasspathStatus, resolvedClasspath, rawReverseMap, rootPathToResolvedEntries, unresolvedEntryStatus);
        }
        finally {
            manager.setClasspathBeingResolved(this, false);
        }
    }

    public String rootID() {
        return "[PRJ]" + this.project.getFullPath();
    }

    public boolean saveClasspath(IIncludePathEntry[] newClasspath, IPath newOutputLocation) throws JavaScriptModelException {
        if (!this.project.isAccessible()) {
            return false;
        }
        HashMap unknownElements = new HashMap();
        IIncludePathEntry[] fileEntries = this.readFileEntries(unknownElements);
        if (fileEntries != INVALID_CLASSPATH && JavaProject.areClasspathsEqual(newClasspath, newOutputLocation, fileEntries)) {
            return false;
        }
        try {
            this.setSharedProperty(this.getJSDTScopeFile(true).getProjectRelativePath().toString(), this.encodeClasspath(newClasspath, newOutputLocation, true, unknownElements));
            return true;
        }
        catch (CoreException e) {
            throw new JavaScriptModelException(e);
        }
    }

    private void setJavaCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldBuildSpec = description.getBuildSpec();
        int oldJavaCommandIndex = this.getJavaCommandIndex(oldBuildSpec, newCommand.getBuilderName());
        if (oldJavaCommandIndex == -1) {
            newCommands = new ICommand[oldBuildSpec.length + 1];
            System.arraycopy(oldBuildSpec, 0, newCommands, 1, oldBuildSpec.length);
            newCommands[0] = newCommand;
        } else {
            oldBuildSpec[oldJavaCommandIndex] = newCommand;
            newCommands = oldBuildSpec;
        }
        description.setBuildSpec(newCommands);
        this.project.setDescription(description, null);
    }

    @Override
    public void setOption(String optionName, String optionValue) {
        if (!JavaModelManager.getJavaModelManager().optionNames.contains(optionName)) {
            return;
        }
        if (optionValue == null) {
            return;
        }
        IEclipsePreferences projectPreferences = this.getEclipsePreferences();
        String defaultValue = JavaScriptCore.getOption(optionName);
        if (optionValue.equals(defaultValue)) {
            projectPreferences.remove(optionName);
        } else {
            projectPreferences.put(optionName, optionValue);
        }
        try {
            projectPreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    @Override
    public void setOptions(Map newOptions) {
        IEclipsePreferences projectPreferences = this.getEclipsePreferences();
        try {
            if (newOptions == null) {
                projectPreferences.clear();
            } else {
                for (Map.Entry entry : newOptions.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!JavaModelManager.getJavaModelManager().optionNames.contains(key)) continue;
                    projectPreferences.put(key, (String)entry.getValue());
                }
                String[] pNames = projectPreferences.keys();
                int ln = pNames.length;
                int i = 0;
                while (i < ln) {
                    String key = pNames[i];
                    if (!newOptions.containsKey(key)) {
                        projectPreferences.remove(key);
                    }
                    ++i;
                }
            }
            projectPreferences.flush();
            try {
                this.getPerProjectInfo().options = null;
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void setOutputLocation(IPath path, IProgressMonitor monitor) throws JavaScriptModelException {
        if (path == null) {
            throw new IllegalArgumentException(Messages.path_nullPath);
        }
        if (path.equals((Object)this.getOutputLocation())) {
            return;
        }
        this.setRawIncludepath(this.getRawIncludepath(), path, monitor);
    }

    public void setProject(IProject project) {
        this.project = project;
        this.parent = JavaModelManager.getJavaModelManager().getJavaModel();
        this.getJSDTScopeFile(true);
    }

    @Override
    public void setRawIncludepath(IIncludePathEntry[] entries, boolean canModifyResources, IProgressMonitor monitor) throws JavaScriptModelException {
        this.setRawIncludepath(entries, this.getOutputLocation(), canModifyResources, monitor);
    }

    public void setRawIncludepath(IIncludePathEntry[] newRawClasspath, IPath newOutputLocation, boolean canModifyResources, IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            if (newRawClasspath == null) {
                newRawClasspath = this.defaultClasspath();
            }
            SetClasspathOperation op = new SetClasspathOperation(this, newRawClasspath, newOutputLocation, canModifyResources);
            op.runOperation(monitor);
        }
        catch (JavaScriptModelException e) {
            JavaModelManager.getJavaModelManager().getDeltaProcessor().flush();
            throw e;
        }
    }

    public void setRawIncludepath(IIncludePathEntry[] entries, IPath outputLocation, IProgressMonitor monitor) throws JavaScriptModelException {
        this.setRawIncludepath(entries, outputLocation, true, monitor);
    }

    @Override
    public void setRawIncludepath(IIncludePathEntry[] entries, IProgressMonitor monitor) throws JavaScriptModelException {
        this.setRawIncludepath(entries, this.getOutputLocation(), true, monitor);
    }

    public void setSharedProperty(String key, String value) throws CoreException {
        IFile rscFile = this.project.getFile(key);
        byte[] bytes = null;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Util.log(e, "Could not write .jsdtscope with UTF-8 encoding ");
            bytes = value.getBytes();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        if (rscFile.exists()) {
            if (rscFile.isReadOnly()) {
                ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{rscFile}, null);
            }
            rscFile.setContents((InputStream)inputStream, 1, null);
        } else {
            rscFile.create((InputStream)inputStream, 1, null);
        }
    }

    public void updateCycleParticipants(ArrayList prereqChain, HashSet cycleParticipants, IWorkspaceRoot workspaceRoot, HashSet traversed, Map preferredClasspaths) {
        IPath path = this.getPath();
        prereqChain.add(path);
        traversed.add(path);
        try {
            IIncludePathEntry[] classpath = null;
            if (preferredClasspaths != null) {
                classpath = (IIncludePathEntry[])preferredClasspaths.get(this);
            }
            if (classpath == null) {
                classpath = this.getResolvedClasspath();
            }
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                IIncludePathEntry entry = classpath[i];
                if (entry.getEntryKind() == 2) {
                    IResource member;
                    int index;
                    IPath prereqProjectPath = entry.getPath();
                    int n = index = cycleParticipants.contains(prereqProjectPath) ? 0 : prereqChain.indexOf(prereqProjectPath);
                    if (index >= 0) {
                        int size = prereqChain.size();
                        while (index < size) {
                            cycleParticipants.add(prereqChain.get(index));
                            ++index;
                        }
                    } else if (!traversed.contains(prereqProjectPath) && (member = workspaceRoot.findMember(prereqProjectPath)) != null && member.getType() == 4) {
                        JavaProject javaProject = (JavaProject)JavaScriptCore.create((IProject)member);
                        javaProject.updateCycleParticipants(prereqChain, cycleParticipants, workspaceRoot, traversed, preferredClasspaths);
                    }
                }
                ++i;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        prereqChain.remove(path);
    }

    public void updatePackageFragmentRoots() {
        if (this.isOpen()) {
            try {
                JavaProjectElementInfo info = this.getJavaProjectElementInfo();
                this.computeChildren(info);
                info.resetCaches();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                try {
                    this.close();
                }
                catch (JavaScriptModelException javaScriptModelException2) {}
            }
        }
    }

    private void updatePreferences(IEclipsePreferences preferences) {
        Preferences oldPreferences = this.loadPreferences();
        if (oldPreferences != null) {
            String[] propertyNames = oldPreferences.propertyNames();
            int i = 0;
            while (i < propertyNames.length) {
                String propertyName = propertyNames[i];
                String propertyValue = oldPreferences.getString(propertyName);
                if (!"".equals(propertyValue)) {
                    preferences.put(propertyName, propertyValue);
                }
                ++i;
            }
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    @Override
    public LibrarySuperType getCommonSuperType() {
        String superTypeName = null;
        String superTypeContainer = null;
        try {
            Path fullPath = new Path(".settings");
            superTypeName = this.getSharedProperty(fullPath.append("org.eclipse.wst.jsdt.ui.superType.name").toString());
            superTypeContainer = this.getSharedProperty(fullPath.append("org.eclipse.wst.jsdt.ui.superType.container").toString());
        }
        catch (CoreException coreException) {}
        if (superTypeContainer == null || superTypeName == null) {
            return null;
        }
        return new LibrarySuperType((IPath)new Path(superTypeContainer), (IJavaScriptProject)this, superTypeName);
    }

    public void setCommonSuperType(LibrarySuperType newSuperType) {
        String superTypeName = newSuperType.getSuperTypeName();
        String superTypeContainer = newSuperType.getRawContainerPath().toString();
        try {
            IFolder rscPath = this.project.getFolder(".settings");
            if (!rscPath.exists()) {
                rscPath.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            Path fullPath = new Path(".settings");
            this.setSharedProperty(fullPath.append("org.eclipse.wst.jsdt.ui.superType.name").toString(), superTypeName);
            this.setSharedProperty(fullPath.append("org.eclipse.wst.jsdt.ui.superType.container").toString(), superTypeContainer);
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public ITypeRoot findTypeRoot(String fullyQualifiedName) throws JavaScriptModelException {
        HandleFactory handleFactory = new HandleFactory();
        Openable openable = handleFactory.createOpenable(fullyQualifiedName, null);
        if (openable instanceof ITypeRoot) {
            return (ITypeRoot)((Object)openable);
        }
        return null;
    }
}

