/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.discovery.Discovery;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ProgressUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeComposite;
import org.eclipse.wst.server.ui.internal.viewers.DefaultViewerSorter;
import org.eclipse.wst.server.ui.internal.viewers.ServerTypeTreeContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.ServerTypeTreeLabelProvider;

public class ServerTypeComposite
extends AbstractTreeComposite {
    protected IServerType selection;
    protected ServerTypeSelectionListener listener;
    protected boolean initialSelection = true;
    protected IModuleType moduleType;
    protected String serverTypeId;
    protected boolean isLocalhost;
    protected boolean includeIncompatibleVersions;

    public ServerTypeComposite(Composite parent, IModuleType moduleType, String serverTypeId, ServerTypeSelectionListener listener2) {
        super(parent);
        this.listener = listener2;
        this.moduleType = moduleType;
        this.serverTypeId = serverTypeId;
        this.contentProvider = new ServerTypeTreeContentProvider(moduleType, serverTypeId);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        ServerTypeTreeLabelProvider labelProvider = new ServerTypeTreeLabelProvider();
        labelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] obj = event.getElements();
                if (obj == null) {
                    ServerTypeComposite.this.treeViewer.refresh(true);
                } else {
                    obj = ServerUIPlugin.adaptLabelChangeObjects(obj);
                    int size = obj.length;
                    int i = 0;
                    while (i < size) {
                        ServerTypeComposite.this.treeViewer.refresh(obj[i], true);
                        ++i;
                    }
                }
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setInput((Object)"root");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ServerTypeComposite.this.getSelection(event.getSelection());
                if (obj instanceof IServerType) {
                    ServerTypeComposite.this.handleTreeSelectionChange((IServerType)obj);
                }
            }
        });
        this.treeViewer.setSorter((ViewerSorter)new DefaultViewerSorter());
    }

    public void handleTreeSelectionChange(IServerType serverSelection) {
        if (serverSelection != null) {
            this.selection = serverSelection;
            this.setDescription(this.selection.getDescription());
        } else {
            this.selection = null;
            this.setDescription("");
        }
        this.listener.serverTypeSelected(this.selection);
    }

    public void setSelection(IServerType server) {
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)server), true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.initialSelection) {
            this.initialSelection = false;
            this.deferInitialization();
        }
    }

    public boolean setHost(boolean newHost) {
        if (this.isLocalhost == newHost) {
            return false;
        }
        this.isLocalhost = newHost;
        ISelection sel = this.treeViewer.getSelection();
        ((ServerTypeTreeContentProvider)this.contentProvider).setLocalhost(this.isLocalhost);
        this.treeViewer.refresh();
        this.treeViewer.setSelection(sel, true);
        return true;
    }

    public void setIncludeIncompatibleVersions(boolean b) {
        this.includeIncompatibleVersions = b;
        ISelection sel = this.treeViewer.getSelection();
        ((ServerTypeTreeContentProvider)this.contentProvider).setIncludeIncompatibleVersions(b);
        this.treeViewer.refresh();
        this.treeViewer.setSelection(sel, true);
    }

    protected String getDescriptionLabel() {
        return null;
    }

    protected String getTitleLabel() {
        return Messages.serverTypeCompLabel;
    }

    public IServerType getSelectedServerType() {
        return this.selection;
    }

    public void refresh() {
        ISelection sel = this.treeViewer.getSelection();
        this.treeViewer.setContentProvider((IContentProvider)new ServerTypeTreeContentProvider(this.moduleType, this.serverTypeId));
        this.treeViewer.setSelection(sel);
    }

    protected String getDetailsLabel() {
        return Messages.installableServerLink;
    }

    protected boolean getDetailsLink() {
        return true;
    }

    private void closeWizard(Composite comp) {
        if (comp == null || comp.isDisposed()) {
            return;
        }
        Composite c = comp.getParent();
        if (c instanceof Shell) {
            Shell s = (Shell)c;
            s.close();
        }
        this.closeWizard(c);
    }

    protected void detailsSelected() {
        if (Discovery.launchExtensionWizard((Shell)this.getShell(), (String)Messages.wizNewInstallableServerTitle, (String)Messages.wizNewInstallableServerDescription)) {
            this.closeWizard(this);
        }
    }

    protected void refreshServerNode() {
        class RefreshJob
        extends Job {
            public RefreshJob() {
                super(Messages.jobRefreshingServerAdapter);
            }

            public boolean belongsTo(Object family) {
                return "org.eclipse.wst.server.ui.family".equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                monitor = ProgressUtil.getMonitorFor(monitor);
                monitor.beginTask("", 1000);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        ((RefreshJob)this).ServerTypeComposite.this.contentProvider.fillTree();
                        ServerTypeComposite.this.refresh("root");
                        if (((RefreshJob)this).ServerTypeComposite.this.contentProvider.getInitialSelection() != null && !((RefreshJob)this).ServerTypeComposite.this.treeViewer.getTree().isDisposed()) {
                            ((RefreshJob)this).ServerTypeComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection(((RefreshJob)this).ServerTypeComposite.this.contentProvider.getInitialSelection()), true);
                        }
                    }
                });
                monitor.worked(200);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Discovery.refreshServerAdapters((IProgressMonitor)ProgressUtil.getSubMonitorFor(monitor, 500));
                monitor.worked(700);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ServerCore.resetDownloadableServers();
                final IProgressMonitor finalMonitor = monitor;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (ServerUIPlugin.getPreferences().getExtAdapter()) {
                            ServerTypeComposite.this.handleShowAdapters(ProgressUtil.getSubMonitorFor(finalMonitor, 200));
                        }
                    }
                });
                monitor.worked(900);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        ServerTypeComposite.this.enableRefresh();
                    }
                });
                return Status.OK_STATUS;
            }
        }
        RefreshJob job = new RefreshJob();
        job.setUser(true);
        job.schedule();
        job.setPriority(20);
    }

    public static interface ServerTypeSelectionListener {
        public void serverTypeSelected(IServerType var1);
    }
}

