/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.releng;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.xtext.ui.util.FeatureProjectFactory;
import org.eclipse.xtext.ui.util.IProjectFactoryContributor;
import org.eclipse.xtext.ui.wizard.AbstractProjectCreator;
import org.eclipse.xtext.xtext.ui.wizard.releng.RelengProjectFactory;
import org.eclipse.xtext.xtext.ui.wizard.releng.RelengProjectInfo;
import org.eclipse.xtext.xtext.ui.wizard.releng.templates.SiteSpexCreator;

public class RelengProjectsCreator
extends AbstractProjectCreator {
    @Inject
    private Provider<FeatureProjectFactory> featureProjFactoryProvider;
    @Inject
    private Provider<RelengProjectFactory> relengProjFactoryProvider;

    protected RelengProjectInfo getProjectInfo() {
        return (RelengProjectInfo)super.getProjectInfo();
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getCreateModelProjectMessage(), (int)2);
        IProject project = this.createRelengProject(subMonitor.newChild(1));
        this.createSiteFeatureProject(subMonitor.newChild(1));
        IFile antBuildScript = project.getFile((IPath)new Path("build.ant"));
        BasicNewResourceWizard.selectAndReveal((IResource)antBuildScript, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        this.setResult(antBuildScript);
    }

    private IProject createRelengProject(SubMonitor monitor) {
        RelengProjectFactory factory = this.createProjectFactory();
        factory.setRelengProjectInfo(this.getProjectInfo());
        return factory.createProject((IProgressMonitor)monitor, null);
    }

    private IProject createSiteFeatureProject(SubMonitor monitor) {
        FeatureProjectFactory factory = this.createFeatureFactory();
        this.configureFeatureProjectFactory(factory);
        String nameSpaceAbbreviation = this.getProjectInfo().calculateNameSpaceAbbreviation();
        return factory.withCategoryFile(nameSpaceAbbreviation).createProject((IProgressMonitor)monitor, null);
    }

    private void configureFeatureProjectFactory(FeatureProjectFactory factory) {
        factory.setProjectName(this.getProjectInfo().getSiteFeatureProjectName());
        factory.addProjectNatures(new String[]{"org.eclipse.pde.FeatureNature"});
        factory.addBuilderIds(new String[]{"org.eclipse.pde.FeatureBuilder"});
        factory.addFeature(this.getProjectInfo().getBuildFeatureName());
        factory.addContributor((IProjectFactoryContributor)new SiteSpexCreator(this.getProjectInfo()));
    }

    protected RelengProjectFactory createProjectFactory() {
        return (RelengProjectFactory)((Object)this.relengProjFactoryProvider.get());
    }

    private FeatureProjectFactory createFeatureFactory() {
        return (FeatureProjectFactory)this.featureProjFactoryProvider.get();
    }

    protected String getModelFolderName() {
        return null;
    }

    protected List<String> getAllFolders() {
        return null;
    }
}

