/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.javabean.metadata;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.IEventConstants;
import org.eclipse.xwt.IEventGroup;
import org.eclipse.xwt.IXWTLoader;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.XWTMaps;
import org.eclipse.xwt.core.IBinding;
import org.eclipse.xwt.core.ValidationStatus;
import org.eclipse.xwt.internal.utils.UserData;
import org.eclipse.xwt.javabean.metadata.BeanEvent;
import org.eclipse.xwt.javabean.metadata.BindingMetaclass;
import org.eclipse.xwt.javabean.metadata.LoadedEvent;
import org.eclipse.xwt.javabean.metadata.TypedEvent;
import org.eclipse.xwt.javabean.metadata.properties.BeanProperty;
import org.eclipse.xwt.javabean.metadata.properties.DynamicProperty;
import org.eclipse.xwt.javabean.metadata.properties.EventProperty;
import org.eclipse.xwt.javabean.metadata.properties.FieldProperty;
import org.eclipse.xwt.jface.JFacesHelper;
import org.eclipse.xwt.metadata.IEvent;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IObjectInitializer;
import org.eclipse.xwt.metadata.IProperty;

public abstract class AbstractMetaclass
implements IMetaclass {
    public static IObjectInitializer[] EMPTY_INITIALIZERS = new IObjectInitializer[0];
    public static IProperty[] EMPTY_PROPERTIES = new IProperty[0];
    public static IEvent[] EMPTY_ROUTED_EVENTS = new IEvent[0];
    protected final Map<String, IProperty> propertyCache = new HashMap<String, IProperty>();
    protected Map<String, IEvent> routedEventCache = new HashMap<String, IEvent>();
    protected Map<String, IEventGroup> eventGroupCache = Collections.EMPTY_MAP;
    protected Class<?> type;
    protected String name;
    protected IMetaclass superClass;
    protected IXWTLoader xwtLoader;
    protected boolean buildTypedEvents;
    private boolean initialize = false;
    private IObjectInitializer[] initializers = EMPTY_INITIALIZERS;

    protected boolean shouldIgnored(Class<?> declaredType, String propertyName, Class<?> propertyType) {
        String packageName = "";
        if (this.type.getPackage() != null) {
            packageName = declaredType.getPackage().getName();
        }
        if ("data".equals(propertyName) && packageName.startsWith("org.eclipse.swt.")) {
            return true;
        }
        if ("class".equals(propertyName)) {
            return true;
        }
        return "handle".equals(propertyName) && Integer.TYPE == propertyType || "monitor".equals(propertyName) && Monitor.class == propertyType || "region".equals(propertyName) && Region.class == propertyType || "parent".equals(propertyName) && Composite.class == propertyType || "shell".equals(propertyName) && Shell.class == propertyType || "display".equals(propertyName) && Display.class == propertyType;
    }

    protected boolean isWidgetType(Class<?> type) {
        Class<?> superClass = type.getSuperclass();
        if (superClass != null) {
            if (superClass.getName().equalsIgnoreCase(Widget.class.getName())) {
                return true;
            }
            return this.isWidgetType(superClass);
        }
        return false;
    }

    protected final IXWTLoader getXWTLoader() {
        return this.xwtLoader;
    }

    @Override
    public IProperty addProperty(IProperty property) {
        String name = this.normalize(property.getName());
        return this.propertyCache.put(name, property);
    }

    @Override
    public void removeProperty(String propertyName) {
        String name = this.normalize(propertyName);
        this.propertyCache.remove(name);
    }

    private void buildTypedEvents() {
        if (this.buildTypedEvents) {
            return;
        }
        if (this.isSubclassOf(this.getXWTLoader().getMetaclass(Widget.class))) {
            this.addTypedEvent("Activate", 26);
            this.addTypedEvent("Arm", 30);
            this.addTypedEvent("Close", 21);
            this.addTypedEvent("Collapse", 18);
            this.addTypedEvent("Deactivate", 27);
            this.addTypedEvent("DefaultSelection", 14);
            this.addTypedEvent("Deiconify", XWTMaps.getEvent("swt.deiconify"));
            this.addTypedEvent("Dispose", 12);
            this.addTypedEvent("DragDetect", 29);
            this.addTypedEvent("EraseItem", XWTMaps.getEvent("swt.eraseitem"));
            this.addTypedEvent("Expand", 17);
            this.addTypedEvent("FocusIn", 15);
            this.addTypedEvent("FocusOut", 16);
            this.addTypedEvent("HardKeyDown", XWTMaps.getEvent("swt.hardkeydown"));
            this.addTypedEvent("HardKeyUp", XWTMaps.getEvent("swt.hardkeyup"));
            this.addTypedEvent("Help", 28);
            this.addTypedEvent("Hide", 23);
            this.addTypedEvent("Iconify", XWTMaps.getEvent("swt.iconify"));
            this.addTypedEvent("KeyDown", 1);
            this.addTypedEvent("KeyUp", 2);
            this.addTypedEvent("MeasureItem", XWTMaps.getEvent("swt.measureitem"));
            this.addTypedEvent("MenuDetect", 35);
            this.addTypedEvent("Modify", 24);
            this.addTypedEvent("MouseDoubleClick", 8);
            this.addTypedEvent("MouseDown", 3);
            this.addTypedEvent("MouseEnter", XWTMaps.getEvent("swt.mouseenter"));
            this.addTypedEvent("MouseExit", XWTMaps.getEvent("swt.mouseexit"));
            this.addTypedEvent("MouseHover", XWTMaps.getEvent("swt.mousehover"));
            this.addTypedEvent("MouseMove", XWTMaps.getEvent("swt.mousemove"));
            this.addTypedEvent("MouseUp", 4);
            this.addTypedEvent("MouseWheel", XWTMaps.getEvent("swt.mousewheel"));
            this.addTypedEvent("Move", 10);
            this.addTypedEvent("Paint", XWTMaps.getEvent("swt.paint"));
            this.addTypedEvent("PaintItem", XWTMaps.getEvent("swt.paintitem"));
            this.addTypedEvent("Resize", 11);
            this.addTypedEvent("Selection", 13);
            this.addTypedEvent("SetData", 36);
            this.addTypedEvent("Show", 22);
            this.addTypedEvent("Traverse", 31);
            this.addTypedEvent("Verify", 25);
            this.addTypedEvent("ImeComposition", XWTMaps.getEvent("swt.imecomposition"));
        }
        this.buildTypedEvents = true;
    }

    private void addTypedEvent(String name, int eventType) {
        String eventName = IEventConstants.getEventName(name);
        if (!this.routedEventCache.containsKey(eventName)) {
            TypedEvent typedEvent = new TypedEvent(name, eventType);
            this.routedEventCache.put(eventName, typedEvent);
            String eventPropertyName = IEventConstants.getEventPropertyName(name);
            String eventDataName = IEventConstants.getEventPropertyDataName(name);
            this.addProperty(new EventProperty(eventPropertyName, eventDataName, typedEvent));
        }
    }

    @Override
    public IProperty findDefaultProperty() {
        return null;
    }

    @Override
    public IEvent findEvent(String name) {
        this.assertInitialize();
        return this.routedEventCache.get(this.normalize(name));
    }

    @Override
    public IProperty findProperty(String name) {
        this.assertInitialize();
        IProperty property = this.propertyCache.get(this.normalize(name));
        if (property == null && this.superClass != null) {
            property = this.superClass.findProperty(name);
        }
        if (property == null) {
            Method getter = null;
            Method setter = null;
            Class<?> propertyType = null;
            try {
                getter = DynamicProperty.createGetter(this.type, name);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (getter == null) {
                return null;
            }
            propertyType = getter.getReturnType();
            if (this.shouldIgnored(getter.getDeclaringClass(), name, propertyType)) {
                return null;
            }
            try {
                setter = DynamicProperty.createSetter(this.type, propertyType, name);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (getter != null) {
                return new DynamicProperty(propertyType, setter, getter, name);
            }
        }
        return property;
    }

    protected String normalize(String name) {
        return name == null ? name : name.toLowerCase();
    }

    @Override
    public IEvent[] getEvents() {
        this.assertInitialize();
        return this.routedEventCache.values().toArray(new IEvent[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IProperty[] getProperties() {
        this.assertInitialize();
        return this.propertyCache.values().toArray(new IProperty[this.propertyCache.size()]);
    }

    @Override
    public IMetaclass getSuperClass() {
        return this.superClass;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.type.getModifiers());
    }

    @Override
    public boolean isAssignableFrom(IMetaclass metaclass) {
        return this.getType().isAssignableFrom(metaclass.getType());
    }

    @Override
    public boolean isInstance(Object object) {
        return this.type.isInstance(object);
    }

    @Override
    public boolean isSubclassOf(IMetaclass metaclass) {
        this.assertInitialize();
        if (metaclass == null) {
            return false;
        }
        if (this == metaclass) {
            return true;
        }
        if (this.superClass == metaclass) {
            return true;
        }
        if (this.superClass != null) {
            return this.superClass.isSubclassOf(metaclass);
        }
        return false;
    }

    @Override
    public boolean isSuperclassOf(IMetaclass metaclass) {
        return metaclass.isSubclassOf(this);
    }

    @Override
    public Object newInstance(Object[] parameters) {
        this.assertInitialize();
        Object object = this.doNewInstance(parameters);
        if (parameters != null && parameters.length > 0) {
            try {
                this.updateContainment(parameters[0], object);
                this.initialize(object);
            }
            catch (Exception e) {
                throw new XWTException(e);
            }
        }
        return object;
    }

    private void updateContainment(Object parent, Object childElement) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        if (childElement != null && parent != null && !(parent instanceof Widget)) {
            Object propertyType;
            IProperty property;
            IMetaclass parentMetaclass = XWT.getMetaclass(parent);
            IProperty[] properties = parentMetaclass.getProperties();
            IProperty useProperty = null;
            int count = 0;
            Class<?> childType = childElement.getClass();
            IMetaclass childMetaclass = XWT.getMetaclass(childElement);
            if (childMetaclass.getType().equals(ValidationStatus.class) && parentMetaclass.getClass().equals(BindingMetaclass.class)) {
                IProperty childControlProperty = childMetaclass.findProperty("control");
                IProperty parentControlProperty = parentMetaclass.findProperty("control");
                childControlProperty.setValue(childElement, parentControlProperty.getValue(parent));
            }
            IProperty[] iPropertyArray = properties;
            int n = properties.length;
            int parentControlProperty = 0;
            while (parentControlProperty < n) {
                property = iPropertyArray[parentControlProperty];
                propertyType = property.getType();
                if (propertyType != null && propertyType != Object.class && property.isContainement()) {
                    useProperty = property;
                    ++count;
                }
                ++parentControlProperty;
            }
            if (count > 1) {
                StringBuilder builder = new StringBuilder();
                builder.append("Class has more containment properties: ");
                count = 0;
                propertyType = properties;
                int n2 = properties.length;
                n = 0;
                while (n < n2) {
                    IProperty property2 = propertyType[n];
                    Class<?> propertyType2 = property2.getType();
                    if (propertyType2 != null && propertyType2 != Object.class && property2.isContainement()) {
                        if (count != 0) {
                            builder.append(", ");
                        }
                        builder.append(property2.getName());
                        ++count;
                    }
                    ++n;
                }
                throw new XWTException("Class has more containment properties: ");
            }
            if (count == 0) {
                iPropertyArray = properties;
                n = properties.length;
                int property2 = 0;
                while (property2 < n) {
                    property = iPropertyArray[property2];
                    propertyType = property.getType();
                    if (propertyType != null && propertyType != Object.class) {
                        if (((Class)propertyType).isArray()) {
                            Class<?> dataType = ((Class)propertyType).getComponentType();
                            if (dataType.isAssignableFrom(childType)) {
                                if (useProperty == null) {
                                    useProperty = property;
                                }
                                ++count;
                            }
                        } else if (Collection.class.isAssignableFrom((Class<?>)propertyType)) {
                            if (useProperty == null) {
                                useProperty = property;
                            }
                            ++count;
                        } else if (((Class)propertyType).isAssignableFrom(childType)) {
                            if (useProperty == null) {
                                useProperty = property;
                            }
                            ++count;
                        }
                    }
                    ++property2;
                }
            }
            if (count == 1) {
                Class<?> propertyType3 = useProperty.getType();
                if (propertyType3.isArray()) {
                    Object[] existingValue = (Object[])useProperty.getValue(parent);
                    Class<?> dataType = propertyType3.getComponentType();
                    Object[] value = null;
                    if (existingValue == null) {
                        value = (Object[])Array.newInstance(dataType, 1);
                        value[0] = childElement;
                    } else {
                        value = (Object[])Array.newInstance(dataType, existingValue.length + 1);
                        System.arraycopy(existingValue, 0, value, 0, existingValue.length);
                        value[existingValue.length] = childElement;
                    }
                    useProperty.setValue(parent, value);
                } else if (Collection.class.isAssignableFrom(propertyType3) && !(childElement instanceof IBinding)) {
                    ArrayList<Object> existingValue = (ArrayList<Object>)useProperty.getValue(parent);
                    if (existingValue == null) {
                        existingValue = new ArrayList<Object>();
                    }
                    existingValue.add(childElement);
                    useProperty.setValue(parent, existingValue);
                } else if (propertyType3.isAssignableFrom(childType)) {
                    useProperty.setValue(parent, childElement);
                }
            }
        }
    }

    public Object doNewInstance(Object[] parameters) {
        this.assertInitialize();
        try {
            if (parameters.length == 0 || !(parameters[0] instanceof Widget) && !JFacesHelper.isViewer(parameters[0])) {
                return this.getType().newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            Class<?>[] parameterTypes;
            Constructor<?> constructor;
            Object swtObject = null;
            Object parent = parameters[0];
            Widget directParent = UserData.getWidget(parent);
            if (directParent == null) {
                directParent = UserData.getTreeParent(parent);
            }
            if (directParent != null && Control.class.isAssignableFrom(this.getType()) && !(directParent instanceof Composite)) {
                directParent = this.getXWTLoader().findCompositeParent(directParent);
            }
            Object styleValue = null;
            if (parameters.length == 2 && parameters[1] != null && (parameters[1].getClass() == Integer.TYPE || parameters[1].getClass() == Integer.class)) {
                styleValue = parameters[1];
            }
            Constructor<?> defaultConstructor = null;
            Constructor<?>[] constructorArray = this.getType().getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                constructor = constructorArray[n2];
                parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length > 2 || parameterTypes.length == 0) {
                    if (parameterTypes.length == 0) {
                        defaultConstructor = constructor;
                    }
                } else if (parameterTypes[0].isAssignableFrom(parent.getClass())) {
                    if (parameterTypes.length == 1) {
                        if (styleValue == null) {
                            swtObject = constructor.newInstance(parent);
                            break;
                        }
                    } else if (parameterTypes[1].isAssignableFrom(Integer.TYPE)) {
                        if (styleValue == null) {
                            swtObject = constructor.newInstance(parent, 0);
                            break;
                        }
                        swtObject = constructor.newInstance(parent, styleValue);
                        break;
                    }
                }
                ++n2;
            }
            if (swtObject == null) {
                constructorArray = this.getType().getConstructors();
                n = constructorArray.length;
                n2 = 0;
                while (n2 < n) {
                    constructor = constructorArray[n2];
                    parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length > 2 || parameterTypes.length == 0) {
                        if (parameterTypes.length == 0) {
                            defaultConstructor = constructor;
                        }
                    } else if (directParent != null && parameterTypes[0].isAssignableFrom(directParent.getClass())) {
                        if (parameterTypes.length == 1) {
                            swtObject = constructor.newInstance(directParent);
                            break;
                        }
                        if (parameterTypes[1].isAssignableFrom(Integer.TYPE)) {
                            if (styleValue == null) {
                                swtObject = constructor.newInstance(directParent, 0);
                                break;
                            }
                            swtObject = constructor.newInstance(directParent, styleValue);
                            break;
                        }
                    }
                    ++n2;
                }
            }
            if (swtObject == null) {
                if (defaultConstructor == null) {
                    if (UserData.isUIElementType(this.getType())) {
                        Shell shell = new Shell();
                        try {
                            Constructor<?> constructor2 = this.getType().getConstructor(Composite.class, Integer.TYPE);
                            if (constructor2 != null) {
                                return constructor2.newInstance(shell, 0);
                            }
                        }
                        catch (Exception e) {
                            throw new XWTException("Constructor " + this.getType().getName() + " no found.");
                        }
                    }
                    try {
                        swtObject = this.getType().newInstance();
                    }
                    catch (Exception e) {
                        throw new XWTException("Constructor " + this.getType().getName() + " no found.");
                    }
                }
                swtObject = defaultConstructor.newInstance(new Object[0]);
            }
            return swtObject;
        }
        catch (SecurityException e) {
            throw new XWTException(e);
        }
        catch (IllegalArgumentException e) {
            throw new XWTException(e);
        }
        catch (InstantiationException e) {
            throw new XWTException(e);
        }
        catch (IllegalAccessException e) {
            throw new XWTException(e);
        }
        catch (InvocationTargetException e) {
            throw new XWTException(e);
        }
    }

    @Override
    public Class<?> getDataContextType() {
        return Object.class;
    }

    private void assertInitialize() {
        this.initialize(this.type, this.superClass);
    }

    protected void initialize(Class<?> type, IMetaclass superClass) {
        if (this.isInitialize()) {
            return;
        }
        try {
            Class<?> propertyType;
            String propertyName;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            Object[] objectArray = propertyDescriptors;
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor p = objectArray[n2];
                propertyName = p.getName();
                propertyType = p.getPropertyType();
                if (p.getReadMethod() != null && !this.shouldIgnored(p.getReadMethod().getDeclaringClass(), propertyName, propertyType) && !this.propertyCache.containsKey(propertyName.toLowerCase()) && p.getPropertyType() != null) {
                    IProperty property;
                    IProperty iProperty = property = superClass != null ? superClass.findProperty(p.getName().toLowerCase()) : null;
                    if (property != null && !property.isDefault()) {
                        this.addProperty(property);
                    } else if (p.getWriteMethod() != null || !p.getPropertyType().isPrimitive()) {
                        this.addProperty(new BeanProperty(p));
                    }
                }
                ++n2;
            }
            objectArray = type.getDeclaredFields();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                if (!Modifier.isStatic(((Field)f).getModifiers())) {
                    propertyName = ((Field)f).getName();
                    propertyType = ((Field)f).getType();
                    if (!this.shouldIgnored(((Field)f).getDeclaringClass(), propertyName, propertyType) && !this.propertyCache.containsKey(this.normalize(propertyName)) && !Modifier.isFinal(((Field)f).getModifiers()) && Modifier.isPublic(((Field)f).getModifiers())) {
                        this.addProperty(new FieldProperty((Field)f));
                    }
                }
                ++n2;
            }
            objectArray = beanInfo.getEventSetDescriptors();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object eventSetDescriptor = objectArray[n2];
                String name = IEventConstants.getEventName(((FeatureDescriptor)eventSetDescriptor).getName());
                BeanEvent event = new BeanEvent(((FeatureDescriptor)eventSetDescriptor).getName(), (EventSetDescriptor)eventSetDescriptor);
                this.routedEventCache.put(name, event);
                String propertyName2 = IEventConstants.getEventPropertyName(((FeatureDescriptor)eventSetDescriptor).getName());
                String propertyDataName = IEventConstants.getEventPropertyDataName(((FeatureDescriptor)eventSetDescriptor).getName());
                this.addProperty(new EventProperty(propertyName2, propertyDataName, event));
                ++n2;
            }
            if (this.isWidgetType(type)) {
                LoadedEvent loadedEvent = new LoadedEvent("LoadedEvent");
                this.routedEventCache.put(this.normalize("Loaded"), loadedEvent);
                this.routedEventCache.put(this.normalize("LoadedEvent"), loadedEvent);
            }
            this.markInitialized();
            this.buildTypedEvents();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    private void markInitialized() {
        this.initialize = true;
    }

    private boolean isInitialize() {
        return this.initialize;
    }

    @Override
    public void addEventGroup(IEventGroup eventGroup) {
        if (this.eventGroupCache == Collections.EMPTY_MAP) {
            this.eventGroupCache = new HashMap<String, IEventGroup>();
        }
        String[] stringArray = eventGroup.getEventNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (this.eventGroupCache.containsKey(string)) {
                throw new IllegalArgumentException("Event \"" + string + "\" already existis in a group.");
            }
            String key = this.normalize(string);
            if ("menudetecteventevent".equals(key)) {
                System.out.println(string);
            }
            this.eventGroupCache.put(key, eventGroup);
            ++n2;
        }
    }

    @Override
    public IEventGroup getEventGroup(String event) {
        IEventGroup eventGroup = this.eventGroupCache.get(event);
        if (eventGroup == null && this.superClass != null) {
            return this.superClass.getEventGroup(event);
        }
        return eventGroup;
    }

    @Override
    public void addInitializer(IObjectInitializer initializer) {
        int i = 0;
        while (i < this.initializers.length) {
            if (this.initializers[i] == initializer) {
                return;
            }
            ++i;
        }
        IObjectInitializer[] oldValue = this.initializers;
        this.initializers = new IObjectInitializer[oldValue.length + 1];
        System.arraycopy(oldValue, 0, this.initializers, 0, oldValue.length);
        this.initializers[oldValue.length] = initializer;
    }

    @Override
    public void removeInitializer(IObjectInitializer initializer) {
        int i = 0;
        while (i < this.initializers.length) {
            if (this.initializers[i] == initializer) {
                IObjectInitializer[] oldValue = this.initializers;
                this.initializers = new IObjectInitializer[oldValue.length - 1];
                System.arraycopy(oldValue, 0, this.initializers, 0, i);
                System.arraycopy(oldValue, i + 1, this.initializers, i, oldValue.length - i - 1);
                return;
            }
            ++i;
        }
    }

    @Override
    public IObjectInitializer[] getInitializers() {
        return this.initializers;
    }

    @Override
    public void initialize(Object instance) {
        if (this.superClass != null) {
            this.superClass.initialize(instance);
        }
        int i = 0;
        while (i < this.initializers.length) {
            if (this.initializers[i] != null) {
                this.initializers[i].initialize(instance);
            }
            ++i;
        }
    }
}

