/*
 * Decompiled with CFR 0.152.
 */
package com.mycorp.examples.timeservice.internal.provider.rest.consumer;

import com.mycorp.examples.timeservice.ITimeService;
import java.io.NotSerializableException;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.IRemoteResponseDeserializer;
import org.eclipse.ecf.remoteservice.provider.RemoteServiceContainerInstantiator;
import org.eclipse.ecf.remoteservice.rest.RestCallableFactory;
import org.eclipse.ecf.remoteservice.rest.client.AbstractRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpGetRequestType;
import org.eclipse.ecf.remoteservice.rest.client.RestClientContainer;
import org.eclipse.ecf.remoteservice.rest.identity.RestID;
import org.eclipse.ecf.remoteservice.rest.identity.RestNamespace;
import org.json.JSONException;
import org.json.JSONObject;

public class TimeServiceRestClientContainer
extends RestClientContainer {
    public static final String TIMESERVICE_CONSUMER_CONFIG_NAME = "com.mycorp.examples.timeservice.rest.consumer";
    private static final String TIMESERVICE_HOST_CONFIG_NAME = "com.mycorp.examples.timeservice.rest.host";
    private IRemoteServiceRegistration reg;

    TimeServiceRestClientContainer(RestID id) {
        super(id);
        this.setResponseDeserializer(new IRemoteResponseDeserializer(){

            public Object deserializeResponse(String endpoint, IRemoteCall call, IRemoteCallable callable, Map responseHeaders, byte[] responseBody) throws NotSerializableException {
                try {
                    return new JSONObject(new String(responseBody)).get("time");
                }
                catch (JSONException e1) {
                    NotSerializableException t = new NotSerializableException("Exception serializing response from endpoing=" + endpoint);
                    t.setStackTrace(e1.getStackTrace());
                    throw t;
                }
            }
        });
    }

    public void connect(ID targetID, IConnectContext connectContext1) throws ContainerConnectException {
        super.connect(targetID, connectContext1);
        IRemoteCallable callable = RestCallableFactory.createCallable((String)"getCurrentTime", (String)ITimeService.class.getName(), null, (AbstractRequestType)new HttpGetRequestType(), (long)30000L);
        this.reg = this.registerCallables(new String[]{ITimeService.class.getName()}, new IRemoteCallable[][]{{callable}}, null);
    }

    public void disconnect() {
        super.disconnect();
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    public Namespace getConnectNamespace() {
        return RestNamespace.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Instantiator
    extends RemoteServiceContainerInstantiator {
        public IContainer createInstance(ContainerTypeDescription description, Map<String, ?> parameters) throws ContainerCreateException {
            return new TimeServiceRestClientContainer((RestID)RestNamespace.INSTANCE.createInstance(new Object[]{"uuid:" + UUID.randomUUID().toString()}));
        }

        public String[] getImportedConfigs(ContainerTypeDescription description, String[] exporterSupportedConfigs) {
            if (Arrays.asList(exporterSupportedConfigs).contains(TimeServiceRestClientContainer.TIMESERVICE_HOST_CONFIG_NAME)) {
                return new String[]{TimeServiceRestClientContainer.TIMESERVICE_CONSUMER_CONFIG_NAME};
            }
            return null;
        }
    }
}

