/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation;
import java.util.Iterator;
import java.util.LinkedList;

class BufferedAndIterator
implements CloneableIterator<EWAHIterator> {
    EWAHCompressedBitmap buffer = new EWAHCompressedBitmap();
    LinkedList<IteratingRLW> ll;
    int buffersize;

    public BufferedAndIterator(LinkedList<IteratingRLW> basell, int bufsize) {
        this.ll = basell;
        this.buffersize = bufsize;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    public BufferedAndIterator clone() throws CloneNotSupportedException {
        BufferedAndIterator answer = (BufferedAndIterator)super.clone();
        answer.buffer = this.buffer.clone();
        answer.ll = (LinkedList)this.ll.clone();
        return answer;
    }

    @Override
    public EWAHIterator next() {
        Iterator i;
        this.buffer.clear();
        IteratorAggregation.andToContainer(this.buffer, this.buffersize * this.ll.size(), this.ll.get(0), this.ll.get(1));
        if (this.ll.size() > 2) {
            i = this.ll.iterator();
            i.next();
            i.next();
            EWAHCompressedBitmap tmpbuffer = new EWAHCompressedBitmap();
            while (i.hasNext() && this.buffer.sizeInBytes() > 0) {
                IteratorAggregation.andToContainer(tmpbuffer, this.buffer.getIteratingRLW(), (IteratingRLW)i.next());
                this.buffer.swap(tmpbuffer);
                tmpbuffer.clear();
            }
        }
        i = this.ll.iterator();
        while (i.hasNext()) {
            if (((IteratingRLW)i.next()).size() != 0L) continue;
            this.ll.clear();
            break;
        }
        return this.buffer.getEWAHIterator();
    }
}

