/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final String LINE_SEP = System.getProperty("line.separator");
    private static final int BUFFER_SIZE = 8192;
    private static Logger logger = Logger.getLogger("org.eclipse.actf.core");
    private static FilenameFilter dirFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return new File(file, string).isDirectory();
        }
    };

    private static FilenameFilter formFilter(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '*') {
                stringBuffer.insert(n, '.');
                ++n;
            } else if (stringBuffer.charAt(n) == '?') {
                stringBuffer.insert(n, '.');
                ++n;
            } else if (".-%^$!~".indexOf(stringBuffer.charAt(n)) >= 0) {
                stringBuffer.insert(n, '\\');
                ++n;
            }
            ++n;
        }
        final Pattern pattern = Pattern.compile(stringBuffer.toString());
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return pattern.matcher(string).matches();
            }
        };
        return filenameFilter;
    }

    public static String replaceWhiteSpaceInUrl(String string) {
        return string.replaceAll(" ", "%20");
    }

    /*
     * Loose catch block
     */
    public static synchronized boolean copyFile(File file, String string, boolean bl) {
        FilterOutputStream filterOutputStream;
        BufferedInputStream bufferedInputStream;
        block29: {
            int n;
            byte[] byArray;
            block27: {
                block28: {
                    bufferedInputStream = null;
                    filterOutputStream = null;
                    byArray = new byte[8192];
                    File file2 = new File(string);
                    if (bl || !file2.exists()) break block27;
                    if (bufferedInputStream == null) break block28;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            if (bufferedInputStream == null) break block29;
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (filterOutputStream != null) {
            try {
                filterOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return true;
        catch (Exception exception) {
            block30: {
                try {
                    exception.printStackTrace();
                    if (bufferedInputStream == null) break block30;
                }
                catch (Throwable throwable) {
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            return false;
        }
    }

    public static synchronized boolean copyFile(String string, String string2, boolean bl) {
        return FileUtils.copyFile(new File(string), string2, bl);
    }

    public static void copyFile(FileInputStream fileInputStream, FileOutputStream fileOutputStream) throws IOException {
        int n = -1;
        while ((n = fileInputStream.read()) != -1) {
            fileOutputStream.write(n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void copyFiles(File file, File file2, String string) {
        Object object;
        FilenameFilter filenameFilter = FileUtils.formFilter(string);
        File[] fileArray = file.listFiles(filenameFilter);
        File[] fileArray2 = file.listFiles(dirFilter);
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            try {
                object = new FileInputStream(fileArray[n]);
                FileOutputStream fileOutputStream = new FileOutputStream(new File(file2, fileArray[n].getName()));
                FileUtils.copyFile((FileInputStream)object, fileOutputStream);
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Could not copy file " + fileArray[n].getName());
            }
            ++n;
        }
        n = 0;
        while (fileArray2 != null && n < fileArray2.length) {
            object = new File(file2, fileArray2[n].getName());
            if (((File)object).mkdir() || ((File)object).exists()) {
                FileUtils.copyFiles(fileArray2[n], (File)object, string);
            } else {
                logger.log(Level.WARNING, "Could not create directory " + ((File)object).getName());
            }
            ++n;
        }
    }

    public static synchronized boolean copyFile(Bundle bundle, IPath iPath, String string, boolean bl) {
        try {
            FileUtils.saveToFile(FileLocator.openStream((Bundle)bundle, (IPath)iPath, (boolean)false), string, bl);
            return true;
        }
        catch (IOException iOException) {
            try {
                FileUtils.saveToFile(FileLocator.find((Bundle)bundle, (IPath)iPath, null).openStream(), string, bl);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized boolean saveToFile(InputStream inputStream, String string, boolean bl) {
        boolean bl2;
        byte[] byArray;
        FilterOutputStream filterOutputStream;
        BufferedInputStream bufferedInputStream;
        block25: {
            block26: {
                bufferedInputStream = null;
                filterOutputStream = null;
                byArray = new byte[8192];
                bl2 = true;
                File file = new File(string);
                if (bl || !file.exists()) break block25;
                if (bufferedInputStream == null) break block26;
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream == null) return false;
            try {
                filterOutputStream.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
        try {
            try {
                int n;
                bufferedInputStream = new BufferedInputStream(inputStream);
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
                while ((n = bufferedInputStream.read(byArray)) > 0) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                }
            }
            catch (Exception exception) {
                bl2 = false;
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (filterOutputStream == null) return bl2;
                try {
                    filterOutputStream.close();
                    return bl2;
                }
                catch (IOException iOException) {}
                return bl2;
            }
        }
        catch (Throwable throwable) {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream == null) throw throwable;
            try {
                filterOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (filterOutputStream == null) return bl2;
        try {
            filterOutputStream.close();
            return bl2;
        }
        catch (IOException iOException) {}
        return bl2;
    }

    public static void deleteFiles(File file) {
        if (file != null) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    FileUtils.deleteFiles(fileArray[n]);
                }
                fileArray[n].delete();
                ++n;
            }
        }
    }

    public static void deleteFiles(File file, String string) {
        FilenameFilter filenameFilter = FileUtils.formFilter(string);
        File[] fileArray = file.listFiles(filenameFilter);
        File[] fileArray2 = file.listFiles(dirFilter);
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            new File(file, fileArray[n].getName()).delete();
            ++n;
        }
        n = 0;
        while (fileArray2 != null && n < fileArray2.length) {
            File file2 = new File(file, fileArray2[n].getName());
            FileUtils.deleteFiles(file2, string);
            if (!file2.delete()) {
                logger.log(Level.WARNING, "Could not delete directory " + file2);
            }
            ++n;
        }
    }

    public static File[] findFiles(String string, File file) {
        LinkedList<File> linkedList = new LinkedList<File>();
        FileUtils.findFiles(FileUtils.formFilter(string), file, linkedList);
        return linkedList.toArray(new File[linkedList.size()]);
    }

    public static void findFiles(FilenameFilter filenameFilter, File file, List<File> list) {
        File[] fileArray = file.listFiles(dirFilter);
        File[] fileArray2 = file.listFiles(filenameFilter);
        if (fileArray2 != null && fileArray2.length > 0) {
            list.addAll(Arrays.asList(fileArray2));
        }
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            File file2 = new File(file, fileArray[n].getName());
            FileUtils.findFiles(filenameFilter, file2, list);
            ++n;
        }
    }

    public static boolean isAvailableDirectory(String string) {
        File file = new File(string);
        if (!(file.isDirectory() && file.canWrite() || file.mkdirs())) {
            DebugPrintUtil.devOrDebugPrintln(String.valueOf(string) + " is not available.");
            return false;
        }
        return true;
    }

    public static String getActfTempDir() {
        String string = System.getProperty("java.io.tmpdir");
        if (string != null) {
            if (!string.endsWith(File.separator)) {
                string = String.valueOf(string) + File.separator;
            }
            string = String.valueOf(string) + "actf";
        }
        return string;
    }
}

