/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.composite;

import java.util.Date;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.composite.CertificateBlock;
import org.eclipse.andmore.android.certmanager.ui.wizards.CreateKeyWizardPage;
import org.eclipse.andmore.android.common.utilities.ui.WidgetsFactory;
import org.eclipse.andmore.android.common.utilities.ui.WidgetsUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewKeyBlock
extends CertificateBlock {
    private static final int VALIDITY_SIZE = 3;
    private static final int SMALL_TEXT_SIZE = 64;
    private CreateKeyWizardPage baseWizardPage;
    private Label keyPasswordLabel;
    private Label keyConfirmPasswordLabel;
    private Text keyPassword;
    private Text keyConfirmPassword;
    private Button savePasswordCheckBox;
    private Text textValidity = null;
    private Label labelValidity = null;
    private boolean canSavePassword = false;
    private String keyPasswordText = new String();
    private static final String DEFAULT_VALIDITY_IN_YEARS = "30";

    @Override
    public Composite createContent(Composite parent) {
        Composite composite = super.createContent(parent);
        this.decorateRequiredFields();
        return composite;
    }

    @Override
    protected void createCustomDetailedInfoArea(Composite parent) {
        this.labelValidity = WidgetsFactory.createLabel((Composite)parent, (String)(String.valueOf(CertificateManagerNLS.CertificateBlock_Validity) + ":"));
        this.textValidity = WidgetsFactory.createText((Composite)parent);
        this.textValidity.addListener(24, (Listener)this);
        this.textValidity.addFocusListener(this.focusListener);
        this.textValidity.setTextLimit(3);
        this.textValidity.setText(DEFAULT_VALIDITY_IN_YEARS);
    }

    @Override
    protected void createCustomArea(Composite parent) {
        Group passwordGroup = WidgetsFactory.createTitledGroup((Composite)parent, (String)CertificateManagerNLS.NewKeyBlock_PasswordGroupTitle, (int)2);
        this.keyPasswordLabel = new Label((Composite)passwordGroup, 0);
        this.keyPasswordLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.keyPasswordLabel.setText(String.valueOf(CertificateManagerNLS.CertificateBlock_KeyPassword_Label) + ":");
        this.keyPassword = new Text((Composite)passwordGroup, 0x400804);
        this.keyPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.keyPassword.setTextLimit(64);
        this.keyPassword.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewKeyBlock.this.keyPasswordText = NewKeyBlock.this.keyPassword.getText();
                NewKeyBlock.super.handleEvent(event);
            }
        });
        this.keyPassword.addFocusListener(this.focusListener);
        this.keyConfirmPasswordLabel = new Label((Composite)passwordGroup, 0);
        this.keyConfirmPasswordLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.keyConfirmPasswordLabel.setText(String.valueOf(CertificateManagerNLS.CertificateBlock_ConfirmKeyPassword_Label) + ":");
        this.keyConfirmPassword = new Text((Composite)passwordGroup, 0x400804);
        this.keyConfirmPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.keyConfirmPassword.addListener(24, (Listener)this);
        this.keyConfirmPassword.addFocusListener(this.focusListener);
        this.keyConfirmPassword.setTextLimit(64);
        this.savePasswordCheckBox = new Button((Composite)passwordGroup, 32);
        this.savePasswordCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.savePasswordCheckBox.setText(CertificateManagerNLS.PasswordProvider_SaveThisPassword);
        this.savePasswordCheckBox.setSelection(false);
        this.savePasswordCheckBox.addFocusListener(this.focusListener);
        if (this.baseWizardPage != null && this.baseWizardPage.getKeystore() != null) {
            this.savePasswordCheckBox.setVisible(KeyStoreManager.getInstance().isKeystoreMapped(this.baseWizardPage.getKeystore().getFile()));
        }
        this.savePasswordCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewKeyBlock.this.canSavePassword = NewKeyBlock.this.savePasswordCheckBox.getSelection();
            }
        });
    }

    @Override
    protected void decorateRequiredFields() {
        super.decorateRequiredFields();
        this.labelValidity.setText(this.decorateText(this.labelValidity.getText()));
        this.keyPasswordLabel.setText(this.decorateText(this.keyPasswordLabel.getText()));
        this.keyConfirmPasswordLabel.setText(this.decorateText(this.keyConfirmPasswordLabel.getText()));
    }

    @Override
    public boolean isPageComplete() {
        return super.isPageComplete() && !WidgetsUtil.isNullOrEmpty((Text)this.textValidity) && !WidgetsUtil.isNullOrEmpty((Text)this.keyPassword) && !WidgetsUtil.isNullOrEmpty((Text)this.keyConfirmPassword);
    }

    @Override
    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && !WidgetsUtil.isNullOrEmpty((Text)this.textValidity) && !WidgetsUtil.isNullOrEmpty((Text)this.keyPassword) && !WidgetsUtil.isNullOrEmpty((Text)this.keyConfirmPassword);
    }

    public Composite createInfoBlock(Composite parent, String alias, String name, String organization, String organizationUnit, String country, String state, String locality, Date validity, Date creationDate) {
        Composite toReturn = super.createInfoBlock(parent, alias, name, organization, organizationUnit, country, state, locality);
        this.labelValidity.setText(String.valueOf(CertificateManagerNLS.CertificateBlock_ExpirationDate) + ":");
        this.textValidity.setTextLimit(Text.LIMIT);
        this.textValidity.setText(validity.toString());
        this.textValidity.setEditable(false);
        this.keyPasswordLabel.setVisible(false);
        this.keyPassword.setVisible(false);
        this.keyConfirmPasswordLabel.setVisible(false);
        this.keyConfirmPassword.setVisible(false);
        this.savePasswordCheckBox.setVisible(false);
        return toReturn;
    }

    public String getKeyPassword() {
        return this.keyPasswordText;
    }

    public String getKeyConfirmPassword() {
        return this.keyConfirmPassword.getText();
    }

    public boolean needToSaveKeyPassword() {
        return this.canSavePassword;
    }

    @Override
    public String getErrorMessage() {
        String message = super.getErrorMessage();
        if (message == null) {
            try {
                int validity = Integer.parseInt(this.textValidity.getText());
                if (validity <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                message = CertificateManagerNLS.CertificateBlock_Validity_Error;
            }
        }
        if (message == null) {
            if (!this.keyPassword.getText().equals(this.keyConfirmPassword.getText())) {
                message = CertificateManagerNLS.CreateKeystorePage_PasswordDoesNotMatch;
            }
            if (this.keyPassword.getText().length() < 6) {
                message = NLS.bind((String)CertificateManagerNLS.CreateKeystorePage_PasswordMinSizeMessage, (Object)6);
            }
        }
        return message;
    }

    protected void setMessage(String message, int messageType) {
        if (this.baseWizardPage != null) {
            this.baseWizardPage.setMessage(message, messageType);
        }
    }

    public String getValidity() {
        return this.textValidity.getText();
    }

    public void setBaseWizardPage(CreateKeyWizardPage baseWizardPage) {
        this.baseWizardPage = baseWizardPage;
    }
}

