/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest.parser;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.andmore.android.model.manifest.dom.AbstractBuildingBlockNode;
import org.eclipse.andmore.android.model.manifest.dom.AbstractIconLabelNameNode;
import org.eclipse.andmore.android.model.manifest.dom.AbstractSimpleNameNode;
import org.eclipse.andmore.android.model.manifest.dom.ActionNode;
import org.eclipse.andmore.android.model.manifest.dom.ActivityAliasNode;
import org.eclipse.andmore.android.model.manifest.dom.ActivityNode;
import org.eclipse.andmore.android.model.manifest.dom.ApplicationNode;
import org.eclipse.andmore.android.model.manifest.dom.CategoryNode;
import org.eclipse.andmore.android.model.manifest.dom.CommentNode;
import org.eclipse.andmore.android.model.manifest.dom.DataNode;
import org.eclipse.andmore.android.model.manifest.dom.GrantUriPermissionNode;
import org.eclipse.andmore.android.model.manifest.dom.IAndroidManifestProperties;
import org.eclipse.andmore.android.model.manifest.dom.InstrumentationNode;
import org.eclipse.andmore.android.model.manifest.dom.IntentFilterNode;
import org.eclipse.andmore.android.model.manifest.dom.ManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.MetadataNode;
import org.eclipse.andmore.android.model.manifest.dom.PermissionGroupNode;
import org.eclipse.andmore.android.model.manifest.dom.PermissionNode;
import org.eclipse.andmore.android.model.manifest.dom.PermissionTreeNode;
import org.eclipse.andmore.android.model.manifest.dom.ProviderNode;
import org.eclipse.andmore.android.model.manifest.dom.ReceiverNode;
import org.eclipse.andmore.android.model.manifest.dom.ServiceNode;
import org.eclipse.andmore.android.model.manifest.dom.UnknownNode;
import org.eclipse.andmore.android.model.manifest.dom.UsesFeatureNode;
import org.eclipse.andmore.android.model.manifest.dom.UsesLibraryNode;
import org.eclipse.andmore.android.model.manifest.dom.UsesPermissionNode;
import org.eclipse.andmore.android.model.manifest.dom.UsesSDKNode;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Comment;
import org.w3c.dom.NamedNodeMap;

abstract class AndroidManifestNodeParser
implements IAndroidManifestProperties {
    protected final List<String> parseErrors = new LinkedList<String>();

    protected ManifestNode parseManifestNode(NamedNodeMap attributes) {
        ManifestNode manifestNode = new ManifestNode("");
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("package")) {
                manifestNode.setPackage(attrValue);
            } else if (attrName.equalsIgnoreCase("android:sharedUserId")) {
                manifestNode.setSharedUserId(attrValue);
            } else if (attrName.equalsIgnoreCase("android:versionCode")) {
                Integer versionCode;
                try {
                    versionCode = Integer.parseInt(attrValue);
                }
                catch (NumberFormatException nfe) {
                    versionCode = 1;
                    String errMsg = NLS.bind((String)UtilitiesNLS.ERR_AndroidManifestNodeParser_ErrorParsingVersionCode, (Object)attrValue, (Object)versionCode.toString());
                    this.parseErrors.add(errMsg);
                    AndmoreLogger.error(AndroidManifestNodeParser.class, errMsg, (Throwable)nfe);
                }
                manifestNode.setVersionCode(versionCode);
            } else if (attrName.equalsIgnoreCase("android:versionName")) {
                manifestNode.setVersionName(attrValue);
            } else if (!attrName.equalsIgnoreCase("xmlns:android")) {
                manifestNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return manifestNode;
    }

    protected UsesPermissionNode parseUsesPermissionNode(NamedNodeMap attributes) {
        UsesPermissionNode usesPermissionNode = new UsesPermissionNode("");
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:name")) {
                usesPermissionNode.setName(attrValue);
            } else {
                usesPermissionNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return usesPermissionNode;
    }

    protected PermissionNode parsePermissionNode(NamedNodeMap attributes) {
        PermissionNode permissionNode = new PermissionNode("");
        this.parseAbstractIconLabelNameNode(attributes, permissionNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:description")) {
                permissionNode.setDescription(attrValue);
            } else if (attrName.equalsIgnoreCase("android:permissionGroup")) {
                permissionNode.setPermissionGroup(attrValue);
            } else if (attrName.equalsIgnoreCase("android:protectionLevel")) {
                permissionNode.setProtectionLevel(PermissionNode.getProtectionLevel(attrValue));
            } else {
                permissionNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return permissionNode;
    }

    protected PermissionTreeNode parsePermissionTreeNode(NamedNodeMap attributes) {
        PermissionTreeNode permissionTreeNode = new PermissionTreeNode("");
        this.parseAbstractIconLabelNameNode(attributes, permissionTreeNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            permissionTreeNode.addUnknownProperty(attrName, attrValue);
            ++i;
        }
        return permissionTreeNode;
    }

    protected PermissionGroupNode parsePermissionGroupNode(NamedNodeMap attributes) {
        PermissionGroupNode permissionGroupNode = new PermissionGroupNode("");
        this.parseAbstractIconLabelNameNode(attributes, permissionGroupNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:description")) {
                permissionGroupNode.setDescription(attrValue);
            } else {
                permissionGroupNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return permissionGroupNode;
    }

    protected InstrumentationNode parseInstrumentationNode(NamedNodeMap attributes) {
        InstrumentationNode instrumentationNode = new InstrumentationNode("");
        this.parseAbstractIconLabelNameNode(attributes, instrumentationNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:functionalTest")) {
                Boolean functionalTest = Boolean.parseBoolean(attrValue);
                instrumentationNode.setFunctionalTest(functionalTest);
            } else if (attrName.equalsIgnoreCase("android:handleProfiling")) {
                Boolean handleProfiling = Boolean.parseBoolean(attrValue);
                instrumentationNode.setHandleProfiling(handleProfiling);
            } else if (attrName.equalsIgnoreCase("android:targetPackage")) {
                instrumentationNode.setTargetPackage(attrValue);
            } else {
                instrumentationNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return instrumentationNode;
    }

    protected UsesSDKNode parseUsesSdkNode(NamedNodeMap attributes) {
        UsesSDKNode usesSDKNode = new UsesSDKNode();
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:minSdkVersion")) {
                String minSdkVersion = attrValue;
                usesSDKNode.setMinSdkVersion(minSdkVersion);
            } else if (attrName.equalsIgnoreCase("android:maxSdkVersion")) {
                usesSDKNode.setPropMaxSdkVersion(attrValue);
            } else if (attrName.equalsIgnoreCase("android:targetSdkVersion")) {
                usesSDKNode.setPropTargetSdkVersion(attrValue);
            } else {
                usesSDKNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return usesSDKNode;
    }

    protected ApplicationNode parseApplicationNode(NamedNodeMap attributes) {
        ApplicationNode applicationNode = new ApplicationNode("");
        this.parseAbstractIconLabelNameNode(attributes, applicationNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:allowClearUserData")) {
                Boolean allowClearUserData = Boolean.parseBoolean(attrValue);
                applicationNode.setAllowClearUserData(allowClearUserData);
            } else if (attrName.equalsIgnoreCase("android:allowTaskReparenting")) {
                Boolean allowTaskReparentig = Boolean.parseBoolean(attrValue);
                applicationNode.setAllowTaskReparenting(allowTaskReparentig);
            } else if (attrName.equalsIgnoreCase("android:debuggable")) {
                Boolean debbugable = Boolean.parseBoolean(attrValue);
                applicationNode.setDebuggable(debbugable);
            } else if (attrName.equalsIgnoreCase("android:description")) {
                applicationNode.setDescription(attrValue);
            } else if (attrName.equalsIgnoreCase("android:enabled")) {
                Boolean enabled = Boolean.parseBoolean(attrValue);
                applicationNode.setEnabled(enabled);
            } else if (attrName.equalsIgnoreCase("android:hasCode")) {
                Boolean hasCode = Boolean.parseBoolean(attrValue);
                applicationNode.setHasCode(hasCode);
            } else if (attrName.equalsIgnoreCase("android:manageSpaceActivity")) {
                applicationNode.setManageSpaceActivity(attrValue);
            } else if (attrName.equalsIgnoreCase("android:permission")) {
                applicationNode.setPermission(attrValue);
            } else if (attrName.equalsIgnoreCase("android:persistent")) {
                Boolean persistent = Boolean.parseBoolean(attrValue);
                applicationNode.setPersistent(persistent);
            } else if (attrName.equalsIgnoreCase("android:process")) {
                applicationNode.setProcess(attrValue);
            } else if (attrName.equalsIgnoreCase("android:taskAffinity")) {
                applicationNode.setTaskAffinity(attrValue);
            } else if (attrName.equalsIgnoreCase("android:theme")) {
                applicationNode.setTheme(attrValue);
            } else {
                applicationNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return applicationNode;
    }

    protected ActivityNode parseActivityNode(NamedNodeMap attributes) {
        ActivityNode activityNode = new ActivityNode("");
        this.parseAbstractBuildingBlockNode(attributes, activityNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:allowTaskReparenting")) {
                Boolean allowTaskReparentig = Boolean.parseBoolean(attrValue);
                activityNode.setAllowTaskReparenting(allowTaskReparentig);
            } else if (attrName.equalsIgnoreCase("android:alwaysRetainTaskState")) {
                Boolean alwaysRetainTaskState = Boolean.parseBoolean(attrValue);
                activityNode.setAlwaysRetainTaskState(alwaysRetainTaskState);
            } else if (attrName.equalsIgnoreCase("android:clearTaskOnLaunch")) {
                Boolean clearTaskOnLaunch = Boolean.parseBoolean(attrValue);
                activityNode.setClearTaskOnLaunch(clearTaskOnLaunch);
            } else if (attrName.equalsIgnoreCase("android:configChanges")) {
                String[] configChanges;
                String[] stringArray = configChanges = attrValue.split("\\|");
                int n = configChanges.length;
                int n2 = 0;
                while (n2 < n) {
                    String configChange = stringArray[n2];
                    activityNode.addConfigChanges(ActivityNode.getConfigChangeFromName(configChange));
                    ++n2;
                }
            } else if (attrName.equalsIgnoreCase("android:excludeFromRecents")) {
                Boolean excludeFromRecents = Boolean.parseBoolean(attrValue);
                activityNode.setExcludeFromRecents(excludeFromRecents);
            } else if (attrName.equalsIgnoreCase("android:finishOnTaskLaunch")) {
                Boolean finishOnTaskLaunch = Boolean.parseBoolean(attrValue);
                activityNode.setFinishOnTaskLaunch(finishOnTaskLaunch);
            } else if (attrName.equalsIgnoreCase("android:launchMode")) {
                activityNode.setLaunchMode(ActivityNode.getLaunchModeFromName(attrValue));
            } else if (attrName.equalsIgnoreCase("android:multiprocess")) {
                Boolean multiprocess = Boolean.parseBoolean(attrValue);
                activityNode.setMultiprocess(multiprocess);
            } else if (attrName.equalsIgnoreCase("android:screenOrientation")) {
                activityNode.setScreenOrientation(ActivityNode.getScreenOrientationFromName(attrValue));
            } else if (attrName.equalsIgnoreCase("android:stateNotNeeded")) {
                Boolean stateNotNeeded = Boolean.parseBoolean(attrValue);
                activityNode.setStateNotNeeded(stateNotNeeded);
            } else if (attrName.equalsIgnoreCase("android:taskAffinity")) {
                activityNode.setTaskAffinity(attrValue);
            } else if (attrName.equalsIgnoreCase("android:theme")) {
                activityNode.setTheme(attrValue);
            } else {
                activityNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return activityNode;
    }

    protected IntentFilterNode parseIntentFilterNode(NamedNodeMap attributes) {
        IntentFilterNode intentFilterNode = new IntentFilterNode();
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:icon")) {
                intentFilterNode.setIcon(attrValue);
            } else if (attrName.equalsIgnoreCase("android:label")) {
                intentFilterNode.setLabel(attrValue);
            } else if (attrName.equalsIgnoreCase("android:priority")) {
                try {
                    Integer priority = Integer.parseInt(attrValue);
                    intentFilterNode.setPriority(priority);
                }
                catch (NumberFormatException nfe) {
                    String errMsg = NLS.bind((String)UtilitiesNLS.ERR_AndroidManifestNodeParser_ErrorParsingPriority, (Object)attrValue);
                    this.parseErrors.add(errMsg);
                    AndmoreLogger.error(AndroidManifestNodeParser.class, errMsg, (Throwable)nfe);
                }
            } else {
                intentFilterNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return intentFilterNode;
    }

    protected ActionNode parseActionNode(NamedNodeMap attributes) {
        ActionNode actionNode = new ActionNode("");
        this.parseAbstractSimpleNameNode(attributes, actionNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            actionNode.addUnknownProperty(attrName, attrValue);
            ++i;
        }
        return actionNode;
    }

    protected CategoryNode parseCategoryNode(NamedNodeMap attributes) {
        CategoryNode categoryNode = new CategoryNode("");
        this.parseAbstractSimpleNameNode(attributes, categoryNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            categoryNode.addUnknownProperty(attrName, attrValue);
            ++i;
        }
        return categoryNode;
    }

    protected DataNode parseDataNode(NamedNodeMap attributes) {
        DataNode dataNode = new DataNode();
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:host")) {
                dataNode.setHost(attrValue);
            } else if (attrName.equalsIgnoreCase("android:mimeType")) {
                dataNode.setMimeType(attrValue);
            } else if (attrName.equalsIgnoreCase("android:path")) {
                dataNode.setPath(attrValue);
            } else if (attrName.equalsIgnoreCase("android:pathPattern")) {
                dataNode.setPathPattern(attrValue);
            } else if (attrName.equalsIgnoreCase("android:pathPrefix")) {
                dataNode.setPathPrefix(attrValue);
            } else if (attrName.equalsIgnoreCase("android:port")) {
                dataNode.setPort(attrValue);
            } else if (attrName.equalsIgnoreCase("android:scheme")) {
                dataNode.setScheme(attrValue);
            } else {
                dataNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return dataNode;
    }

    protected MetadataNode parseMetadataNode(NamedNodeMap attributes) {
        MetadataNode metadataNode = new MetadataNode("");
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:name")) {
                metadataNode.setName(attrValue);
            } else if (attrName.equalsIgnoreCase("android:resource")) {
                metadataNode.setResource(attrValue);
            } else if (attrName.equals("android:value")) {
                metadataNode.setValue(attrValue);
            } else {
                metadataNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return metadataNode;
    }

    protected ActivityAliasNode parseActivityAliasNode(NamedNodeMap attributes) {
        ActivityAliasNode activityAliasNode = new ActivityAliasNode("", "");
        this.parseAbstractIconLabelNameNode(attributes, activityAliasNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:enabled")) {
                Boolean enabled = Boolean.parseBoolean(attrValue);
                activityAliasNode.setEnabled(enabled);
            } else if (attrName.equalsIgnoreCase("android:exported")) {
                Boolean exported = Boolean.parseBoolean(attrValue);
                activityAliasNode.setExported(exported);
            } else if (attrName.equalsIgnoreCase("android:permission")) {
                activityAliasNode.setPermission(attrValue);
            } else if (attrName.equalsIgnoreCase("android:targetActivity")) {
                activityAliasNode.setTargetActivity(attrValue);
            } else {
                activityAliasNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return activityAliasNode;
    }

    protected ServiceNode parseServiceNode(NamedNodeMap attributes) {
        ServiceNode serviceNode = new ServiceNode("");
        this.parseAbstractBuildingBlockNode(attributes, serviceNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            serviceNode.addUnknownProperty(attrName, attrValue);
            ++i;
        }
        return serviceNode;
    }

    protected ReceiverNode parseReceiverNode(NamedNodeMap attributes) {
        ReceiverNode receiverNode = new ReceiverNode("");
        this.parseAbstractBuildingBlockNode(attributes, receiverNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            receiverNode.addUnknownProperty(attrName, attrValue);
            ++i;
        }
        return receiverNode;
    }

    protected ProviderNode parseProviderNode(NamedNodeMap attributes) {
        ProviderNode providerNode = new ProviderNode("", "");
        this.parseAbstractBuildingBlockNode(attributes, providerNode);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:authorities")) {
                String[] authorities;
                String[] stringArray = authorities = attrValue.split(";");
                int n = authorities.length;
                int n2 = 0;
                while (n2 < n) {
                    String authority = stringArray[n2];
                    providerNode.addAuthority(authority);
                    ++n2;
                }
                providerNode.removeAuthority("");
            } else if (attrName.equalsIgnoreCase("android:grantUriPermissions")) {
                Boolean grantUriPermissions = Boolean.parseBoolean(attrValue);
                providerNode.setGrantUriPermissions(grantUriPermissions);
            } else if (attrName.equalsIgnoreCase("android:initOrder")) {
                try {
                    Integer initOrder = Integer.parseInt(attrValue);
                    providerNode.setInitOrder(initOrder);
                }
                catch (NumberFormatException nfe) {
                    String errMsg = NLS.bind((String)UtilitiesNLS.ERR_AndroidManifestNodeParser_ErrorParsingInitOrder, (Object)attrValue);
                    this.parseErrors.add(errMsg);
                    AndmoreLogger.error(AndroidManifestNodeParser.class, errMsg, (Throwable)nfe);
                }
            } else if (attrName.equalsIgnoreCase("android:multiprocess")) {
                Boolean multiprocess = Boolean.parseBoolean(attrValue);
                providerNode.setMultiprocess(multiprocess);
            } else if (attrName.equalsIgnoreCase("android:readPermission")) {
                providerNode.setReadPermission(attrValue);
            } else if (attrName.equalsIgnoreCase("android:syncable")) {
                Boolean syncable = Boolean.parseBoolean(attrValue);
                providerNode.setSyncable(syncable);
            } else if (attrName.equalsIgnoreCase("android:writePermission")) {
                providerNode.setWritePermission(attrValue);
            } else {
                providerNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return providerNode;
    }

    protected GrantUriPermissionNode parseGrantUriPermissionNode(NamedNodeMap attributes) {
        GrantUriPermissionNode grantUriPermissionNode = new GrantUriPermissionNode();
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:path")) {
                grantUriPermissionNode.setPath(attrValue);
            } else if (attrName.equalsIgnoreCase("android:pathPattern")) {
                grantUriPermissionNode.setPathPattern(attrValue);
            } else if (attrName.equalsIgnoreCase("android:pathPrefix")) {
                grantUriPermissionNode.setPathPrefix(attrValue);
            } else {
                grantUriPermissionNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return grantUriPermissionNode;
    }

    protected UsesLibraryNode parseUsesLibraryNode(NamedNodeMap attributes) {
        UsesLibraryNode usesLibraryNode = new UsesLibraryNode("");
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:name")) {
                usesLibraryNode.setName(attrValue);
            } else if (attrName.equalsIgnoreCase("android:required")) {
                usesLibraryNode.setRequired(Boolean.parseBoolean(attrValue));
            } else {
                usesLibraryNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return usesLibraryNode;
    }

    protected UsesFeatureNode parseUsesFeatureNode(NamedNodeMap attributes) {
        UsesFeatureNode usesFeatureNode = new UsesFeatureNode("");
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:name")) {
                usesFeatureNode.setName(attrValue);
            } else if (attrName.equalsIgnoreCase("android:required")) {
                usesFeatureNode.setRequired(Boolean.parseBoolean(attrValue));
            } else {
                usesFeatureNode.addUnknownProperty(attrName, attrValue);
            }
            ++i;
        }
        return usesFeatureNode;
    }

    protected CommentNode parseCommentNode(Comment comment) {
        CommentNode commentNode = new CommentNode();
        commentNode.setComment(comment.getTextContent());
        return commentNode;
    }

    protected UnknownNode parseUnknownNode(String nodeName, NamedNodeMap attributes) {
        UnknownNode unknownNode = new UnknownNode(nodeName);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            unknownNode.addUnknownProperty(attrName, attrValue);
            ++i;
        }
        return unknownNode;
    }

    private void parseAbstractIconLabelNameNode(NamedNodeMap attributes, AbstractIconLabelNameNode amNode) {
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:icon")) {
                amNode.setIcon(attrValue);
            } else if (attrName.equalsIgnoreCase("android:label")) {
                amNode.setLabel(attrValue);
            } else if (attrName.equalsIgnoreCase("android:name")) {
                amNode.setName(attrValue);
            }
            ++i;
        }
    }

    private void parseAbstractBuildingBlockNode(NamedNodeMap attributes, AbstractBuildingBlockNode amNode) {
        this.parseAbstractIconLabelNameNode(attributes, amNode);
        int i = 0;
        while (i < attributes.getLength()) {
            Boolean boolValue;
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:enabled")) {
                boolValue = Boolean.parseBoolean(attrValue);
                amNode.setEnabled(boolValue);
            } else if (attrName.equalsIgnoreCase("android:exported")) {
                boolValue = Boolean.parseBoolean(attrValue);
                amNode.setExported(boolValue);
            } else if (attrName.equalsIgnoreCase("android:permission")) {
                amNode.setPermission(attrValue);
            } else if (attrName.equalsIgnoreCase("android:process")) {
                amNode.setProcess(attrValue);
            }
            ++i;
        }
    }

    private void parseAbstractSimpleNameNode(NamedNodeMap attributes, AbstractSimpleNameNode amNode) {
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName().trim();
            String attrValue = attributes.item(i).getNodeValue();
            if (attrName.equalsIgnoreCase("android:name")) {
                amNode.setName(attrValue);
            }
            ++i;
        }
    }
}

