/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.elements;

import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FileChooser
extends Composite {
    private final String label;
    private Label fileLabel = null;
    private Text pathWidget = null;
    private Button filesystem = null;
    private Button workspace = null;
    private String[] extensionFilter = null;
    private IContainer container;

    public FileChooser(Composite parent, int style, String label) {
        super(parent, style);
        this.label = label;
        this.setupLayout();
        this.createFields();
    }

    public FileChooser(IContainer container, Composite parent, int style, String label) {
        this(parent, style, label);
        this.container = container;
    }

    private void setupLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
    }

    private void createFields() {
        GridData gridData;
        if (this.label != null) {
            this.fileLabel = new Label((Composite)this, 0);
            this.fileLabel.setText(this.label);
            gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
            this.fileLabel.setLayoutData((Object)gridData);
        }
        this.pathWidget = new Text((Composite)this, 2048);
        gridData = new GridData(4, 0x1000000, true, false, this.label != null ? 1 : 2, 1);
        this.pathWidget.setLayoutData((Object)gridData);
        Composite buttonsComposite = new Composite((Composite)this, 0);
        gridData = new GridData(131072, 0x1000000, true, false, 2, 1);
        buttonsComposite.setLayoutData((Object)gridData);
        buttonsComposite.setLayout((Layout)new RowLayout(256));
        this.filesystem = new Button(buttonsComposite, 8);
        this.filesystem.setLayoutData((Object)new RowData());
        this.filesystem.setText(UtilitiesNLS.UI_FileChooser_Filesystem);
        this.filesystem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(FileChooser.this.getShell(), 4096);
                fileDialog.setFilterExtensions(FileChooser.this.extensionFilter);
                fileDialog.setFilterPath(FileChooser.this.pathWidget.getText());
                String returnedPath = fileDialog.open();
                if (returnedPath != null) {
                    FileChooser.this.pathWidget.setText(returnedPath);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.workspace = new Button(buttonsComposite, 8);
        this.workspace.setLayoutData((Object)new RowData());
        this.workspace.setText(UtilitiesNLS.UI_FileChooser_Workspace);
        this.workspace.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(FileChooser.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(UtilitiesNLS.UI_FileChooser_Dialog_Title);
                dialog.setMessage(UtilitiesNLS.UI_FileChooser_Dialog_Message);
                if (FileChooser.this.container != null) {
                    dialog.setInput((Object)FileChooser.this.container);
                } else {
                    dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                }
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        boolean filtered = false;
                        if (FileChooser.this.extensionFilter != null && element instanceof IFile) {
                            IFile file = (IFile)element;
                            int i = 0;
                            while (i < FileChooser.this.extensionFilter.length && !filtered) {
                                String fileExtensionToShow = FileChooser.this.extensionFilter[i].substring(FileChooser.this.extensionFilter[i].lastIndexOf(".") + 1);
                                String fileExtension = file.getFileExtension();
                                if (fileExtension != null && !fileExtension.equals(fileExtensionToShow)) {
                                    filtered = true;
                                }
                                ++i;
                            }
                        }
                        return !filtered;
                    }
                });
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        Status valid = new Status(4, "org.eclipse.andmore.android.common", "");
                        if (selection.length == 1 && selection[0] instanceof IFile) {
                            valid = new Status(0, "org.eclipse.andmore.android.common", "");
                        }
                        return valid;
                    }
                });
                if (dialog.open() == 0) {
                    IResource resource = (IResource)dialog.getFirstResult();
                    FileChooser.this.pathWidget.setText(resource.getLocation().toOSString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.fileLabel != null) {
            this.fileLabel.setEnabled(enabled);
        }
        this.workspace.setEnabled(enabled);
        this.filesystem.setEnabled(enabled);
        this.pathWidget.setEnabled(enabled);
    }

    public String getText() {
        return this.pathWidget.getText();
    }

    public void setFilterExtensions(String[] filter) {
        this.extensionFilter = filter;
    }

    public void setText(String text) {
        this.pathWidget.setText(text);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.pathWidget.addModifyListener(modifyListener);
    }

    public void setContainer(IContainer container) {
        this.container = container;
    }
}

