/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest.dom;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.andmore.android.model.manifest.dom.AbstractIconLabelNameNode;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.IntentFilterNode;
import org.eclipse.andmore.android.model.manifest.dom.MetadataNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

public class ActivityAliasNode
extends AbstractIconLabelNameNode {
    private Boolean propEnabled = null;
    private Boolean propExported = null;
    private String propPermission = null;
    private String propTargetActivity = null;

    static {
        defaultProperties.add("android:enabled");
        defaultProperties.add("android:exported");
        defaultProperties.add("android:permission");
        defaultProperties.add("android:targetActivity");
    }

    public ActivityAliasNode(String name, String targetActivity) {
        super(name);
        Assert.isLegal((targetActivity != null ? 1 : 0) != 0);
        this.propTargetActivity = targetActivity;
    }

    @Override
    protected boolean canContains(AndroidManifestNode.NodeType nodeType) {
        return nodeType == AndroidManifestNode.NodeType.IntentFilter || nodeType == AndroidManifestNode.NodeType.MetaData || nodeType == AndroidManifestNode.NodeType.Comment;
    }

    @Override
    protected void addAdditionalProperties() {
        this.properties.put("android:targetActivity", this.propTargetActivity);
        if (this.propEnabled != null) {
            this.properties.put("android:enabled", this.propEnabled.toString());
        }
        if (this.propExported != null) {
            this.properties.put("android:exported", this.propExported.toString());
        }
        if (this.propPermission != null) {
            this.properties.put("android:permission", this.propPermission);
        }
    }

    @Override
    public AndroidManifestNode.NodeType getNodeType() {
        return AndroidManifestNode.NodeType.ActivityAlias;
    }

    @Override
    protected boolean isNodeValid() {
        return super.isNodeValid() && this.propTargetActivity.trim().length() > 0;
    }

    public Boolean getEnabled() {
        return this.propEnabled;
    }

    public void setEnabled(Boolean enabled) {
        this.propEnabled = enabled;
    }

    public Boolean getExported() {
        return this.propExported;
    }

    public void setExported(Boolean exported) {
        this.propExported = exported;
    }

    public String getPermission() {
        return this.propPermission;
    }

    public void setPermission(String permission) {
        this.propPermission = permission;
    }

    public String getTargetActivity() {
        return this.propTargetActivity;
    }

    public void setTargetActivity(String targetActivity) {
        Assert.isLegal((targetActivity != null ? 1 : 0) != 0);
        this.propTargetActivity = targetActivity;
    }

    public void addIntentFilterNode(IntentFilterNode intentFilter) {
        if (intentFilter != null && !this.children.contains(intentFilter)) {
            this.children.add(intentFilter);
        }
    }

    public List<IntentFilterNode> getIntentFilterNodes() {
        LinkedList<IntentFilterNode> intentFilters = new LinkedList<IntentFilterNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.IntentFilter);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            intentFilters.add((IntentFilterNode)node);
            ++n2;
        }
        return intentFilters;
    }

    public void removeIntentFilterNode(IntentFilterNode intentFilter) {
        if (intentFilter != null) {
            this.children.remove(intentFilter);
        }
    }

    public void addMetadataNode(MetadataNode metadata) {
        if (metadata != null && !this.children.contains(metadata)) {
            this.children.add(metadata);
        }
    }

    public List<MetadataNode> getMetadataNodes() {
        LinkedList<MetadataNode> metadatas = new LinkedList<MetadataNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.MetaData);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            metadatas.add((MetadataNode)node);
            ++n2;
        }
        return metadatas;
    }

    public void removeMetadataNode(MetadataNode metadata) {
        if (metadata != null) {
            this.children.remove(metadata);
        }
    }

    @Override
    protected List<IStatus> getSpecificNodeProblems() {
        return null;
    }
}

