/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.wizards.createdb;

import java.util.List;
import org.eclipse.andmore.android.db.core.DbCoreActivator;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.TableModel;
import org.eclipse.andmore.android.db.core.ui.wizards.createdb.CreateDatabaseWizardPage;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CreateDatabaseWizard
extends Wizard {
    private static final String WIZBAN_ICON = "icons/wizban/create_database_ban.png";
    private static final String DB_PERSPECTIVE = "org.eclipse.andmore.android.db.perspective";
    private static final String SWITCH_ANDMORE_DATABASE_PERSPECTIVE = "switch.perspective.to.andmore.database";
    private final List<String> alreadyAvailableDbs;
    private CreateDatabaseWizardPage createDatabaseWizardPage;
    private String dbName;
    private List<TableModel> tables;

    public CreateDatabaseWizard(List<String> alreadyAvailableDbs) {
        this.alreadyAvailableDbs = alreadyAvailableDbs;
        this.setWindowTitle(DbCoreNLS.CreateDatabaseWizardPage_UI_PageTitle);
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.db.core", (String)WIZBAN_ICON));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.createDatabaseWizardPage = new CreateDatabaseWizardPage(this.alreadyAvailableDbs);
        this.addPage((IWizardPage)this.createDatabaseWizardPage);
    }

    public boolean performFinish() {
        boolean canProceed;
        this.dbName = this.createDatabaseWizardPage.getDatabaseName();
        this.tables = this.createDatabaseWizardPage.getTables();
        boolean bl = canProceed = this.dbName != null && !"".equals(this.dbName);
        if (canProceed) {
            this.changePerspective();
        }
        return canProceed;
    }

    public String getDbName() {
        return this.dbName;
    }

    public List<TableModel> getTables() {
        return this.tables;
    }

    private boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor perspective) {
        MessageDialogWithToggle dialog;
        int dialogResult;
        IPreferenceStore store = DbCoreActivator.getDefault().getPreferenceStore();
        String preference = store.getString(SWITCH_ANDMORE_DATABASE_PERSPECTIVE);
        if (preference.equals("")) {
            store.setValue(SWITCH_ANDMORE_DATABASE_PERSPECTIVE, "prompt");
            preference = "prompt";
        }
        boolean result = "always".equals(preference) ? true : ("never".equals(preference) ? false : (dialogResult = (dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)DbCoreNLS.UI_CreateDatabaseWizard_ChangePerspectiveTitle, (String)DbCoreNLS.UI_CreateDatabaseWizard_ChangePerspectiveQuestion, null, (boolean)false, (IPreferenceStore)store, (String)SWITCH_ANDMORE_DATABASE_PERSPECTIVE)).getReturnCode()) == 2);
        return result;
    }

    private void changePerspective() {
        boolean changePerspective;
        IPerspectiveDescriptor currentPersp;
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor perspective = reg.findPerspectiveWithId(DB_PERSPECTIVE);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (currentPersp = page.getPerspective()) != null && !DB_PERSPECTIVE.contains(currentPersp.getId()) && (changePerspective = this.confirmPerspectiveSwitch(window, perspective))) {
            page.setPerspective(perspective);
        }
    }
}

