/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.devices.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.android.AndmoreEventManager;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.DdmsRunnable;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.db.core.CanRefreshStatus;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.ISaveStateTreeNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.view.SaveStateManager;
import org.eclipse.andmore.android.db.devices.i18n.DbDevicesNLS;
import org.eclipse.andmore.android.db.devices.model.ApplicationNode;
import org.eclipse.andmore.android.db.devices.model.ExtStorageNode;
import org.eclipse.andmore.android.db.devices.model.IDeviceNode;
import org.eclipse.andmore.android.db.devices.utils.DeviceDbUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class DeviceNode
extends AbstractTreeNode
implements IDeviceNode,
ISaveStateTreeNode {
    private static final String MEMENTO_FILTER_TYPE = "filterAppsWithDb";
    private static final String MEMENTO_FILTER_KEY = "filterEnabled";
    private static final String ICON_PATH = "icons/obj16/device.png";
    private String serialNumber;
    private boolean filterAppsWithDb;
    private String deviceName;
    private final PackageChangedListener listener = new PackageChangedListener(this);

    private DeviceNode() {
    }

    public DeviceNode(String serialNumber, ITreeNode parent) {
        super(serialNumber, DDMSFacade.getNameBySerialNumber((String)serialNumber), parent);
        this.serialNumber = serialNumber;
        this.deviceName = this.getName();
        ImageDescriptor icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.db.devices", (String)ICON_PATH);
        this.setIcon(icon);
        AndmoreEventManager.addEventListener((AndmoreEventManager.EventType)AndmoreEventManager.EventType.PACKAGE_INSTALLED, (DdmsRunnable)this.listener);
        AndmoreEventManager.addEventListener((AndmoreEventManager.EventType)AndmoreEventManager.EventType.PACKAGE_UNINSTALLED, (DdmsRunnable)this.listener);
    }

    public IStatus canRefresh() {
        ArrayList<IStatus> childrenStatus = new ArrayList<IStatus>(this.getChildren().size());
        String message = NLS.bind((String)DbDevicesNLS.DeviceNode_Cant_Refresh_Node, (Object)this.getName());
        for (ITreeNode treeNode : this.getChildren()) {
            IStatus nodecanRefresh = treeNode.canRefresh();
            if (nodecanRefresh.isOK()) continue;
            childrenStatus.add(nodecanRefresh);
            message = nodecanRefresh.getMessage();
            break;
        }
        IStatus status = null;
        if (!childrenStatus.isEmpty()) {
            status = new CanRefreshStatus(16, "org.eclipse.andmore.android.db.devices", childrenStatus.toArray(new IStatus[0]), message);
        }
        return status != null ? status : Status.OK_STATUS;
    }

    public void refresh() {
        this.clear();
        Status status = null;
        Set loadedApps = null;
        Map listInstalledPackages = null;
        Integer totalFiltered = 0;
        try {
            Object[] installedPackagesContainer = DeviceDbUtils.listInstalledPackages(this.serialNumber, this.mustFilterAppsWithDb());
            listInstalledPackages = (Map)installedPackagesContainer[0];
            totalFiltered = (Integer)installedPackagesContainer[1];
        }
        catch (IOException iOException) {
            status = new Status(4, "org.eclipse.andmore.android.db.devices", NLS.bind((String)DbDevicesNLS.DeviceNode_CouldNotLoadInstalledApps, (Object)this.deviceName));
        }
        if (listInstalledPackages != null) {
            loadedApps = listInstalledPackages.keySet();
        }
        ArrayList<AbstractTreeNode> childNodes = new ArrayList<AbstractTreeNode>(loadedApps != null ? loadedApps.size() + 1 : 1);
        try {
            if (DDMSFacade.hasSDCard((String)this.serialNumber)) {
                ExtStorageNode extStorageNode = new ExtStorageNode(this);
                childNodes.add(extStorageNode);
            }
        }
        catch (IOException iOException) {
            status = new Status(4, "org.eclipse.andmore.android.db.devices", NLS.bind((String)DbDevicesNLS.DeviceNode_CouldNotVerifySdCard, (Object)this.deviceName));
        }
        if (loadedApps != null) {
            for (String app : loadedApps) {
                if (!JavaConventions.validatePackageName((String)app, (String)"1.5", (String)"1.5").isOK()) continue;
                ApplicationNode appNode = new ApplicationNode(app, this);
                childNodes.add(appNode);
            }
            if (!childNodes.isEmpty()) {
                this.putChildren(childNodes);
            }
        }
        this.updateName(totalFiltered);
        this.setNodeStatus((IStatus)(status != null ? status : Status.OK_STATUS));
    }

    private void updateName(Integer totalFiltered) {
        if (this.mustFilterAppsWithDb() && totalFiltered > 0 && !this.getChildren().isEmpty()) {
            this.setName(String.valueOf(this.deviceName) + NLS.bind((String)DbDevicesNLS.DeviceNode_X_Apps_Filtered, (Object)totalFiltered));
        } else {
            this.setName(this.deviceName);
        }
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean mustFilterAppsWithDb() {
        return this.filterAppsWithDb;
    }

    @Override
    public void setFilterAppWithDb(boolean filterAppWithDb) {
        this.filterAppsWithDb = filterAppWithDb;
        this.saveState(SaveStateManager.getInstance().getPrefNode());
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void saveState(IEclipsePreferences preferences) {
        String id = this.deviceName != null ? this.deviceName : this.getName();
        Preferences filterNode = preferences.node(MEMENTO_FILTER_TYPE);
        Preferences deviceNode = filterNode.node(id);
        deviceNode.putBoolean(MEMENTO_FILTER_KEY, this.mustFilterAppsWithDb());
    }

    public void restoreState(IEclipsePreferences preferences) {
        boolean filterDbApps = true;
        String deviceName = this.deviceName != null ? this.deviceName : this.getName();
        try {
            Preferences filterNode;
            if (preferences.nodeExists(MEMENTO_FILTER_TYPE) && (filterNode = preferences.node(MEMENTO_FILTER_TYPE)).nodeExists(deviceName)) {
                Preferences deviceNode = filterNode.node(deviceName);
                filterDbApps = deviceNode.getBoolean(MEMENTO_FILTER_KEY, true);
            }
        }
        catch (BackingStoreException e) {
            AndmoreLogger.error((String)"Could not contact backing store: ", (String)e.getMessage());
        }
        this.setFilterAppWithDb(filterDbApps);
    }

    public void cleanUp() {
        super.cleanUp();
        AndmoreEventManager.removeEventListener((AndmoreEventManager.EventType)AndmoreEventManager.EventType.PACKAGE_INSTALLED, (DdmsRunnable)this.listener);
        AndmoreEventManager.removeEventListener((AndmoreEventManager.EventType)AndmoreEventManager.EventType.PACKAGE_UNINSTALLED, (DdmsRunnable)this.listener);
    }

    private static class PackageChangedListener
    implements DdmsRunnable {
        private final DeviceNode deviceNode;

        public PackageChangedListener(DeviceNode deviceNode) {
            this.deviceNode = deviceNode;
        }

        public void run(final String serialNumber) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Status status = null;
                    Map listInstalledPackages = null;
                    try {
                        Object[] installedPackagesContainer = DeviceDbUtils.listInstalledPackages(serialNumber, PackageChangedListener.this.deviceNode.mustFilterAppsWithDb());
                        listInstalledPackages = (Map)installedPackagesContainer[0];
                        Integer totalFiltered = (Integer)installedPackagesContainer[1];
                        List childNodes = PackageChangedListener.this.deviceNode.getChildren();
                        ArrayList<ITreeNode> toRemoveNodes = new ArrayList<ITreeNode>();
                        HashSet newApplications = new HashSet();
                        newApplications.addAll(listInstalledPackages.keySet());
                        if (childNodes != null) {
                            for (ITreeNode node : childNodes) {
                                if (!(node instanceof ApplicationNode)) continue;
                                ApplicationNode appNode = (ApplicationNode)node;
                                if (!listInstalledPackages.containsKey(appNode.getId())) {
                                    toRemoveNodes.add(node);
                                    continue;
                                }
                                newApplications.remove(appNode.getId());
                            }
                            for (String newApp : newApplications) {
                                ApplicationNode appNode = new ApplicationNode(newApp, PackageChangedListener.this.deviceNode);
                                PackageChangedListener.this.deviceNode.putChild((ITreeNode)appNode);
                            }
                            for (ITreeNode node : toRemoveNodes) {
                                PackageChangedListener.this.deviceNode.removeChild(node);
                            }
                            PackageChangedListener.this.deviceNode.updateName(totalFiltered);
                        }
                    }
                    catch (IOException iOException) {
                        status = new Status(4, "org.eclipse.andmore.android.db.devices", NLS.bind((String)DbDevicesNLS.DeviceNode_CouldNotLoadInstalledApps, (Object)PackageChangedListener.this.deviceNode.getName()));
                    }
                    PackageChangedListener.this.deviceNode.setNodeStatus((IStatus)(status != null ? status : Status.OK_STATUS));
                }
            });
            thread.start();
        }
    }
}

