/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.devices.ui.action;

import org.eclipse.andmore.android.db.core.ui.IDbMapperNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.devices.i18n.DbDevicesNLS;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MapDeviceDatabaseHandler
extends AbstractHandler
implements IHandler {
    private IDbMapperNode dbMapperNode;

    public MapDeviceDatabaseHandler() {
    }

    public MapDeviceDatabaseHandler(ITreeNode node) {
        if (node instanceof IDbMapperNode) {
            this.dbMapperNode = (IDbMapperNode)node;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.dbMapperNode != null) {
            Shell shell = Display.getCurrent().getActiveShell();
            InputDialog dialog = new InputDialog(shell, DbDevicesNLS.UI_MapDatabaseAction_QueryDbPath_DialogTitle, DbDevicesNLS.UI_MapDatabaseAction_QueryDbPath_DialogMessage, "", new IInputValidator(){

                public String isValid(String newText) {
                    String errorMsg = null;
                    boolean isValid = false;
                    if (newText.startsWith("/sdcard/") && newText.length() > "/sdcard/".length()) {
                        isValid = true;
                    }
                    if (!isValid && newText.startsWith("/mnt/sdcard/") && newText.length() > "/mnt/sdcard/".length()) {
                        isValid = true;
                    }
                    if (!isValid) {
                        errorMsg = DbDevicesNLS.MapDatabaseAction_Error_WrongDatabasePlace;
                    }
                    return errorMsg;
                }
            });
            dialog.setBlockOnOpen(true);
            int result = dialog.open();
            String dbPath = null;
            if (result == 0) {
                dbPath = dialog.getValue();
            }
            if (dbPath != null) {
                this.dbMapperNode.map((IPath)new Path(dbPath));
            }
        }
        return null;
    }
}

