/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.core.utils;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.andmore.android.emulator.core.devfrm.DeviceFrameworkManager;
import org.eclipse.andmore.android.emulator.core.exception.InstanceNotFoundException;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.model.IEmulatorView;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EmulatorCoreUtils {
    public static Collection<IEmulatorView> getAllAndroidViews() {
        final HashSet<IEmulatorView> allViews = new HashSet<IEmulatorView>();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage[] activePages;
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null && (activePages = activeWindow.getPages()) != null) {
                    IWorkbenchPage[] iWorkbenchPageArray = activePages;
                    int n = activePages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchPage activePage = iWorkbenchPageArray[n2];
                        if (activePage != null) {
                            IViewReference[] allReferences;
                            IViewReference[] iViewReferenceArray = allReferences = activePage.getViewReferences();
                            int n3 = allReferences.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IViewReference ref = iViewReferenceArray[n4];
                                IViewPart aView = ref.getView(false);
                                if (aView != null && aView instanceof IEmulatorView) {
                                    allViews.add((IEmulatorView)aView);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
            }
        });
        return allViews;
    }

    public static void refreshEmulatorViews() {
        Collection<IEmulatorView> allViews = EmulatorCoreUtils.getAllAndroidViews();
        for (IEmulatorView view : allViews) {
            view.refreshView();
        }
    }

    public static IAndroidEmulatorInstance getAndroidInstanceByIdentifier(String identifier) throws InstanceNotFoundException {
        IAndroidEmulatorInstance desiredDevice = null;
        Collection<IAndroidEmulatorInstance> instanceList = DeviceFrameworkManager.getInstance().getAllInstances();
        for (IAndroidEmulatorInstance instance : instanceList) {
            String instanceIdentifier = instance.getInstanceIdentifier();
            if (instanceIdentifier == null || !instanceIdentifier.equals(identifier)) continue;
            desiredDevice = instance;
            break;
        }
        if (desiredDevice == null) {
            throw new InstanceNotFoundException();
        }
        return desiredDevice;
    }

    public static IAndroidEmulatorInstance getAndroidInstanceByHandle(ProtocolHandle handle) throws InstanceNotFoundException {
        IAndroidEmulatorInstance desiredDevice = null;
        Collection<IAndroidEmulatorInstance> instanceList = DeviceFrameworkManager.getInstance().getAllInstances();
        for (IAndroidEmulatorInstance instance : instanceList) {
            ProtocolHandle instanceHandle = instance.getProtocolHandle();
            if (instanceHandle == null || !instanceHandle.equals(handle)) continue;
            desiredDevice = instance;
            break;
        }
        if (desiredDevice == null) {
            throw new InstanceNotFoundException();
        }
        return desiredDevice;
    }
}

