/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.core.utils;

import java.util.Properties;
import org.eclipse.andmore.android.emulator.core.model.AbstractInputLogic;
import org.eclipse.sequoyah.vnc.protocol.PluginProtocolActionDelegate;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolMessage;

public class VncAndroidInput
extends AbstractInputLogic {
    private static final int VNC_KEYEVENT_MESSAGE_CODE = 4;
    private static final int VNC_POINTEREVENT_MESSAGE_CODE = 5;
    private boolean buttonPressed;

    private void sendAndroidMouseEventMessage(int x, int y) {
        ProtocolMessage message = new ProtocolMessage(5L);
        message.setFieldValue("buttonMask", (Object)(this.buttonPressed ? 1 : 0));
        message.setFieldValue("x-position", (Object)x);
        message.setFieldValue("y-position", (Object)y);
        try {
            PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.getInstance().getProtocolHandle(), (ProtocolMessage)message);
        }
        catch (Exception exception) {}
    }

    @Override
    public void sendKey(int character, int keycode, Properties keyCodeMap) {
        ProtocolMessage message = new ProtocolMessage(4L);
        message.setFieldValue("padding", (Object)0);
        message.setFieldValue("downFlag", (Object)1);
        message.setFieldValue("key", (Object)keycode);
        try {
            PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.getInstance().getProtocolHandle(), (ProtocolMessage)message);
        }
        catch (Exception exception) {}
    }

    @Override
    public void sendClick(int code, boolean pressed) {
    }

    @Override
    public void sendClick(String code, boolean pressed) {
    }

    @Override
    public void sendMouseDown(int x, int y) {
        this.buttonPressed = true;
        this.sendAndroidMouseEventMessage(x, y);
    }

    @Override
    public void sendMouseMove(int x, int y) {
        this.sendAndroidMouseEventMessage(x, y);
    }

    @Override
    public void sendMouseUp(int x, int y) {
        this.buttonPressed = false;
        this.sendAndroidMouseEventMessage(x, y);
    }
}

