/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.preferences.DialogWithToggleUtils;
import org.eclipse.andmore.android.emulator.device.handlers.OpenNewDeviceWizardHandler;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IStartup;

public class CreateAVDOnStartupListener
implements IStartup {
    private static final String SDK_CREATE_NEW_AVD_KEY = "create.avd.on.startup";
    private static final Lock lock = new ReentrantReadWriteLock().writeLock();
    private static boolean executed = false;

    public void earlyStartup() {
        AndroidPlugin.getDefault().addSDKLoaderListener(new Runnable(){

            @Override
            public void run() {
                lock.lock();
                if (!executed && SdkUtils.getAllTargets() != null && SdkUtils.getAllTargets().length > 0 && SdkUtils.getAllValidVms() != null && SdkUtils.getAllValidVms().length == 0) {
                    if (DialogWithToggleUtils.showQuestion((String)CreateAVDOnStartupListener.SDK_CREATE_NEW_AVD_KEY, (String)EmulatorNLS.UI_SdkSetup_CreateAVD_Title, (String)EmulatorNLS.UI_SdkSetup_CreateAVD_Message)) {
                        OpenNewDeviceWizardHandler handler = new OpenNewDeviceWizardHandler();
                        try {
                            handler.execute(new ExecutionEvent());
                        }
                        catch (ExecutionException executionException) {
                            lock.unlock();
                        }
                    }
                    executed = true;
                }
                lock.unlock();
            }
        });
    }
}

