/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.ui;

import java.util.Properties;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.core.skin.SkinFramework;
import org.eclipse.andmore.android.emulator.device.IDevicePropertiesConstants;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDeviceInstance;
import org.eclipse.andmore.android.emulator.device.instance.options.StartupOptionsMgt;
import org.eclipse.andmore.android.emulator.device.ui.AbstractPropertiesComposite;
import org.eclipse.andmore.android.emulator.device.ui.StartupOptionsComposite;
import org.eclipse.andmore.android.nativeos.NativeUIUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class AndroidPropertiesStartupOptionsPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IDevicePropertiesConstants {
    private AndroidDeviceInstance emuInstance;
    private StartupOptionsComposite startupOptionsComposite;
    private boolean defaultMessageNeedsReset = false;
    private final String defaultMessage = this.getMessage();
    private final AbstractPropertiesComposite.PropertyCompositeChangeListener compositeChangeListener = new AbstractPropertiesComposite.PropertyCompositeChangeListener(){

        @Override
        public void compositeChanged(AbstractPropertiesComposite.PropertyCompositeChangeEvent e) {
            String errorMessage = AndroidPropertiesStartupOptionsPage.this.startupOptionsComposite.getErrorMessage();
            AndroidPropertiesStartupOptionsPage.this.setErrorMessage(errorMessage);
            AndroidPropertiesStartupOptionsPage.this.setValid(errorMessage == null && AndroidPropertiesStartupOptionsPage.this.getMessage() == null);
            if (AndroidPropertiesStartupOptionsPage.this.defaultMessageNeedsReset) {
                AndroidPropertiesStartupOptionsPage.this.defaultMessageNeedsReset = false;
                AndroidPropertiesStartupOptionsPage.this.setMessage(AndroidPropertiesStartupOptionsPage.this.defaultMessage);
            }
        }
    };

    protected Control createContents(Composite parent) {
        SkinFramework sm = new SkinFramework();
        IAndroidSkin skin = null;
        boolean canCalculateScale = true;
        try {
            skin = sm.getSkinById(this.emuInstance.getSkinId(), this.emuInstance.getSkinPath());
        }
        catch (SkinException e) {
            AndmoreLogger.error(this.getClass(), (String)"Error reading instance skin during startup options page creation", (Throwable)((Object)e));
            canCalculateScale = false;
        }
        this.startupOptionsComposite = new StartupOptionsComposite(parent, this.emuInstance.getCommandLineArguments(), skin, canCalculateScale);
        this.startupOptionsComposite.setLayoutData(new GridData(4, 4, true, true));
        AbstractPropertiesComposite.addCompositeChangeListener(this.compositeChangeListener);
        String errorMessage = this.startupOptionsComposite.getErrorMessage();
        this.setValid(errorMessage == null);
        if (errorMessage != null) {
            this.defaultMessageNeedsReset = true;
            this.setMessage(errorMessage, 1);
        }
        return this.startupOptionsComposite;
    }

    public void setElement(IAdaptable element) {
        if (element instanceof AndroidDeviceInstance) {
            this.emuInstance = (AndroidDeviceInstance)element;
        }
        super.setElement(element);
    }

    public boolean performOk() {
        this.save();
        return super.performOk();
    }

    protected void performApply() {
        this.save();
        super.performApply();
    }

    private void save() {
        if (this.emuInstance != null) {
            Properties emuProperties = this.emuInstance.getProperties();
            emuProperties.setProperty("Command_Line", StartupOptionsMgt.getParamList());
            this.emuInstance.setProperties(emuProperties);
            InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_UPDATED, (IInstance)this.emuInstance));
        }
    }

    protected void performDefaults() {
        this.startupOptionsComposite.reloadValues(NativeUIUtils.getDefaultCommandLine());
        super.performDefaults();
    }

    public void dispose() {
        AbstractPropertiesComposite.removeCompositeChangeListener(this.compositeChangeListener);
        this.startupOptionsComposite.dispose();
        this.startupOptionsComposite = null;
        super.dispose();
    }
}

