/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.ui;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.device.IDevicePropertiesConstants;
import org.eclipse.andmore.android.emulator.device.definition.AndroidEmuDefMgr;
import org.eclipse.andmore.android.emulator.device.ui.AbstractPropertiesComposite;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

public class PropertiesMainComposite
extends AbstractPropertiesComposite {
    private static final String ORG_ECLIPSE_UI_NET_NET_PREFERENCES = "org.eclipse.ui.net.NetPreferences";
    private final AndroidEmuDefMgr emuDefMgr = AndroidEmuDefMgr.getInstance();
    private String name = "";
    private String skinId = "";
    private String timeout = "";
    private boolean useVnc;
    private boolean useProxy;
    private boolean useSnapshots;
    private IAndroidTarget vmTarget = null;
    private String vmSkin = "";
    private String sdCardType = "";
    private String sdCardValue = "";
    private String vmPath = "";
    private boolean usingDefaultVmPath;
    private String abiType = "";
    private static final String SDCARD_TYPE_NONE = "NONE";
    private static final String SDCARD_TYPE_PATH = "PATH";
    private static final String SDCARD_TYPE_SIZE = "SIZE";
    private static final String SDCARD_PATH_EXTENSION = ".img";
    private static final String[] SDCARD_SIZE_UNITS = new String[]{"KB", "MB"};
    private Button saveSnapshotButton;
    private Button startFromSnapshotButton;
    private boolean saveSnapshots;
    private boolean startFromSnapshots;
    private Combo abiTypeCombo;

    public PropertiesMainComposite(Composite parent, String name, String emulatorDefId, String timeout, boolean useVnc, boolean useProxy, boolean useSnapshot, boolean saveSnapshot, boolean startFromSnapshot, IAndroidTarget vmTarget, String vmSkin, String vmPath, String abiType, boolean showName, boolean areVmSettingsEditable, boolean areOtherFieldsEditable) {
        super(parent);
        this.name = name;
        this.timeout = timeout;
        this.useVnc = useVnc;
        this.useProxy = useProxy;
        this.abiType = abiType;
        this.skinId = this.emuDefMgr.getSkinId(emulatorDefId);
        this.vmTarget = vmTarget;
        this.vmSkin = vmSkin;
        this.vmPath = vmPath;
        this.useSnapshots = useSnapshot;
        this.saveSnapshots = saveSnapshot;
        this.startFromSnapshots = startFromSnapshot;
        this.createUI(showName, areVmSettingsEditable, areOtherFieldsEditable);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.emulator.newdevmain");
    }

    public PropertiesMainComposite(Composite parent, String emulatorDefId, String timeout, boolean useVnc, boolean useProxy, boolean useSnapshot, boolean saveSnapshot, boolean startFromSnapshot, IAndroidTarget vmTarget, String vmSkin, String vmPath, String abiType) {
        this(parent, "", emulatorDefId, timeout, useVnc, useProxy, useSnapshot, saveSnapshot, startFromSnapshot, vmTarget, vmSkin, vmPath, abiType, false, true, true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.emulator.newdevmain");
    }

    private void createUI(boolean showName, boolean areVmSettingsEditable, boolean areOtherFieldsEditable) {
        GridData data;
        PropertiesMainComposite mainComposite = this;
        HashSet<Control> otherFields = new HashSet<Control>();
        this.setMainLayout(2);
        if (showName) {
            Label nameLabel = new Label((Composite)mainComposite, 8);
            nameLabel.setText(EmulatorNLS.UI_PropertiesMainComposite_NameLabel);
            data = new GridData(16384, 0x1000000, false, false);
            nameLabel.setLayoutData((Object)data);
            Text nameTextLabel = new Text((Composite)mainComposite, 72);
            nameTextLabel.setText(this.name);
            data = new GridData(4, 0, true, false);
            nameTextLabel.setLayoutData((Object)data);
        }
        if (areVmSettingsEditable) {
            this.createEditableVmUI();
        } else {
            this.createNotEditableVmUI();
        }
        Group proxyGroup = new Group((Composite)mainComposite, 8);
        proxyGroup.setText(EmulatorNLS.PropertiesMainComposite_ProxySettings_GroupTitle);
        data = new GridData(4, 4, true, false, 2, 1);
        proxyGroup.setLayoutData((Object)data);
        proxyGroup.setLayout((Layout)new GridLayout(3, false));
        final Button proxyChkbox = new Button((Composite)proxyGroup, 32);
        proxyChkbox.setText(EmulatorNLS.PropertiesMainComposite_ProxySettings_CheckboxLabel);
        data = new GridData(4, 4, true, false, 3, 1);
        proxyChkbox.setSelection(this.useProxy);
        proxyChkbox.setLayoutData((Object)data);
        proxyChkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesMainComposite.this.useProxy = proxyChkbox.getSelection();
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        Link networkSettings = new Link((Composite)proxyGroup, 0);
        networkSettings.setText(EmulatorNLS.PropertiesMainComposite_ProxySettings_LinkToPreference);
        data = new GridData(16384, 0x1000000, false, false, 3, 1);
        networkSettings.setLayoutData((Object)data);
        networkSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesMainComposite.this.openNetworkPreferences();
            }
        });
        Group snapshotGroup = new Group((Composite)mainComposite, 8);
        snapshotGroup.setText(EmulatorNLS.PropertiesMainComposite_SnapshotSettings);
        data = new GridData(4, 4, true, false, 2, 1);
        snapshotGroup.setLayoutData((Object)data);
        snapshotGroup.setLayout((Layout)new GridLayout(3, false));
        final Button enableSnapshotButton = new Button((Composite)snapshotGroup, 32);
        enableSnapshotButton.setText(EmulatorNLS.PropertiesMainComposite_UseSnapshot);
        data = new GridData(4, 4, true, false, 3, 1);
        enableSnapshotButton.setLayoutData((Object)data);
        enableSnapshotButton.setEnabled(areVmSettingsEditable);
        enableSnapshotButton.setSelection(this.useSnapshots);
        enableSnapshotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesMainComposite.this.useSnapshots = enableSnapshotButton.getSelection();
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
                PropertiesMainComposite.this.startFromSnapshotButton.setEnabled(PropertiesMainComposite.this.useSnapshots);
                PropertiesMainComposite.this.saveSnapshotButton.setEnabled(PropertiesMainComposite.this.useSnapshots);
            }
        });
        this.startFromSnapshotButton = new Button((Composite)snapshotGroup, 32);
        this.startFromSnapshotButton.setText(EmulatorNLS.PropertiesMainComposite_startFromSnapshot);
        data = new GridData(4, 4, true, false, 3, 1);
        this.startFromSnapshotButton.setLayoutData((Object)data);
        this.startFromSnapshotButton.setEnabled(this.useSnapshots);
        this.startFromSnapshotButton.setSelection(this.startFromSnapshots);
        this.startFromSnapshotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesMainComposite.this.startFromSnapshots = PropertiesMainComposite.this.startFromSnapshotButton.getSelection();
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        this.saveSnapshotButton = new Button((Composite)snapshotGroup, 32);
        this.saveSnapshotButton.setText(EmulatorNLS.PropertiesMainComposite_SaveSnapshot);
        data = new GridData(4, 4, true, false, 3, 1);
        this.saveSnapshotButton.setLayoutData((Object)data);
        this.saveSnapshotButton.setEnabled(this.useSnapshots);
        this.saveSnapshotButton.setSelection(this.saveSnapshots);
        this.saveSnapshotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesMainComposite.this.saveSnapshots = PropertiesMainComposite.this.saveSnapshotButton.getSelection();
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        otherFields.add((Control)proxyGroup);
        otherFields.add((Control)proxyChkbox);
        otherFields.add((Control)networkSettings);
        otherFields.add((Control)snapshotGroup);
        if (!Platform.getOS().equals("macosx")) {
            Group windowGroup = new Group((Composite)mainComposite, 8);
            windowGroup.setText(EmulatorNLS.UI_PropertiesMainComposite_EmulatorWindowMode_GroupTitle);
            data = new GridData(4, 4, true, false, 2, 1);
            windowGroup.setLayoutData((Object)data);
            windowGroup.setLayout((Layout)new GridLayout(3, false));
            final Button nativeRadio = new Button((Composite)windowGroup, 16);
            nativeRadio.setText(EmulatorNLS.UI_PropertiesMainComposite_EmulatorWindowMode_NativeLabel);
            nativeRadio.setSelection(!this.useVnc);
            data = new GridData(4, 4, true, false, 3, 1);
            nativeRadio.setLayoutData((Object)data);
            nativeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PropertiesMainComposite.this.useVnc = !nativeRadio.getSelection();
                    PropertiesMainComposite.this.notifyCompositeChangeListeners();
                }
            });
            Button vncRadio = new Button((Composite)windowGroup, 16);
            vncRadio.setText(EmulatorNLS.UI_PropertiesMainComposite_EmulatorWindowMode_VncLabel);
            vncRadio.setSelection(this.useVnc);
            data = new GridData(4, 4, true, false, 3, 1);
            vncRadio.setLayoutData((Object)data);
            otherFields.add((Control)windowGroup);
            otherFields.add((Control)nativeRadio);
            otherFields.add((Control)vncRadio);
        }
        Label timeoutLabel = new Label((Composite)mainComposite, 8);
        timeoutLabel.setText(EmulatorNLS.UI_PropertiesMainComposite_TimeoutLabel);
        data = new GridData(16384, 0x1000000, false, false);
        timeoutLabel.setLayoutData((Object)data);
        final Text timeoutText = new Text((Composite)mainComposite, 2052);
        otherFields.add((Control)timeoutText);
        timeoutText.setText(this.timeout);
        data = new GridData(4, 128, true, false);
        timeoutText.setLayoutData((Object)data);
        timeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertiesMainComposite.this.timeout = timeoutText.getText().trim();
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        this.addInstanceListener(otherFields);
        this.updateWidgetEnableStatus(areOtherFieldsEditable, otherFields);
    }

    protected void openNetworkPreferences() {
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode networkNode = null;
        for (IPreferenceNode node : manager.getElements(0)) {
            if (!node.getId().equals(ORG_ECLIPSE_UI_NET_NET_PREFERENCES)) continue;
            networkNode = node;
            break;
        }
        PreferenceManager prefMan = new PreferenceManager();
        if (networkNode != null) {
            prefMan.addToRoot(networkNode);
        }
        WorkbenchPreferenceDialog networkPreferencesDialog = new WorkbenchPreferenceDialog(this.getShell(), prefMan);
        networkPreferencesDialog.create();
        networkPreferencesDialog.open();
    }

    private void createNotEditableVmUI() {
        PropertiesMainComposite mainComposite = this;
        Label tagetLabel = new Label((Composite)mainComposite, 8);
        tagetLabel.setText(EmulatorNLS.UI_PropertiesMainComposite_TargetLabel);
        GridData data = new GridData(16384, 0x1000000, false, false);
        tagetLabel.setLayoutData((Object)data);
        Text targetText = new Text((Composite)mainComposite, 72);
        targetText.setText(this.vmTarget.getName());
        data = new GridData(4, 128, true, false);
        targetText.setLayoutData((Object)data);
        Label abiTypeLabel = new Label((Composite)mainComposite, 8);
        abiTypeLabel.setText(EmulatorNLS.PropertiesMainComposite_ABITypeLabel);
        data = new GridData(16384, 0x1000000, false, false);
        abiTypeLabel.setLayoutData((Object)data);
        AvdManager manager = SdkUtils.getVmManager();
        AvdInfo avd = manager.getAvd(this.name, true);
        Text abiTypeText = new Text((Composite)mainComposite, 72);
        abiTypeText.setText(AvdInfo.getPrettyAbiType((AvdInfo)avd));
        data = new GridData(4, 128, true, false);
        abiTypeText.setLayoutData((Object)data);
        Label skinLabel = new Label((Composite)mainComposite, 8);
        skinLabel.setText(EmulatorNLS.UI_PropertiesMainComposite_SkinLabel);
        data = new GridData(16384, 0x1000000, false, false);
        skinLabel.setLayoutData((Object)data);
        Text vmSkinText = new Text((Composite)mainComposite, 72);
        vmSkinText.setText(this.vmSkin);
        data = new GridData(4, 128, true, false);
        vmSkinText.setLayoutData((Object)data);
        Label pathLabel = new Label((Composite)mainComposite, 8);
        pathLabel.setText(EmulatorNLS.UI_PropertiesMainComposite_PathLabel);
        data = new GridData(16384, 0x1000000, false, false);
        pathLabel.setLayoutData((Object)data);
        Text pathText = new Text((Composite)mainComposite, 72);
        pathText.setText(this.vmPath);
        data = new GridData(4, 128, true, false);
        data.widthHint = 100;
        pathText.setLayoutData((Object)data);
        AvdInfo vmInfo = SdkUtils.getValidVm((String)this.name);
        Properties configFile = new Properties();
        BufferedReader input = null;
        try {
            try {
                Text sdCardPathText;
                Label sdCardPathLabel;
                input = new BufferedReader(new FileReader(vmInfo.getConfigFile()));
                String line = null;
                String[] property = null;
                while ((line = input.readLine()) != null) {
                    property = line.split("=");
                    if (property[0] == null || property[1] == null || property[0].equals("") || property[1].equals("")) continue;
                    configFile.put(property[0], property[1]);
                }
                if (configFile.getProperty("sdcard.path") != null) {
                    sdCardPathLabel = new Label((Composite)mainComposite, 8);
                    sdCardPathLabel.setText(EmulatorNLS.UI_PropertiesMainComposite_SDCardPathLabel);
                    data = new GridData(16384, 0x1000000, false, false);
                    sdCardPathLabel.setLayoutData((Object)data);
                    sdCardPathText = new Text((Composite)mainComposite, 72);
                    sdCardPathText.setText(configFile.getProperty("sdcard.path"));
                    data = new GridData(4, 128, true, false);
                    data.widthHint = 100;
                    sdCardPathText.setLayoutData((Object)data);
                }
                if (configFile.getProperty("sdcard.size") != null) {
                    sdCardPathLabel = new Label((Composite)mainComposite, 8);
                    sdCardPathLabel.setText(EmulatorNLS.UI_PropertiesMainComposite_SDCardSizeLabel);
                    data = new GridData(16384, 0x1000000, false, false);
                    sdCardPathLabel.setLayoutData((Object)data);
                    sdCardPathText = new Text((Composite)mainComposite, 72);
                    sdCardPathText.setText(configFile.getProperty("sdcard.size"));
                    data = new GridData(4, 128, true, false);
                    sdCardPathText.setLayoutData((Object)data);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                AndmoreLogger.error((String)("Could not find config file for AVD: " + this.name));
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)"Could not close input stream: ", (String)e.getMessage());
                }
            }
            catch (IOException iOException) {
                AndmoreLogger.error((String)("Could not read config file for AVD: " + this.name));
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)"Could not close input stream: ", (String)e.getMessage());
                }
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                AndmoreLogger.error((String)"Could not close input stream: ", (String)e.getMessage());
            }
        }
    }

    private void createEditableVmUI() {
        PropertiesMainComposite mainComposite = this;
        Label tagetLabel = new Label((Composite)mainComposite, 8);
        tagetLabel.setText(EmulatorNLS.UI_PropertiesMainComposite_TargetLabel);
        GridData data = new GridData(16384, 0x1000000, false, false);
        tagetLabel.setLayoutData((Object)data);
        final Combo targetCombo = new Combo((Composite)mainComposite, 8);
        this.populateTargetCombo(targetCombo);
        data = new GridData(4, 128, true, false, 1, 1);
        targetCombo.setLayoutData((Object)data);
        Label skinLabel = new Label((Composite)mainComposite, 8);
        skinLabel.setText(EmulatorNLS.UI_PropertiesMainComposite_SkinLabel);
        data = new GridData(16384, 0x1000000, false, false);
        skinLabel.setLayoutData((Object)data);
        final Combo vmSkinCombo = new Combo((Composite)mainComposite, 8);
        this.populateSkinCombo(vmSkinCombo);
        data = new GridData(4, 128, true, false, 1, 1);
        vmSkinCombo.setLayoutData((Object)data);
        vmSkinCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (vmSkinCombo != null && !"".equals(vmSkinCombo.getText())) {
                    PropertiesMainComposite.this.vmSkin = (String)vmSkinCombo.getData(vmSkinCombo.getText());
                } else {
                    PropertiesMainComposite.this.vmSkin = "";
                }
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        Label abiTypeLabel = new Label((Composite)mainComposite, 8);
        abiTypeLabel.setText(EmulatorNLS.PropertiesMainComposite_ABITypeLabel);
        data = new GridData(16384, 0x1000000, false, false);
        abiTypeLabel.setLayoutData((Object)data);
        this.abiTypeCombo = new Combo((Composite)mainComposite, 8);
        this.populateAbiTypeCombo(this.abiTypeCombo);
        data = new GridData(4, 128, true, false, 1, 1);
        this.abiTypeCombo.setLayoutData((Object)data);
        this.abiTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (vmSkinCombo != null && !"".equals(vmSkinCombo.getText())) {
                    PropertiesMainComposite.this.abiType = (String)PropertiesMainComposite.this.abiTypeCombo.getData(PropertiesMainComposite.this.abiTypeCombo.getText());
                } else {
                    PropertiesMainComposite.this.abiType = "armeabi";
                }
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        targetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IAndroidTarget newTarget = null;
                if (targetCombo != null && !"".equals(targetCombo.getText())) {
                    newTarget = (IAndroidTarget)targetCombo.getData(targetCombo.getText());
                }
                if (newTarget != PropertiesMainComposite.this.vmTarget) {
                    PropertiesMainComposite.this.vmTarget = newTarget;
                    PropertiesMainComposite.this.populateSkinCombo(vmSkinCombo);
                    PropertiesMainComposite.this.populateAbiTypeCombo(PropertiesMainComposite.this.abiTypeCombo);
                    PropertiesMainComposite.this.notifyCompositeChangeListeners();
                }
            }
        });
        Group vmPathGroup = new Group((Composite)mainComposite, 8);
        vmPathGroup.setText(EmulatorNLS.UI_PropertiesMainComposite_PathGroupTitle);
        data = new GridData(4, 4, true, false, 2, 1);
        vmPathGroup.setLayoutData((Object)data);
        vmPathGroup.setLayout((Layout)new GridLayout(3, false));
        this.usingDefaultVmPath = this.vmPath.equals(IDevicePropertiesConstants.defaultVmPath);
        final Button vmPathCheckbox = new Button((Composite)vmPathGroup, 32);
        vmPathCheckbox.setText(EmulatorNLS.UI_PropertiesMainComposite_UseDefaultPath);
        vmPathCheckbox.setSelection(this.usingDefaultVmPath);
        data = new GridData(4, 4, true, false, 3, 1);
        vmPathCheckbox.setLayoutData((Object)data);
        Label pathLabel = new Label((Composite)vmPathGroup, 8);
        pathLabel.setText(EmulatorNLS.UI_PropertiesMainComposite_PathLabel);
        data = new GridData(16384, 0x1000000, false, false);
        pathLabel.setLayoutData((Object)data);
        final Text pathText = new Text((Composite)vmPathGroup, 2052);
        pathText.setText(this.vmPath);
        pathText.setEnabled(!this.usingDefaultVmPath);
        data = new GridData(4, 128, true, false);
        data.widthHint = 100;
        pathText.setLayoutData((Object)data);
        final Button pathBrowseButton = new Button((Composite)vmPathGroup, 8);
        pathBrowseButton.setText(EmulatorNLS.UI_General_BrowseButtonLabel);
        pathBrowseButton.setEnabled(!this.usingDefaultVmPath);
        data = new GridData(4, 4, false, false);
        pathBrowseButton.setLayoutData((Object)data);
        vmPathCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesMainComposite.this.usingDefaultVmPath = vmPathCheckbox.getSelection();
                pathText.setEnabled(!PropertiesMainComposite.this.usingDefaultVmPath);
                pathBrowseButton.setEnabled(!PropertiesMainComposite.this.usingDefaultVmPath);
                if (PropertiesMainComposite.this.usingDefaultVmPath) {
                    PropertiesMainComposite.this.vmPath = IDevicePropertiesConstants.defaultVmPath;
                }
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertiesMainComposite.this.vmPath = pathText.getText().trim();
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        pathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(PropertiesMainComposite.this.getShell(), 4096);
                if (!PropertiesMainComposite.this.vmPath.trim().equals("")) {
                    dirDialog.setFilterPath(PropertiesMainComposite.this.vmPath);
                } else {
                    dirDialog.setFilterPath("/");
                }
                dirDialog.setText(EmulatorNLS.UI_PropertiesMainComposite_PathGroupTitle);
                String vmPath = dirDialog.open();
                if (vmPath != null) {
                    pathText.setText(vmPath);
                    PropertiesMainComposite.this.notifyCompositeChangeListeners();
                }
            }
        });
        this.sdCardType = SDCARD_TYPE_NONE;
        Group sdCardGroup = new Group((Composite)mainComposite, 8);
        sdCardGroup.setText(EmulatorNLS.UI_PropertiesMainComposite_SDCardLabel);
        data = new GridData(4, 4, true, false, 2, 1);
        sdCardGroup.setLayoutData((Object)data);
        sdCardGroup.setLayout((Layout)new GridLayout(3, false));
        Button noneSDCardCheckbox = new Button((Composite)sdCardGroup, 16);
        noneSDCardCheckbox.setText(EmulatorNLS.UI_PropertiesMainComposite_SDCardNoneLabel);
        noneSDCardCheckbox.setSelection(true);
        data = new GridData(4, 4, true, false, 3, 1);
        noneSDCardCheckbox.setLayoutData((Object)data);
        noneSDCardCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesMainComposite.this.sdCardType = PropertiesMainComposite.SDCARD_TYPE_NONE;
                PropertiesMainComposite.this.sdCardValue = "";
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        final Button existingSDCardCheckbox = new Button((Composite)sdCardGroup, 16);
        existingSDCardCheckbox.setText(EmulatorNLS.UI_PropertiesMainComposite_SDCardExistingLabel);
        final Text existingSDCardPath = new Text((Composite)sdCardGroup, 2052);
        data = new GridData(4, 128, true, false);
        data.widthHint = 100;
        existingSDCardPath.setLayoutData((Object)data);
        existingSDCardPath.setEnabled(false);
        final Button existingSDCardButton = new Button((Composite)sdCardGroup, 8);
        existingSDCardButton.setText(EmulatorNLS.UI_General_BrowseButtonLabel);
        data = new GridData(4, 4, false, false);
        existingSDCardButton.setLayoutData((Object)data);
        existingSDCardButton.setEnabled(false);
        existingSDCardCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesMainComposite.this.sdCardType = PropertiesMainComposite.SDCARD_TYPE_PATH;
                existingSDCardPath.setEnabled(existingSDCardCheckbox.getSelection());
                existingSDCardButton.setEnabled(existingSDCardCheckbox.getSelection());
                PropertiesMainComposite.this.sdCardValue = existingSDCardPath.getText();
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        existingSDCardPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertiesMainComposite.this.sdCardValue = existingSDCardPath.getText();
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        existingSDCardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedPath = null;
                FileDialog fileDialog = new FileDialog(PropertiesMainComposite.this.getShell(), 4096);
                String[] filterExtensions = new String[]{"*.img"};
                fileDialog.setFilterExtensions(filterExtensions);
                selectedPath = fileDialog.open();
                if (selectedPath != null) {
                    existingSDCardPath.setText(selectedPath);
                }
            }
        });
        final Button newSDCardCheckbox = new Button((Composite)sdCardGroup, 16);
        newSDCardCheckbox.setText(EmulatorNLS.UI_PropertiesMainComposite_SDCardNewLabel);
        final Text newSDCardSize = new Text((Composite)sdCardGroup, 2052);
        data = new GridData(4, 128, true, false);
        data.widthHint = 100;
        newSDCardSize.setLayoutData((Object)data);
        newSDCardSize.setEnabled(false);
        final Combo newSDCardUnit = new Combo((Composite)sdCardGroup, 8);
        String[] stringArray = SDCARD_SIZE_UNITS;
        int n = SDCARD_SIZE_UNITS.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            newSDCardUnit.add(unit);
            ++n2;
        }
        newSDCardUnit.select(0);
        newSDCardUnit.setEnabled(false);
        data = new GridData(4, 4, false, false);
        newSDCardUnit.setLayoutData((Object)data);
        newSDCardCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesMainComposite.this.sdCardType = PropertiesMainComposite.SDCARD_TYPE_SIZE;
                PropertiesMainComposite.this.sdCardValue = newSDCardSize.getText();
                newSDCardSize.setEnabled(newSDCardCheckbox.getSelection());
                newSDCardUnit.setEnabled(newSDCardCheckbox.getSelection());
                PropertiesMainComposite.this.sdCardValue = String.valueOf(newSDCardSize.getText()) + newSDCardUnit.getText().charAt(0);
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        });
        ModifyListener newSDCardListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertiesMainComposite.this.sdCardValue = String.valueOf(newSDCardSize.getText()) + newSDCardUnit.getText().charAt(0);
                PropertiesMainComposite.this.notifyCompositeChangeListeners();
            }
        };
        newSDCardSize.addModifyListener(newSDCardListener);
        newSDCardUnit.addModifyListener(newSDCardListener);
    }

    private void populateAbiTypeCombo(Combo abiTypeCombo) {
        ISystemImage[] images = this.vmTarget.getSystemImages();
        if (images == null || images.length == 0 && !this.vmTarget.isPlatform()) {
            images = this.vmTarget.getParent().getSystemImages();
        }
        abiTypeCombo.removeAll();
        int i = 0;
        if (images != null && images.length > 0) {
            ISystemImage[] iSystemImageArray = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                ISystemImage image = iSystemImageArray[n2];
                String prettyAbiName = AvdInfo.getPrettyAbiType((ISystemImage)image);
                abiTypeCombo.add(prettyAbiName);
                abiTypeCombo.setData(prettyAbiName, (Object)image.getAbiType());
                if (image.getAbiType().equals(this.abiType)) {
                    abiTypeCombo.select(i);
                }
                ++i;
                ++n2;
            }
            if (abiTypeCombo.getSelectionIndex() == -1) {
                abiTypeCombo.select(0);
                this.abiType = (String)abiTypeCombo.getData(abiTypeCombo.getItem(0));
            }
        }
    }

    private void populateTargetCombo(Combo targetCombo) {
        IAndroidTarget[] targets = SdkUtils.getAllTargets();
        if (targets != null && targets.length > 0) {
            int i = 0;
            while (i < targets.length) {
                String label = targets[i].isPlatform() ? targets[i].getName() : String.valueOf(targets[i].getName()) + " (" + targets[i].getParent().getName() + ")";
                targetCombo.add(label);
                targetCombo.setData(label, (Object)targets[i]);
                if (targets[i].getName().equals(this.vmTarget.getName())) {
                    targetCombo.select(i);
                }
                ++i;
            }
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.andmore.android.emulator.newdevmain");
    }

    private void populateSkinCombo(Combo skinCombo) {
        skinCombo.removeAll();
        skinCombo.clearSelection();
        if (this.vmTarget != null) {
            File[] skins = this.vmTarget.getSkins();
            File defaultSkin = this.vmTarget.getDefaultSkin();
            int i = 0;
            while (i < skins.length) {
                skinCombo.add(skins[i].getName());
                skinCombo.setData(skins[i].getName(), (Object)skins[i].getName());
                if (skins[i].equals(defaultSkin)) {
                    skinCombo.select(i);
                    this.vmSkin = defaultSkin.getName();
                }
                ++i;
            }
            if (skinCombo.getSelectionIndex() < 0 && skinCombo.getItemCount() > 0) {
                skinCombo.select(0);
                this.vmSkin = skinCombo.getItem(0);
            }
            skinCombo.setEnabled(true);
        } else {
            skinCombo.setEnabled(false);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.andmore.android.emulator.newdevmain");
    }

    public String getSkinId() {
        return this.skinId;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public String getUseVnc() {
        return this.useVnc ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }

    public String getUseProxy() {
        return this.useProxy ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }

    @Override
    public String getErrorMessage() {
        File vmPathLocation;
        String errorMessage = null;
        if ("".equals(this.vmTarget)) {
            errorMessage = EmulatorNLS.ERR_PropertiesMainComposite_VmTargetEmpty;
        } else if ("".equals(this.vmSkin)) {
            errorMessage = EmulatorNLS.ERR_PropertiesMainComposite_VmSkinEmpty;
        } else if (!(this.usingDefaultVmPath || (vmPathLocation = new File(this.vmPath)).exists() && vmPathLocation.isDirectory())) {
            errorMessage = EmulatorNLS.ERR_PropertiesMainComposite_VmPathInvalid;
        }
        if (errorMessage == null && this.abiTypeCombo != null && (this.abiTypeCombo.getItemCount() == 0 || this.abiTypeCombo.getSelectionIndex() == -1)) {
            errorMessage = EmulatorNLS.ERR_PropertiesMainComposite_ABINotAvailable;
        }
        if (errorMessage == null) {
            if (this.sdCardType.equalsIgnoreCase(SDCARD_TYPE_PATH)) {
                if (this.sdCardValue == null) {
                    errorMessage = EmulatorNLS.ERR_PropertiesMainComposite_MissingSDCardPath;
                } else if (!this.isValidSDCard(this.sdCardValue)) {
                    errorMessage = EmulatorNLS.ERR_PropertiesMainComposite_SDCardPathIsNotValid;
                }
            } else if (this.sdCardType.equalsIgnoreCase(SDCARD_TYPE_SIZE)) {
                String unit;
                int sdcardSize = -1;
                String string = unit = this.sdCardValue.length() > 0 ? this.sdCardValue.substring(this.sdCardValue.length() - 1).toLowerCase() : "k";
                if (this.sdCardValue == null || this.sdCardValue.equals("")) {
                    errorMessage = EmulatorNLS.ERR_PropertiesMainComposite_MissingSDCardSize;
                } else {
                    try {
                        sdcardSize = Integer.parseInt(this.sdCardValue.substring(0, this.sdCardValue.length() - 1));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (unit.equals("m") && sdcardSize < 9 || unit.equals("k") && sdcardSize < 9216) {
                        errorMessage = EmulatorNLS.ERR_PropertiesMainComposite_SDCardSizeIsNotPositiveInteger;
                    }
                }
            }
        }
        if (errorMessage == null) {
            if (this.timeout.equals("")) {
                errorMessage = EmulatorNLS.ERR_PropertiesMainComposite_MissingTimeoutValue;
            } else if (!this.isPositiveInteger(this.timeout)) {
                errorMessage = EmulatorNLS.ERR_PropertiesMainComposite_TimeoutValueIsNotPositiveInteger;
            }
        }
        return errorMessage;
    }

    private boolean isValidSDCard(String text) {
        boolean result = true;
        File file = new File(text);
        if (!file.exists() || file.isDirectory() || !SDCARD_PATH_EXTENSION.equals("." + new Path(text).getFileExtension())) {
            result = false;
        }
        return result;
    }

    private boolean isPositiveInteger(String text) {
        int intValue = 0;
        boolean isPositive = true;
        try {
            intValue = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            isPositive = false;
        }
        if (intValue <= 0) {
            isPositive = false;
        }
        return isPositive;
    }

    public IAndroidTarget getVmTarget() {
        return this.vmTarget;
    }

    public String getAbiType() {
        return this.abiType != null ? this.abiType : "armeabi";
    }

    public String getVmSkin() {
        return this.vmSkin;
    }

    public String getVmPath() {
        return String.valueOf(this.vmPath) + File.separator + this.name + ".avd";
    }

    public String getSDCard() {
        return this.sdCardValue;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public String getUseSnapshot() {
        return this.useSnapshots ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }

    public String getstartFromSnapshot() {
        return this.startFromSnapshots ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }

    public String getSaveSnapshot() {
        return this.saveSnapshots ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }
}

