/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStartException;
import org.eclipse.andmore.android.emulator.core.exception.StartCancelledException;
import org.eclipse.andmore.android.emulator.core.exception.StartTimeoutException;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogic;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractStartAndroidEmulatorLogic
implements IAndroidLogic {
    @Override
    public final void execute(IAndroidLogicInstance instance, int timeout, IProgressMonitor monitor) throws InstanceStartException, StartCancelledException, StartTimeoutException, IOException {
        this.execute(instance, LogicMode.START_MODE, timeout, monitor);
    }

    public final void execute(IAndroidLogicInstance instance, LogicMode mode, int timeout, IProgressMonitor monitor) throws InstanceStartException, StartCancelledException, StartTimeoutException, IOException {
        for (IAndroidLogic logic : this.getLogicCollection(instance, mode)) {
            long timeoutLimit = AndroidLogicUtils.getTimeoutLimit(timeout);
            AndroidLogicUtils.testCanceled(monitor);
            AndroidLogicUtils.testTimeout(timeoutLimit, NLS.bind((String)EmulatorNLS.EXC_TimeoutWhileStarting, (Object)instance.getName()));
            AndmoreLogger.info((String)("Executing " + logic.getClass().getSimpleName() + " for " + instance));
            long startTime = System.currentTimeMillis();
            logic.execute(instance, timeout, monitor);
            long endTime = System.currentTimeMillis();
            int duration = (int)(endTime - startTime);
            timeout -= duration;
        }
    }

    public abstract Collection<IAndroidLogic> getLogicCollection(IAndroidLogicInstance var1, LogicMode var2);

    public static enum LogicMode {
        START_MODE,
        TRANSFER_AND_CONNECT_VNC,
        RESTART_VNC_SERVER,
        DO_NOTHING;

    }
}

