/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStartException;
import org.eclipse.andmore.android.emulator.core.exception.StartCancelledException;
import org.eclipse.andmore.android.emulator.core.exception.StartTimeoutException;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class AndroidLogicUtils {
    private static final int INITIAL_VNC_PORT_VALUE = 5900;
    public static final String ORIENTATION_BASE_COMMAND = "sendevent /dev/input/event0 ";

    public static Process executeProcess(String cmd) throws AndroidException {
        try {
            AndmoreLogger.info((String)("Executing command " + cmd));
            Process vmProcess = Runtime.getRuntime().exec(cmd);
            return vmProcess;
        }
        catch (IOException iOException) {
            AndmoreLogger.error((String)("Falied to execute the command: " + cmd));
            throw new AndroidException(NLS.bind((String)EmulatorNLS.EXC_AndroidLogicUtils_CannotStartProcess, (Object)cmd));
        }
    }

    public static Process executeProcess(String[] cmd) throws AndroidException {
        String cmdString = "";
        int i = 0;
        while (i < cmd.length) {
            cmdString = String.valueOf(cmdString) + cmd[i] + " ";
            ++i;
        }
        return AndroidLogicUtils.executeProcess(cmd, cmdString);
    }

    public static Process executeProcess(String[] cmd, String cmdToLog) throws AndroidException {
        try {
            AndmoreLogger.info((String)("Executing command " + cmdToLog));
            Process vmProcess = Runtime.getRuntime().exec(cmd);
            return vmProcess;
        }
        catch (IOException iOException) {
            AndmoreLogger.error((String)("Falied to execute the command: " + cmd));
            throw new AndroidException(NLS.bind((String)EmulatorNLS.EXC_AndroidLogicUtils_CannotStartProcess, (Object[])cmd));
        }
    }

    public static void testCanceled(IProgressMonitor monitor) throws StartCancelledException {
        if (monitor.isCanceled()) {
            AndmoreLogger.info((String)"Operation canceled by the user");
            monitor.subTask(EmulatorNLS.MON_AndroidEmulatorStarter_Canceling);
            throw new StartCancelledException(EmulatorNLS.EXC_AndroidEmulatorStarter_EmulatorStartCanceled);
        }
    }

    public static void testTimeout(long timeoutLimit, String timeoutErrorMessage) throws StartTimeoutException {
        if (System.currentTimeMillis() > timeoutLimit) {
            AndmoreLogger.error((String)"The emulator was not up within the set timeout");
            throw new StartTimeoutException(timeoutErrorMessage);
        }
    }

    public static long getTimeoutLimit(int timeout) {
        return System.currentTimeMillis() + (long)timeout;
    }

    public static void testProcessStatus(Process p) throws InstanceStartException {
        boolean isRunning;
        int exitCode;
        try {
            exitCode = p.exitValue();
            isRunning = false;
        }
        catch (Exception exception) {
            isRunning = true;
            exitCode = 0;
        }
        if (!isRunning) {
            int ch;
            AndmoreLogger.error((String)("Emulator process is not running! Exit code:" + exitCode));
            StringBuffer outBuf = null;
            InputStream inStream = null;
            String processAnswer = "";
            inStream = p.getErrorStream();
            outBuf = new StringBuffer();
            try {
                while ((ch = inStream.read()) != -1) {
                    outBuf.append(String.valueOf((char)ch));
                }
            }
            catch (IOException iOException) {
                AndmoreLogger.error((String)"Cannot read error output  stream from Emulator proccess");
            }
            processAnswer = outBuf.toString();
            if (processAnswer.length() == 0) {
                inStream = p.getInputStream();
                outBuf = new StringBuffer();
                try {
                    while ((ch = inStream.read()) != -1) {
                        outBuf.append(String.valueOf((char)ch));
                    }
                }
                catch (IOException iOException) {
                    AndmoreLogger.error((String)"Cannot read standard output stream from Emulator proccess");
                }
                processAnswer = outBuf.toString();
            }
            String msg = EmulatorNLS.EXC_AndroidEmulatorStarter_ProcessTerminated;
            msg = String.valueOf(msg) + processAnswer;
            throw new InstanceStartException(msg);
        }
    }

    public static void kill(IAndroidLogicInstance instance) {
        if (instance instanceof ISerialNumbered) {
            String serialNumber = ((ISerialNumbered)instance).getSerialNumber();
            DDMSFacade.kill((String)serialNumber);
            Process process = instance.getProcess();
            if (process != null) {
                int tries = 0;
                Integer exitValue = null;
                while (process != null && tries < 10 && exitValue == null) {
                    try {
                        exitValue = process.exitValue();
                    }
                    catch (Throwable throwable) {
                        ++tries;
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                process.destroy();
                instance.setProcess(null);
            }
        }
    }

    public static int getVncServerPortFoward(String serial) {
        if (serial == null) {
            return 0;
        }
        int stringSize = serial.length();
        String lastTwoNumbers = serial.substring(stringSize - 2, stringSize);
        int port = 5900;
        try {
            port += Integer.valueOf(lastTwoNumbers).intValue();
        }
        catch (NumberFormatException numberFormatException) {}
        return port;
    }

    public static int getEmulatorPort(String serial) {
        if (serial == null) {
            return 0;
        }
        int stringSize = serial.length();
        String lastFourNumbers = serial.substring(stringSize - 4, stringSize);
        int port = 0;
        try {
            port = Integer.valueOf(lastFourNumbers);
        }
        catch (NumberFormatException numberFormatException) {}
        return port;
    }

    public static void testDeviceStatus(String serialNumber) throws AndroidException {
        if (!DDMSFacade.isDeviceOnline((String)serialNumber)) {
            AndmoreLogger.info((String)("Device is offline: " + serialNumber));
            throw new AndroidException(EmulatorNLS.EXC_AndroidLogicUtils_DeviceIsOffline);
        }
    }
}

