/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.handlers;

import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.ui.view.AbstractAndroidView;
import org.eclipse.andmore.android.emulator.ui.view.AndroidView;
import org.eclipse.andmore.android.nativeos.NativeUIUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.IViewPart;

public class ChangeEmulatorOrientationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IAndroidEmulatorInstance instance = AbstractAndroidView.getActiveInstance();
        if (instance != null) {
            IViewPart viewPart;
            String viewId = event.getParameter("activeViewId");
            if (instance != null && viewId != null && (viewPart = EclipseUtils.getActiveView((String)viewId)) instanceof AndroidView) {
                if (instance.getProperties().getProperty("UseVnc", NativeUIUtils.getDefaultUseVnc()).equals("true")) {
                    String nextLayout = AbstractAndroidView.getPreviousOrNextLayout(viewId, AbstractAndroidView.LayoutOpp.NEXT);
                    AbstractAndroidView.changeLayout(nextLayout);
                    IAndroidSkin skin = ((AbstractAndroidView)viewPart).getSkin(instance);
                    String cmd = skin.getLayoutScreenCommand(instance.getCurrentLayout());
                    instance.changeOrientation(cmd);
                } else {
                    AndroidView androidView = (AndroidView)viewPart;
                    androidView.changeToNextLayout();
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return AbstractAndroidView.getActiveInstance() != null;
    }
}

