/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.view;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.ui.view.AbstractAndroidView;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class LayoutContributionItem
extends CompoundContributionItem {
    public static final String ANDROID_VIEW_LAYOUT_DYNAMIC_ID = "androidView.layout.dynamic";
    public static final String MAIN_DISPLAY_VIEW_LAYOUT_DYNAMIC_ID = "mainDisplayView.layout.dynamic";

    protected IContributionItem[] getContributionItems() {
        IContributionItem[] itemsArray;
        AbstractAndroidView view = null;
        String viewId = null;
        if (this.getId().equals(ANDROID_VIEW_LAYOUT_DYNAMIC_ID)) {
            viewId = "org.eclipse.andmore.android.emulator.androidView";
            view = (AbstractAndroidView)EclipseUtils.getActiveView((String)viewId);
        } else if (this.getId().equals(MAIN_DISPLAY_VIEW_LAYOUT_DYNAMIC_ID)) {
            viewId = "org.eclipse.andmore.android.emulator.mainDisplayView";
            view = (AbstractAndroidView)EclipseUtils.getActiveView((String)viewId);
        }
        if (view != null) {
            IAndroidEmulatorInstance instance = AbstractAndroidView.getActiveInstance();
            IAndroidSkin skin = view.getSkin(instance);
            if (skin != null) {
                Collection<String> layoutNames = skin.getAvailableLayouts();
                itemsArray = new IContributionItem[layoutNames.size()];
                this.populateContributionList(itemsArray, layoutNames, viewId);
            } else {
                itemsArray = new IContributionItem[1];
                this.populateWithEmpty(itemsArray);
            }
        } else {
            itemsArray = new IContributionItem[1];
            this.populateWithEmpty(itemsArray);
        }
        return itemsArray;
    }

    private void populateContributionList(IContributionItem[] itemsArray, Collection<String> layoutNames, String viewId) {
        int i = 0;
        for (String layoutName : layoutNames) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("activeViewId", viewId);
            String id = "org.eclipse.andmore.android.emulator.layoutcmd." + layoutName;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            CommandContributionItemParameter itemParam = new CommandContributionItemParameter((IServiceLocator)window, id, "org.eclipse.andmore.android.emulator.ui.change.layout", params, null, null, null, layoutName, null, null, 16, null, true);
            itemsArray[i++] = new CommandContributionItem(itemParam);
        }
    }

    private void populateWithEmpty(IContributionItem[] itemsArray) {
        String id = "org.eclipse.andmore.android.emulator.emptylayout";
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        CommandContributionItemParameter itemParam = new CommandContributionItemParameter((IServiceLocator)window, id, "org.eclipse.andmore.android.emulator.ui.change.layout", new HashMap(), null, null, null, EmulatorNLS.UI_LayoutContributionItem_NoLayoutsAvailable, null, null, 16, null, false);
        itemsArray[0] = new CommandContributionItem(itemParam);
    }
}

