/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.logger.collector.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class WidgetsUtil {
    private static boolean isNullOrEmpty(String s) {
        return s != null && s.trim().equals("");
    }

    public static boolean fileExist(String fileName) {
        return !WidgetsUtil.isNullOrEmpty(fileName) && new File(fileName).exists();
    }

    public static boolean isNullOrEmpty(StringFieldEditor ... editors) {
        StringFieldEditor[] stringFieldEditorArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            StringFieldEditor editor = stringFieldEditorArray[n2];
            if (WidgetsUtil.isNullOrEmpty(editor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNullOrEmpty(StringFieldEditor editor) {
        return editor != null && WidgetsUtil.isNullOrEmpty(editor.getStringValue());
    }

    public static boolean checkExistInvalidCharacter(StringFieldEditor editor, String invalidChars) {
        int i = 0;
        while (i < invalidChars.length()) {
            String invalidChar = invalidChars.substring(i, i + 1);
            if (editor.getStringValue().contains(invalidChar)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isNullOrEmpty(Text text) {
        return text != null && WidgetsUtil.isNullOrEmpty(text.getText());
    }

    public static boolean isEmpty(FileFieldEditor editor) {
        return WidgetsUtil.isNullOrEmpty(editor.getStringValue());
    }

    public static boolean isNullOrDeselected(Combo combo) {
        return combo != null && combo.getSelectionIndex() == -1;
    }

    public static long fileSize(String fileName) {
        return new File(fileName).length();
    }

    public static boolean isNullOrEmpty(Table table) {
        return table.getItemCount() > 0;
    }

    public static boolean runWizard(IWizard wizard) {
        Shell activeShell = Display.getCurrent().getActiveShell();
        WizardDialog dialog = new WizardDialog(activeShell, wizard);
        try {
            dialog.create();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        WidgetsUtil.centerDialog((Dialog)dialog);
        return dialog.open() == 0;
    }

    public static boolean runPreferencePage(Shell shell, String selectedNode) {
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        PreferenceDialog dialog = new PreferenceDialog(shell, manager);
        dialog.setSelectedNode(selectedNode);
        WidgetsUtil.centerDialog(shell);
        return dialog.open() == 0;
    }

    public static void centerDialog(Shell shell) {
        Monitor primary = shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    public static void centerDialog(Dialog dialog) {
        WidgetsUtil.centerDialog(dialog.getShell());
    }

    public static List<TreeItem> getCheckedLeafItems(Tree tree) {
        ArrayList<TreeItem> toReturn = new ArrayList<TreeItem>();
        WidgetsUtil.selectCheckedLeafItems(tree.getItems(), toReturn);
        return toReturn;
    }

    private static void selectCheckedLeafItems(TreeItem[] items, List<TreeItem> list) {
        int len = items.length;
        int i = 0;
        while (i < len) {
            if (items[i].getItemCount() > 0) {
                WidgetsUtil.selectCheckedLeafItems(items[i].getItems(), list);
            } else if (items[i].getChecked()) {
                list.add(items[i]);
            }
            ++i;
        }
    }

    public static void expandAll(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i].getItems().length > 0) {
                items[i].setExpanded(true);
                WidgetsUtil.expandAll(items[i].getItems());
            }
            ++i;
        }
    }

    public static String getFullPathTreeItem(TreeItem item) {
        String toReturn = item.getText();
        if (item != null && item.getParentItem() != null) {
            toReturn = String.valueOf(WidgetsUtil.getFullPathTreeItem(item.getParentItem())) + "." + toReturn;
        }
        return toReturn;
    }

    public static boolean canRead(String fileName) {
        return !WidgetsUtil.isNullOrEmpty(fileName) && new File(fileName).canRead();
    }

    public static boolean canReadWrite(String fileName) {
        File file = new File(fileName);
        return file.canRead() && file.canWrite();
    }

    public static void refreshComposite(Composite composite) {
        Composite parent = composite.getParent();
        while (parent != null) {
            parent.layout();
            parent = parent.getParent();
        }
    }

    public static List<TableItem> getCheckedLeafItems(Table table) {
        ArrayList<TableItem> toReturn = new ArrayList<TableItem>();
        WidgetsUtil.selectCheckedLeafItems(table.getItems(), toReturn);
        return toReturn;
    }

    private static void selectCheckedLeafItems(TableItem[] items, List<TableItem> list) {
        int len = items.length;
        int i = 0;
        while (i < len) {
            if (items[i].getChecked()) {
                list.add(items[i]);
            }
            ++i;
        }
    }
}

